/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessEndpointPolicyRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessEndpointPolicyRequest>, ModifyVerifiedAccessEndpointPolicyRequest> {
    @Override
    public Request<ModifyVerifiedAccessEndpointPolicyRequest> marshall(ModifyVerifiedAccessEndpointPolicyRequest modifyVerifiedAccessEndpointPolicyRequest) {
        if (modifyVerifiedAccessEndpointPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVerifiedAccessEndpointPolicyRequest> request = new DefaultRequest<ModifyVerifiedAccessEndpointPolicyRequest>(modifyVerifiedAccessEndpointPolicyRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessEndpointPolicy");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessEndpointPolicyRequest.getVerifiedAccessEndpointId() != null) {
            request.addParameter("VerifiedAccessEndpointId", StringUtils.fromString(modifyVerifiedAccessEndpointPolicyRequest.getVerifiedAccessEndpointId()));
        }
        if (modifyVerifiedAccessEndpointPolicyRequest.getPolicyEnabled() != null) {
            request.addParameter("PolicyEnabled", StringUtils.fromBoolean(modifyVerifiedAccessEndpointPolicyRequest.getPolicyEnabled()));
        }
        if (modifyVerifiedAccessEndpointPolicyRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVerifiedAccessEndpointPolicyRequest.getPolicyDocument()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessEndpointPolicyRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = modifyVerifiedAccessEndpointPolicyRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean(sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString(sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

