/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessEndpointRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessEndpointRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessEndpointRequest>, ModifyVerifiedAccessEndpointRequest> {
    @Override
    public Request<ModifyVerifiedAccessEndpointRequest> marshall(ModifyVerifiedAccessEndpointRequest modifyVerifiedAccessEndpointRequest) {
        ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        if (modifyVerifiedAccessEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVerifiedAccessEndpointRequest> request = new DefaultRequest<ModifyVerifiedAccessEndpointRequest>(modifyVerifiedAccessEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessEndpointRequest.getVerifiedAccessEndpointId() != null) {
            request.addParameter("VerifiedAccessEndpointId", StringUtils.fromString(modifyVerifiedAccessEndpointRequest.getVerifiedAccessEndpointId()));
        }
        if (modifyVerifiedAccessEndpointRequest.getVerifiedAccessGroupId() != null) {
            request.addParameter("VerifiedAccessGroupId", StringUtils.fromString(modifyVerifiedAccessEndpointRequest.getVerifiedAccessGroupId()));
        }
        if ((loadBalancerOptions = modifyVerifiedAccessEndpointRequest.getLoadBalancerOptions()) != null) {
            SdkInternalList modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList = (SdkInternalList)loadBalancerOptions.getSubnetIds();
            if (!modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isEmpty() || !modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isAutoConstruct()) {
                int subnetIdsListIndex = 1;
                for (String modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue : modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList) {
                    if (modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue != null) {
                        request.addParameter("LoadBalancerOptions.SubnetId." + subnetIdsListIndex, StringUtils.fromString(modifyVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            }
            if (loadBalancerOptions.getProtocol() != null) {
                request.addParameter("LoadBalancerOptions.Protocol", StringUtils.fromString(loadBalancerOptions.getProtocol()));
            }
            if (loadBalancerOptions.getPort() != null) {
                request.addParameter("LoadBalancerOptions.Port", StringUtils.fromInteger(loadBalancerOptions.getPort()));
            }
        }
        if ((networkInterfaceOptions = modifyVerifiedAccessEndpointRequest.getNetworkInterfaceOptions()) != null) {
            if (networkInterfaceOptions.getProtocol() != null) {
                request.addParameter("NetworkInterfaceOptions.Protocol", StringUtils.fromString(networkInterfaceOptions.getProtocol()));
            }
            if (networkInterfaceOptions.getPort() != null) {
                request.addParameter("NetworkInterfaceOptions.Port", StringUtils.fromInteger(networkInterfaceOptions.getPort()));
            }
        }
        if (modifyVerifiedAccessEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(modifyVerifiedAccessEndpointRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessEndpointRequest.getClientToken()));
        return request;
    }
}

