/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.ResourceUri;

@SdkInternalApi
public class ResourceUriMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Uri").build();
    private static final ResourceUriMarshaller instance = new ResourceUriMarshaller();

    public static ResourceUriMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceUri resourceUri, ProtocolMarshaller protocolMarshaller) {
        if (resourceUri == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceUri.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(resourceUri.getUri(), URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

