/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateInstanceProfileRequestMarshaller
implements Marshaller<Request<CreateInstanceProfileRequest>, CreateInstanceProfileRequest> {
    @Override
    public Request<CreateInstanceProfileRequest> marshall(CreateInstanceProfileRequest createInstanceProfileRequest) {
        if (createInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstanceProfileRequest> request = new DefaultRequest<CreateInstanceProfileRequest>(createInstanceProfileRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceProfileRequest.getInstanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString(createInstanceProfileRequest.getInstanceProfileName()));
        }
        if (createInstanceProfileRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString(createInstanceProfileRequest.getPath()));
        }
        if (!createInstanceProfileRequest.getTags().isEmpty() || !((SdkInternalList)createInstanceProfileRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createInstanceProfileRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

