/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.ser;

import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.databind.SerializationFeature;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.databind.SerializerProvider;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.dataiku.dss.legacy.aws.org.joda.time.LocalDate;
import java.io.IOException;

public class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalDate.class, format, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalDateSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalDateSerializer(formatter, shapeOverride);
    }

    @Override
    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializationShape(provider) == 1) {
            gen.writeString(this._format.createFormatter(provider).print(value));
            return;
        }
        gen.writeStartArray();
        gen.writeNumber(value.year().get());
        gen.writeNumber(value.monthOfYear().get());
        gen.writeNumber(value.dayOfMonth().get());
        gen.writeEndArray();
    }
}

