/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.spnego;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.spnego.SpnegoHttpURLConnection;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpnegoSOAPConnection
extends SOAPConnection {
    private static final Logger LOGGER = Logger.getLogger(SpnegoSOAPConnection.class.getName());
    private final transient SpnegoHttpURLConnection conn;
    private final transient DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
    private final transient MessageFactory messageFactory;

    public SpnegoSOAPConnection(String loginModuleName) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(GSSCredential creds) {
        this(creds, true);
    }

    public SpnegoSOAPConnection(GSSCredential creds, boolean dispose) {
        this.conn = new SpnegoHttpURLConnection(creds, dispose);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(GSSCredential creds, boolean dispose, boolean confidential, boolean integrity) {
        this.conn = new SpnegoHttpURLConnection(creds, dispose);
        this.conn.setConfidentiality(confidential);
        this.conn.setMessageIntegrity(integrity);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public SpnegoSOAPConnection(String loginModuleName, String username, String password) throws LoginException {
        this.conn = new SpnegoHttpURLConnection(loginModuleName, username, password);
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new IllegalStateException(e);
        }
    }

    public final SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        LOGGER.fine("endpoint=" + endpoint);
        SOAPMessage message = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.conn.setRequestMethod("POST");
        try {
            MimeHeaders headers = request.getMimeHeaders();
            String[] contentType = headers.getHeader("Content-Type");
            String[] soapAction = headers.getHeader("SOAPAction");
            if (null == contentType) {
                StringBuilder header = new StringBuilder();
                if (null == soapAction) {
                    header.append("application/soap+xml; charset=UTF-8;");
                } else {
                    header.append("text/xml; charset=UTF-8;");
                }
                this.conn.addRequestProperty("Content-Type", header.toString());
            } else {
                if (contentType.length > 1) {
                    throw new IllegalArgumentException("Content-Type defined more than once.");
                }
                this.conn.addRequestProperty("Content-Type", contentType[0]);
            }
            if (null != soapAction) {
                if (soapAction.length > 1) {
                    throw new IllegalArgumentException("SOAPAction defined more than once.");
                }
                this.conn.addRequestProperty("SOAPAction", soapAction[0]);
            }
            request.writeTo((OutputStream)bos);
            this.conn.connect(new URL(endpoint.toString()), bos);
            message = this.createMessage(this.conn.getInputStream());
        }
        catch (MalformedURLException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (GSSException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new SOAPException((Throwable)e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            this.close();
        }
        return message;
    }

    public final void close() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    private SOAPMessage createMessage(InputStream stream) throws SOAPException {
        Document document;
        try {
            document = this.parse(stream);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (SAXException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException((Throwable)e);
        }
        Node soapBody = null;
        Element parent = document.getDocumentElement();
        if ("Envelope".equalsIgnoreCase(parent.getLocalName())) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!"Body".equalsIgnoreCase(node.getLocalName())) continue;
                soapBody = parent.removeChild(node);
                break;
            }
            if (null == soapBody) {
                throw new IllegalArgumentException("Response did not contain a SOAP 'Body'.");
            }
        } else {
            throw new IllegalArgumentException("Response did not contain a SOAP 'Envelope'.");
        }
        try {
            return this.transform(soapBody);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SOAPException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (SAXException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    private Document parse(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        this.documentFactory.setNamespaceAware(true);
        Document document = this.documentFactory.newDocumentBuilder().parse(stream);
        return document;
    }

    private SOAPMessage transform(Node soapBody) throws SOAPException, IOException, TransformerException, SAXException, ParserConfigurationException {
        SOAPMessage message = this.messageFactory.createMessage();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        NodeList children = soapBody.getChildNodes();
        LOGGER.fine("number of children=" + children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            LOGGER.fine("child[" + i + "]=" + children.item(i).getLocalName());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(children.item(i)), new StreamResult(bos));
            bos.flush();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            Document document = this.parse(bis);
            bis.close();
            bos.close();
            message.getSOAPBody().addDocument(document);
        }
        return message;
    }
}

