/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.cloud.azure.AzureImageCacheService;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.springframework.beans.factory.annotation.Autowired;

public class CacheAzureVHDImages
extends FMInternalCLICommand {
    @Autowired
    private AzureImageCacheService imageCacheService;
    @Autowired
    private DatabaseAccessService dbService;
    private static final String[] ARG_NAMES = new String[0];
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cli");

    @Override
    public String getUsageCommandName() {
        return "cache-azure-vhd-images";
    }

    @Override
    public String description() {
        return "Run the caching step for all DSS versions sources in VHDs.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        InstanceImagesSettings instanceImagesSettings = FMApp.getInstanceImagesSettings(Cloud.AZURE);
        List<VirtualNetwork> virtualNetworks = this.dbService.listResults(VirtualNetwork.class, "SELECT vs FROM virtualnetwork vn", new Object[0]);
        for (InstanceImagesSettings.InstanceImage image : instanceImagesSettings.images) {
            for (VirtualNetwork virtualNetwork : virtualNetworks) {
                logger.infoV("Start caching of image id=%s label=%s vn=%s region=%s", new Object[]{image.id, image.label, virtualNetwork.getLabel(), virtualNetwork.getAzureRegion()});
                InstanceImagesSettings.AzureInstanceImageReference reference = image.getAzureImageReferenceForRegion(virtualNetwork.getAzureRegion());
                try {
                    String azureImageResourceId = this.imageCacheService.cacheAndGetVirtualMachineCustomImage(virtualNetwork.getCloudAccountOrVirtualCloudAccount(), this.fmSettings, reference, virtualNetwork.getAzureRegion(), null);
                    logger.infoV("Image id=%s label=%s cached at %s", new Object[]{image.id, image.label, azureImageResourceId});
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Caching of image id=%s label=%s region=%s failed", new Object[]{image.id, image.label, virtualNetwork.getAzureRegion()});
                }
            }
        }
        return 0;
    }
}

