/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.text.DateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;

public class ListPersonalsKeyCommand
extends FMInternalCLICommand {
    @Override
    public String getUsageCommandName() {
        return "list-personal-api-keys";
    }

    @Override
    public String description() {
        return "Lists the existing Personal API Keys.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return new String[0];
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            System.out.println();
            System.out.println("*** List of API Keys: ***");
            t.getThreadEM().createQuery("SELECT k FROM fmpersonalapikey k", FMPersonalAPIKey.class).getResultStream().forEach(this::print);
            System.out.println("*** End of list ***");
            System.out.println();
            int n = 0;
            return n;
        }
    }

    private void print(FMPersonalAPIKey fmPersonalAPIKey) {
        String formatedDate = Optional.ofNullable(fmPersonalAPIKey.getCreationDate()).map(date -> DateFormat.getDateInstance(3).format((Date)date)).orElse("<not set>");
        System.out.printf("Name: %s, User: %s, Creation Date: %s%n", fmPersonalAPIKey.getKeyId(), fmPersonalAPIKey.getUser().getLogin(), formatedDate);
    }
}

