/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class RegisterAzureVNet
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "AZURE_RG_ID", "AZURE_VNET_ID", "AZURE_SUBNET_NAME"};

    @Override
    public String getUsageCommandName() {
        return "register-azure-vnet";
    }

    @Override
    public String description() {
        return "[DEV COMMAND] Manually register an already-existing and already-peered AZURE VNET";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String rg = args.get("AZURE_RG_ID");
        String vnetId = args.get("AZURE_VNET_ID");
        String subnetId = args.get("AZURE_SUBNET_NAME");
        String secondSubnetId = args.get("AZURE_SECOND_SUBNET_NAME");
        try (DatabaseAccessService.ReadWriteTransaction t = ((DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class)).rwTransaction();){
            Tenant tenant = (Tenant)t.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            VirtualNetwork vn = new VirtualNetwork();
            vn.setId("vn-" + SecretKeyGenerator.generate((int)12));
            vn.setTenant(tenant);
            vn.setMode(VirtualNetwork.VirtualNetworkMode.EXISTING_MONOTENANT);
            vn.setAzureVnId(vnetId);
            vn.setAzureSubnet(subnetId);
            vn.setAzureSecondSubnet(secondSubnetId);
            vn.setAzureRgName(rg);
            System.out.println("NEW VIRTUAL NETWORK: " + vn.getId());
            t.getThreadEM().persist((Object)vn);
            t.commit();
            int n = 0;
            return n;
        }
    }
}

