/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class RegisterGcpVpc
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "GCP_REGION", "GCP_NETWORK", "GCP_SUBNETWORK"};

    @Override
    public String getUsageCommandName() {
        return "register-gcp-vpc";
    }

    @Override
    public String description() {
        return "[DEV COMMAND] Manually register an already-existing and already-peered GCP VPC";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String projectId = args.get("GCP_PROJECT_ID");
        String region = args.get("GCP_REGION");
        String network = args.get("GCP_NETWORK");
        String subnetwork = args.get("GCP_SUBNETWORK");
        try (DatabaseAccessService.ReadWriteTransaction t = ((DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class)).rwTransaction();){
            Tenant tenant = (Tenant)t.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            VirtualNetwork vn = new VirtualNetwork();
            vn.setId("vn-" + SecretKeyGenerator.generate((int)12));
            vn.setTenant(tenant);
            vn.setMode(VirtualNetwork.VirtualNetworkMode.EXISTING_MONOTENANT);
            vn.setGcpProjectId(projectId);
            vn.setGcpNetwork(network);
            vn.setGcpSubnetwork(subnetwork);
            vn.setGcpRegion(region);
            System.out.println("NEW VIRTUAL NETWORK: " + vn.getId());
            t.getThreadEM().persist((Object)vn);
            t.commit();
            int n = 0;
            return n;
        }
    }
}

