/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DescribeCertificateResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DomainValidation;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthStateEnum;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.cloud.aws.AWSCertificateService;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.aws.AWSLBUtils;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.cloud.aws.sdk.LoadBalancingClientWrapper;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.tag.TagService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSCloudLoadBalancerService
implements CloudLoadBalancerServiceInterface {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cloud.lb.aws");
    public static final String AWS_LB_PROVISIONING_STATE_CODE = "provisioning";
    public static final String AWS_LB_ACTIVE_STATE_CODE = "active";
    public static final String CERTIFICATE_STATUS_ISSUED = "ISSUED";
    public static final String CERTIFICATE_STATUS_PENDING = "PENDING_VALIDATION";
    public static final int STARTING_PRIORITY_FOR_FM_MANAGED_RULES = 1000;
    private final AWSClientService awsClientService;
    private final AWSDNSService awsdnsService;
    private final DatabaseAccessService dbService;
    private final AWSCertificateService certificateService;
    private final CloudCryptoService cloudCryptoService;
    private final TagService tagService;
    private final FMApp fmApp;

    @Autowired
    public AWSCloudLoadBalancerService(AWSClientService awsClientService, AWSDNSService awsdnsService, DatabaseAccessService dbService, AWSCertificateService certificateService, CloudCryptoService cloudCryptoService, TagService tagService, FMApp fmApp) {
        this.awsClientService = awsClientService;
        this.awsdnsService = awsdnsService;
        this.dbService = dbService;
        this.certificateService = certificateService;
        this.cloudCryptoService = cloudCryptoService;
        this.tagService = tagService;
        this.fmApp = fmApp;
    }

    @Override
    public PhysicalLoadBalancer createPhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating AWS load balancer", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            CreateLoadBalancerResponse awsLoadBalancerResponse;
            PhysicalLoadBalancer physicalLoadBalancer = new PhysicalLoadBalancer();
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement preparingStep = FutureProgress.pushAutoCloseableState((String)"Preparing Load balancer creation", (double)1.0);){
                physicalLoadBalancer.setId("plb-" + SecretKeyGenerator.generate((int)12));
                physicalLoadBalancer.setLogicalLoadBalancer(lb);
                lb.setCurrentPhysicalLoadBalancer(physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createLBStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer", (double)1.0);){
                smartLogTail.appendLine("Initiating the creation of load balancer '" + lb.getName() + "' on AWS", logger, Priority.INFO);
                awsLoadBalancerResponse = ec2.createLoadBalancer(physicalLoadBalancer.getId(), lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? LoadBalancerSchemeEnum.INTERNAL : LoadBalancerSchemeEnum.INTERNET_FACING, List.of(lb.getVirtualNetwork().getAwsSubnetId(), lb.getVirtualNetwork().getAwsSecondSubnetId()), lb.getVirtualNetwork().getAwsSecurityGroups().split(","), AWSLBUtils.getLoadBalancerTagsForResource(this.tagService.getCloudApplicableTags(lb), lb.getName()));
            }
            LoadBalancer awsLoadBalancer = (LoadBalancer)awsLoadBalancerResponse.loadBalancers().get(0);
            physicalLoadBalancer.setAwsLoadBalancerARN(awsLoadBalancer.loadBalancerArn());
            smartLogTail.appendLine("Successfully created load balancer '" + lb.getName() + "' on AWS. ARN: '" + physicalLoadBalancer.getAwsLoadBalancerARN() + "'", logger, Priority.INFO);
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer listener", (double)1.0);){
                this.createLoadBalancerListener(lb, smartLogTail, ec2, physicalLoadBalancer, awsLoadBalancer);
            }
            listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer rules and targets", (double)1.0);
            try {
                this.createLoadBalancerRulesAndTarget(lb, smartLogTail, ec2, physicalLoadBalancer.getAwsListenerARN());
            }
            finally {
                if (listenerStep != null) {
                    listenerStep.close();
                }
            }
            listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer dns records", (double)1.0);
            try {
                this.createLoadBalancerDNSRecords(lb, smartLogTail, awsLoadBalancer);
            }
            finally {
                if (listenerStep != null) {
                    listenerStep.close();
                }
            }
            smartLogTail.appendLine("Load balancer configuration completed successfully", logger, Priority.INFO);
            PhysicalLoadBalancer physicalLoadBalancer2 = physicalLoadBalancer;
            return physicalLoadBalancer2;
        }
    }

    @Override
    public boolean deletePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
        PhysicalLoadBalancer physicalLoadBalancer = lb.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer == null) {
            return true;
        }
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Deleting AWS load balancer", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            Set<String> targetGroupArnSet = this.getRuleSummaryPerFQDNMap(physicalLoadBalancer.getAwsListenerARN(), lb.getName(), ec2).values().stream().map(RuleSummary::targetGroupArn).collect(Collectors.toSet());
            String awsLoadBalancerARN = physicalLoadBalancer.getAwsLoadBalancerARN();
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement lbStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer", (double)1.0);){
                if (awsLoadBalancerARN != null) {
                    AWSCloudLoadBalancerService.deletePhysicalLoadBalancer(smartLogTail, ec2, awsLoadBalancerARN, physicalLoadBalancer);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement targetsStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer targets", (double)1.0);){
                this.deleteLoadBalancerTargets(smartLogTail, ec2, targetGroupArnSet);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement certificateStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer certificate", (double)1.0);){
                this.deleteLoadBalancerManagedCertificate(lb, smartLogTail, ec2.getClient(), awsLoadBalancerARN);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer dns records", (double)1.0);){
                this.deleteLoadBalancerDNSRecords(lb, smartLogTail);
            }
        }
        return true;
    }

    @Override
    public void updatePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) throws InterruptedException {
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Updating AWS load balancer", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            Optional<String> certificateARNToDeleteOptional;
            LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
            logger.info((Object)("Updating load balancer '" + lb.getName() + "'"));
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement certificateStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer certificate", (double)1.0);){
                certificateARNToDeleteOptional = lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER ? this.updateLoadBalancerManagedCertificate(lb, smartLogTail) : Optional.ofNullable(lb.getAwsManagedCertificateARN());
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement listenerStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer listener", (double)1.0);){
                AWSCloudLoadBalancerService.updateLoadBalancerListener(lb, smartLogTail, ec2.getClient(), physicalLoadBalancer.getAwsListenerARN());
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement targetsStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer targets and rules", (double)1.0);){
                this.updateLoadBalancerTargetsAndRules(lb, smartLogTail, ec2, physicalLoadBalancer.getAwsListenerARN());
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer dns records", (double)1.0);){
                this.updateLoadBalancerDNSRecords(lb, smartLogTail, ec2, physicalLoadBalancer.getAwsLoadBalancerARN());
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement managedCertStep = FutureProgress.pushAutoCloseableState((String)"Deleting managed certificate", (double)1.0);){
                certificateARNToDeleteOptional.ifPresent(certificateARNToDelete -> {
                    smartLogTail.appendLine("Removing old managed certificate", logger, Priority.INFO);
                    this.certificateService.deleteCertificate(lb.getVirtualNetwork(), (String)certificateARNToDelete, lb.getAwsManagedCertificateARN(), smartLogTail);
                    smartLogTail.appendLine("Successfully deleted old managed certificate", logger, Priority.INFO);
                });
            }
        }
    }

    @Override
    public boolean isLoadBalancerProvisioning(LogicalLoadBalancer loadBalancer) {
        return Optional.ofNullable(loadBalancer.getCurrentPhysicalLoadBalancer()).map(PhysicalLoadBalancer::getAwsLoadBalancerARN).map(loadBalancerArn -> {
            LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
            LoadBalancerState loadBalancerState = ((LoadBalancer)ec2.describeLoadBalancer((String)loadBalancerArn).loadBalancers().get(0)).state();
            return loadBalancerState.code().equals((Object)LoadBalancerStateEnum.PROVISIONING);
        }).orElse(false);
    }

    @Override
    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        LoadBalancerPhysicalStatus loadBalancerPhysicalStatus = new LoadBalancerPhysicalStatus();
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
        if (currentPhysicalLoadBalancer == null || currentPhysicalLoadBalancer.getAwsLoadBalancerARN() == null) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_NOT_PROVISIONED, "");
        } else if (currentPhysicalLoadBalancer.getAwsListenerARN() == null) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_LISTENER_NOT_PROVISIONED, "");
        } else {
            String regionId = loadBalancer.getVirtualNetwork().getAwsRegionOrSettingsDefault(this.fmApp.getFMSettings());
            loadBalancerPhysicalStatus.loadBalancerLink = this.getLoadBalancerLink(loadBalancer);
            LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
            try {
                DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancer(currentPhysicalLoadBalancer.getAwsLoadBalancerARN());
                LoadBalancer awsLoadBalancer = (LoadBalancer)describeLoadBalancersResponse.loadBalancers().get(0);
                LoadBalancerStateEnum awsLoadBalancerState = awsLoadBalancer.state().code();
                if (awsLoadBalancerState == LoadBalancerStateEnum.PROVISIONING) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONING);
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_PROVISIONING, "");
                } else if (awsLoadBalancerState == LoadBalancerStateEnum.ACTIVE) {
                    LoadBalancerSchemeEnum loadBalancerScheme;
                    if (!Objects.equals(awsLoadBalancer.vpcId(), loadBalancer.getVirtualNetwork().getAwsVpcId())) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_WRONG_NETWORK, "Load balancer is in VPC '" + awsLoadBalancer.vpcId() + "' instead of expected VPC '" + loadBalancer.getVirtualNetwork().getAwsVpcId() + "'");
                    }
                    LoadBalancerSchemeEnum loadBalancerSchemeEnum = loadBalancerScheme = loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? LoadBalancerSchemeEnum.INTERNAL : LoadBalancerSchemeEnum.INTERNET_FACING;
                    if (loadBalancerScheme != awsLoadBalancer.scheme()) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SCHEME_NOT_ALIGNED, "");
                    }
                    this.checkLoadBalancerListenerStatus(loadBalancer, loadBalancerPhysicalStatus, currentPhysicalLoadBalancer, ec2.getClient());
                    this.checkLoadBalancerRulesStatus(loadBalancer, loadBalancerPhysicalStatus, currentPhysicalLoadBalancer, regionId, ec2);
                    this.checkLoadBalancerDNSStatus(loadBalancer, loadBalancerPhysicalStatus, awsLoadBalancer);
                }
            }
            catch (LoadBalancerNotFoundException e) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_DELETED_IN_CLOUD, "AWS Load balancer '" + currentPhysicalLoadBalancer.getAwsLoadBalancerARN() + "' not found.");
            }
        }
        List<LoadBalancerNodeMapping> inactiveNodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).toList();
        if (!inactiveNodes.isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING, "The following node mappings are inactive but still associated to cloud resources: " + inactiveNodes.stream().map(n -> n.getSubdomainOrFQDN() + " \u2192 " + n.getLogicalInstance().getLabel()).collect(Collectors.joining(",")));
        }
        return loadBalancerPhysicalStatus;
    }

    @Override
    public void onInstancePhysicalStateChange(LogicalLoadBalancer currentLoadBalancer, LogicalInstance logicalInstance) {
        PhysicalLoadBalancer physicalLoadBalancer = currentLoadBalancer.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer != null) {
            logger.info((Object)("Instance '" + logicalInstance.getLabel() + "' physical state has changed, updating LB."));
            LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(currentLoadBalancer.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
            Pair mappingForInstanceAndAllMappingForSameFQDN = (Pair)currentLoadBalancer.getLoadBalancerNodeMappingsPerHostName(false).entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().filter(loadBalancerNodeMapping -> loadBalancerNodeMapping.getLogicalInstance().getId().equals(logicalInstance.getId())).map(loadBalancerNodeMapping -> new Pair(loadBalancerNodeMapping, (Object)((Set)entry.getValue())))).findAny().orElseThrow(() -> new IllegalArgumentException("Load balancer '" + currentLoadBalancer.getName() + "' doesn't have a node mapping for instance '" + logicalInstance.getLabel() + "'"));
            LoadBalancerNodeMapping loadBalancerNodeMappingForInstance = (LoadBalancerNodeMapping)mappingForInstanceAndAllMappingForSameFQDN.first;
            Set<String> targetGroupInstanceIds = ((Set)mappingForInstanceAndAllMappingForSameFQDN.second).stream().flatMap(loadBalancerNodeMapping -> Stream.ofNullable(loadBalancerNodeMapping.getLogicalInstance().getCurrentPhysicalInstance())).map(PhysicalInstance::getAwsEC2InstanceId).collect(Collectors.toSet());
            Map<String, RuleSummary> ruleSummaryPerFQDNMap = this.getRuleSummaryPerFQDNMap(physicalLoadBalancer.getAwsListenerARN(), currentLoadBalancer.getName(), ec2);
            int highestPriorityUsed = ruleSummaryPerFQDNMap.values().stream().mapToInt(RuleSummary::priority).max().orElse(1000);
            String fqdn = LoadBalancerUtils.getFQDN(loadBalancerNodeMappingForInstance.getSubdomainOrFQDN(), currentLoadBalancer, this.awsdnsService);
            this.updateLoadBalancerTargetsAndRulesForHostname(currentLoadBalancer, new DKUtils.SmartLogTailBuilder(), ec2, fqdn, targetGroupInstanceIds, physicalLoadBalancer.getAwsListenerARN(), Optional.ofNullable(ruleSummaryPerFQDNMap.get(fqdn)), highestPriorityUsed);
        }
    }

    @Override
    public boolean isLoadBalancerNodeMappingProvisioned(LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping node) {
        return Optional.ofNullable(node.getLogicalInstance().getCurrentPhysicalInstance()).map(PhysicalInstance::getAwsEC2InstanceId).flatMap(awsInstanceId -> {
            LoadBalancingClientWrapper ec2 = this.awsClientService.getLoadBalancingClientWrapper(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService, this.fmApp.getFMSettings()));
            String fqdn = LoadBalancerUtils.getFQDN(node.getSubdomainOrFQDN(), loadBalancer, this.awsdnsService);
            return Optional.ofNullable(loadBalancer.getCurrentPhysicalLoadBalancer()).flatMap(physicalLoadBalancer -> ec2.describeRules(physicalLoadBalancer.getAwsListenerARN()).rules().stream().filter(rule -> rule.conditions().stream().map(RuleCondition::hostHeaderConfig).flatMap(hostHeaderConditionConfig -> hostHeaderConditionConfig.values().stream()).anyMatch(fqdn::equals)).flatMap(rule -> rule.actions().stream().map(Action::targetGroupArn)).findAny()).map(targetGroupArn -> ec2.describeTargetHealth((String)targetGroupArn).targetHealthDescriptions().stream().map(TargetHealthDescription::target).map(TargetDescription::id).anyMatch(awsInstanceId::equals));
        }).orElse(false);
    }

    @Override
    public void onInstanceDeleteEvent(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping, LogicalInstance logicalInstance) {
    }

    @Override
    public String getLoadBalancerLink(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return "";
        }
        String regionId = loadBalancer.getVirtualNetwork().getAwsRegionOrSettingsDefault(this.fmApp.getFMSettings());
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#LoadBalancer:loadBalancerArn=" + loadBalancer.getCurrentPhysicalLoadBalancer().getAwsLoadBalancerARN();
    }

    private Map<String, RuleSummary> getRuleSummaryPerFQDNMap(String listenerArn, String loadBalancerName, LoadBalancingClientWrapper ec2Client) {
        try {
            List ruleList = ec2Client.describeRules(listenerArn).rules();
            List<String> ruleArns = ruleList.stream().map(Rule::ruleArn).toList();
            Set ruleArnManagedByFMSet = ec2Client.describeTags(ruleArns).tagDescriptions().stream().filter(tagDescription -> tagDescription.tags().stream().anyMatch(tag -> tag.key().equals("Name") && tag.value().startsWith(loadBalancerName + "-"))).map(TagDescription::resourceArn).collect(Collectors.toSet());
            return ruleList.stream().filter(rule -> !rule.conditions().isEmpty()).filter(rule -> ruleArnManagedByFMSet.contains(rule.ruleArn())).map(rule -> new RuleSummary(rule.ruleArn(), (String)((RuleCondition)rule.conditions().get(0)).hostHeaderConfig().values().get(0), ((Action)rule.actions().get(0)).targetGroupArn(), Integer.parseInt(rule.priority()))).collect(Collectors.toMap(RuleSummary::fqdn, Function.identity()));
        }
        catch (ListenerNotFoundException e) {
            logger.debugV((Throwable)e, "Listener with ARN %s does not exist.", new Object[]{listenerArn});
            return Map.of();
        }
    }

    private void createLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancer awsLoadBalancer) {
        if (this.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Initiating DNS record creation...", logger, Priority.INFO);
            DNSservice.ZoneType zoneType = lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
            for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
                this.awsdnsService.addDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, LoadBalancerUtils.getFQDN(subdomainOrFQDN, lb, this.awsdnsService), awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> ((Set)nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN)).forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
            }
            smartLogTail.replaceLastLine("DNS record created successfully", logger, Priority.INFO);
        }
    }

    private boolean hasDNSManaged(VirtualNetwork virtualNetwork) {
        return virtualNetwork.getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE;
    }

    private void createLoadBalancerRulesAndTarget(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String listenerArn) {
        smartLogTail.appendLine("Configuring target groups and associated rules", logger, Priority.INFO);
        Map<String, Set> nodeMappingsPerFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN().entrySet().stream().collect(Collectors.toMap(entry -> LoadBalancerUtils.getFQDN((String)entry.getKey(), lb, this.awsdnsService), Map.Entry::getValue));
        int highestUsedPriority = 0;
        for (Map.Entry<String, Set> entry2 : nodeMappingsPerFQDN.entrySet()) {
            Set<String> targetGroupInstanceIds = entry2.getValue().stream().flatMap(loadBalancerNodeMapping -> Stream.ofNullable(loadBalancerNodeMapping.getLogicalInstance().getCurrentPhysicalInstance())).map(PhysicalInstance::getAwsEC2InstanceId).collect(Collectors.toSet());
            highestUsedPriority = this.createRuleAndTargetGroup(lb, smartLogTail, ec2, entry2.getKey(), targetGroupInstanceIds, listenerArn, highestUsedPriority);
        }
    }

    private int createRuleAndTargetGroup(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String fqdn, Set<String> targetGroupInstanceIds, String listenerArn, int highestPriorityUsed) {
        if (!targetGroupInstanceIds.isEmpty()) {
            smartLogTail.appendLine("Creating target group for '" + fqdn + "'...", logger, Priority.INFO);
            String targetGroupArn = this.createTargetGroup(lb, ec2, targetGroupInstanceIds);
            smartLogTail.replaceLastLine("Target group successfully created with ARN: " + targetGroupArn, logger, Priority.INFO);
            smartLogTail.appendLine("Setting up load balancer rule for '" + fqdn + "'...", logger, Priority.INFO);
            String ruleArn = this.createRule(ec2, lb, fqdn, ++highestPriorityUsed, listenerArn, targetGroupArn);
            smartLogTail.replaceLastLine("Successfully created new load balancer rule with ARN: " + ruleArn, logger, Priority.INFO);
        }
        return highestPriorityUsed;
    }

    private String createTargetGroup(LogicalLoadBalancer lb, LoadBalancingClientWrapper ec2, Set<String> targetGroupInstanceIds) {
        return ec2.createTargetGroup(targetGroupInstanceIds, lb.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? 80 : 443, lb.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? ProtocolEnum.HTTP : ProtocolEnum.HTTPS, lb.getVirtualNetwork().getAwsVpcId(), AWSLBUtils.getLoadBalancerTagsForResource(this.tagService.getCloudApplicableTags(lb), lb.getName()));
    }

    private String issueCertificate(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail) {
        return this.certificateService.issueCertificate(loadBalancer.getName(), loadBalancer.getVirtualNetwork(), this.resolveFQDNsForCertificate(loadBalancer), this.tagService.getCloudApplicableTags(loadBalancer), smartLogTail);
    }

    private Optional<String> issueCertificate(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail, String oldCertificateARN) {
        return this.certificateService.issueCertificate(loadBalancer.getName(), loadBalancer.getVirtualNetwork(), this.resolveFQDNsForCertificate(loadBalancer), this.tagService.getCloudApplicableTags(loadBalancer), smartLogTail, oldCertificateARN);
    }

    private Set<String> resolveFQDNsForCertificate(LogicalLoadBalancer loadBalancer) {
        return loadBalancer.getLoadBalancerNodeMapping().stream().filter(loadBalancerNodeMapping -> loadBalancerNodeMapping.getStatus().equals((Object)LoadBalancerNodeMapping.Status.ACTIVE)).map(LoadBalancerNodeMapping::getSubdomainOrFQDN).map(subdomainOrFQDN -> LoadBalancerUtils.getFQDN(subdomainOrFQDN, loadBalancer, this.awsdnsService)).collect(Collectors.toSet());
    }

    private void createLoadBalancerListener(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, PhysicalLoadBalancer physicalLoadBalancer, LoadBalancer awsLoadBalancer) {
        smartLogTail.appendLine("Setting up listener for load balancer '" + lb.getName() + "'", logger, Priority.INFO);
        Set<Tag> tags = AWSLBUtils.getLoadBalancerTagsForResource(this.tagService.getCloudApplicableTags(lb), lb.getName());
        CreateListenerResponse listener = switch (lb.getCertificateMode()) {
            case CertificateMode.AWS_CERTIFICATE_MANAGER -> {
                lb.setAwsManagedCertificateARN(this.issueCertificate(lb, smartLogTail));
                yield ec2.createListener(awsLoadBalancer.loadBalancerArn(), Optional.ofNullable(lb.getAwsManagedCertificateARN()), ProtocolEnum.HTTPS, 443, tags);
            }
            case CertificateMode.AWS_ARN -> ec2.createListener(awsLoadBalancer.loadBalancerArn(), Optional.ofNullable(lb.getAwsCertificateARN()), ProtocolEnum.HTTPS, 443, tags);
            default -> ec2.createListener(awsLoadBalancer.loadBalancerArn(), Optional.empty(), ProtocolEnum.HTTP, 80, tags);
        };
        physicalLoadBalancer.setAwsListenerARN(((Listener)listener.listeners().get(0)).listenerArn());
        smartLogTail.replaceLastLine("Listener successfully created on AWS for load balancer. ARN: '" + physicalLoadBalancer.getAwsListenerARN() + "'", logger, Priority.INFO);
    }

    private void deleteLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail) {
        if (this.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Removing DNS records", logger, Priority.INFO);
            for (LoadBalancerNodeMapping nodeMapping : lb.getLoadBalancerNodeMapping()) {
                String dnsRecordName = LoadBalancerUtils.getFQDN(nodeMapping.getSubdomainOrFQDN(), lb, this.awsdnsService);
                smartLogTail.appendLine("Removing DNS record '" + dnsRecordName + "' ...", logger, Priority.INFO);
                this.awsdnsService.removeDNSRecord(lb.getVirtualNetwork(), nodeMapping.getPublicPhysicalDNSRecord());
                if (nodeMapping.getPublicPhysicalDNSRecord() != null) {
                    this.dbService.getThreadEM().remove((Object)nodeMapping.getPublicPhysicalDNSRecord());
                    nodeMapping.setPublicPhysicalDNSRecord(null);
                    smartLogTail.replaceLastLine("DNS record '" + dnsRecordName + "' successfully deleted", logger, Priority.INFO);
                    continue;
                }
                smartLogTail.replaceLastLine("DNS record '" + dnsRecordName + "' already deleted", logger, Priority.INFO);
            }
            smartLogTail.appendLine("All DNS records have been successfully removed", logger, Priority.INFO);
        }
    }

    private void deleteLoadBalancerManagedCertificate(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String awsLoadBalancerARN) {
        if (lb.getAwsManagedCertificateARN() != null) {
            boolean isLBDeleted = false;
            smartLogTail.appendLine("Deleting load balance '" + awsLoadBalancerARN + "'...", logger, Priority.INFO);
            for (int count = 0; !isLBDeleted && count <= 12; ++count) {
                try {
                    DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{awsLoadBalancerARN}).build());
                    isLBDeleted = describeLoadBalancersResponse.loadBalancers().isEmpty();
                }
                catch (LoadBalancerNotFoundException e) {
                    isLBDeleted = true;
                }
                if (isLBDeleted) continue;
                smartLogTail.replaceLastLine("Load balancer deletion still pending on AWS. Waiting..." + IntStream.range(0, count).mapToObj(i -> ".").collect(Collectors.joining()), logger, Priority.INFO);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Couldn't wait for load balancer to be deleted.", (Throwable)e);
                    throw new IllegalStateException("Couldn't wait for load balancer to be deleted.", e);
                }
            }
            if (!isLBDeleted) {
                smartLogTail.appendLine("Load balance '" + awsLoadBalancerARN + "' is not yet deleted even after waiting 1 min", logger, Priority.ERROR);
                throw new IllegalStateException("Load balancer is not yet deleted even after waiting 1 min. Once the load balancer is deleted in AWS, try de-provisioning the load balancer again to destroy the remaining resources.");
            }
            smartLogTail.replaceLastLine("Load balance '" + awsLoadBalancerARN + "' deleted", logger, Priority.INFO);
            this.deleteManagedCertificate(lb, lb.getAwsManagedCertificateARN(), smartLogTail);
        }
    }

    private static void deletePhysicalLoadBalancer(DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String awsLoadBalancerARN, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        smartLogTail.appendLine("Removing load balancer '" + awsLoadBalancerARN + "'...", logger, Priority.INFO);
        try {
            ec2.deleteLoadBalancer(awsLoadBalancerARN);
        }
        catch (LoadBalancerNotFoundException e) {
            logger.warnV((Throwable)e, "Load balancer %s does not exist in AWS console", new Object[]{awsLoadBalancerARN});
        }
        physicalLoadBalancer.setAwsLoadBalancerARN(null);
        smartLogTail.replaceLastLine("Successfully removed load balancer '" + awsLoadBalancerARN + "'", logger, Priority.INFO);
    }

    private void deleteLoadBalancerTargets(DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, Collection<String> targetGroupArns) {
        targetGroupArns.forEach(targetGroupArn -> {
            smartLogTail.appendLine("Deleting target group '" + targetGroupArn + "'...", logger, Priority.INFO);
            int count = 1;
            while (count++ < 12) {
                try {
                    ec2.deleteTargetGroup((String)targetGroupArn);
                    smartLogTail.replaceLastLine("Target group '" + targetGroupArn + "' deleted.", logger, Priority.INFO);
                    return;
                }
                catch (ResourceInUseException e) {
                    smartLogTail.appendLine("Target group '" + targetGroupArn + "' still in use. Waiting..." + ".".repeat(count), logger, Priority.INFO, count > 0);
                    try {
                        Thread.sleep(2000L * (long)count);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            logger.warnV("Failed to delete target group with ARN %s.", new Object[]{targetGroupArn});
            smartLogTail.replaceLastLine("Target group '" + targetGroupArn + "' was not deleted. Probably AWS took too long to disassociate the target group from the load balancer.", logger, Priority.INFO);
        });
    }

    private void deleteManagedCertificate(LogicalLoadBalancer lb, @Nonnull String certificateARN, DKUtils.SmartLogTailBuilder smartLogTail) {
        this.certificateService.deleteCertificate(lb.getVirtualNetwork(), certificateARN, null, smartLogTail);
        lb.setAwsManagedCertificateARN(null);
    }

    private void updateLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String loadBalancerArn) {
        if (this.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Updating DNS record...", logger, Priority.INFO);
            DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancer(loadBalancerArn);
            LoadBalancer awsLoadBalancer = (LoadBalancer)describeLoadBalancersResponse.loadBalancers().get(0);
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
            lb.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).filter(nodeMapping -> !nodeMappingsPerSubdomainOrFQDN.containsKey(nodeMapping.getSubdomainOrFQDN())).forEach(nodeMapping -> this.awsdnsService.removeDNSRecord(lb.getVirtualNetwork(), nodeMapping.getPublicPhysicalDNSRecord()));
            for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
                DNSservice.ZoneType zoneType = lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
                Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN);
                PhysicalDNSRecord publicPhysicalDNSRecord = nodeMappings.iterator().next().getPublicPhysicalDNSRecord();
                String mappedFQDN = LoadBalancerUtils.getFQDN(subdomainOrFQDN, lb, this.awsdnsService);
                if (publicPhysicalDNSRecord != null) {
                    this.dbService.getThreadEM().remove((Object)publicPhysicalDNSRecord);
                    this.awsdnsService.updateDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, publicPhysicalDNSRecord, mappedFQDN, awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> nodeMappings.forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
                    continue;
                }
                this.awsdnsService.addDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, mappedFQDN, awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> nodeMappings.forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
            }
            smartLogTail.replaceLastLine("DNS record updated", logger, Priority.INFO);
        }
    }

    private void updateLoadBalancerTargetsAndRules(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String listenerArn) {
        smartLogTail.appendLine("Updating target groups and rules", logger, Priority.INFO);
        Map<String, Set> nodeMappingsPerFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN().entrySet().stream().collect(Collectors.toMap(entry -> LoadBalancerUtils.getFQDN((String)entry.getKey(), lb, this.awsdnsService), Map.Entry::getValue));
        Map<String, RuleSummary> ruleSummaryPerFQDN = this.getRuleSummaryPerFQDNMap(listenerArn, lb.getName(), ec2);
        for (RuleSummary ruleSummary : ruleSummaryPerFQDN.values()) {
            if (nodeMappingsPerFQDN.containsKey(ruleSummary.fqdn)) continue;
            this.deleteRuleAndTargetGroup(ruleSummary, smartLogTail, ec2);
        }
        int highestPriorityUsed = ruleSummaryPerFQDN.values().stream().mapToInt(RuleSummary::priority).max().orElse(1000);
        for (Map.Entry<String, Set> entry2 : nodeMappingsPerFQDN.entrySet()) {
            Set<String> targetGroupInstanceIds = entry2.getValue().stream().flatMap(loadBalancerNodeMapping -> Stream.ofNullable(loadBalancerNodeMapping.getLogicalInstance().getCurrentPhysicalInstance())).map(PhysicalInstance::getAwsEC2InstanceId).collect(Collectors.toSet());
            highestPriorityUsed = this.updateLoadBalancerTargetsAndRulesForHostname(lb, smartLogTail, ec2, entry2.getKey(), targetGroupInstanceIds, listenerArn, Optional.ofNullable(ruleSummaryPerFQDN.get(entry2.getKey())), highestPriorityUsed);
        }
        smartLogTail.appendLine("Target groups and rules updated", logger, Priority.INFO);
    }

    private int updateLoadBalancerTargetsAndRulesForHostname(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, String fqdn, Set<String> targetGroupInstanceIds, String listenerArn, Optional<RuleSummary> ruleSummaryOptional, int highestPriorityUsed) {
        if (ruleSummaryOptional.isEmpty()) {
            if (!targetGroupInstanceIds.isEmpty()) {
                highestPriorityUsed = this.createRuleAndTargetGroup(lb, smartLogTail, ec2, fqdn, targetGroupInstanceIds, listenerArn, highestPriorityUsed);
            }
        } else if (!targetGroupInstanceIds.isEmpty()) {
            RuleSummary ruleSummary = ruleSummaryOptional.get();
            AWSCloudLoadBalancerService.updateTargetGroup(smartLogTail, ec2, targetGroupInstanceIds, ruleSummary.fqdn, ruleSummary.targetGroupArn);
        } else {
            this.deleteRuleAndTargetGroup(ruleSummaryOptional.get(), smartLogTail, ec2);
        }
        return highestPriorityUsed;
    }

    private void deleteRuleAndTargetGroup(RuleSummary ruleSummary, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2) {
        try {
            smartLogTail.appendLine("Deleting rule for '" + ruleSummary.fqdn + "'...", logger, Priority.INFO);
            ec2.deleteRule(ruleSummary.arn);
            smartLogTail.replaceLastLine("Rule for '" + ruleSummary.fqdn + "' deleted", logger, Priority.INFO);
        }
        catch (RuleNotFoundException e) {
            logger.debugV("Tried to delete non-existing rule with ARN %s.", new Object[]{ruleSummary.arn});
            smartLogTail.replaceLastLine("Rule for '" + ruleSummary.fqdn + "' was not found.", logger, Priority.INFO);
        }
        try {
            smartLogTail.appendLine("Deleting target group for '" + ruleSummary.fqdn + "'...", logger, Priority.INFO);
            ec2.deleteTargetGroup(ruleSummary.targetGroupArn);
            smartLogTail.replaceLastLine("Target group for '" + ruleSummary.fqdn + "' deleted", logger, Priority.INFO);
        }
        catch (TargetGroupNotFoundException e) {
            logger.debugV("Tried to delete non-existing target group with ARN %s.", new Object[]{ruleSummary.targetGroupArn});
            smartLogTail.replaceLastLine("Target group for '" + ruleSummary.fqdn + "' was not found", logger, Priority.INFO);
        }
    }

    private static void updateTargetGroup(DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancingClientWrapper ec2, Set<String> desiredTargets, String fqdn, String targetGroupArn) {
        Sets.SetView targetsToAdd;
        Set<String> currentTargets = AWSCloudLoadBalancerService.getTargetGroupInstanceIds(ec2, targetGroupArn);
        Sets.SetView targetsToRemove = Sets.difference(currentTargets, desiredTargets);
        if (!targetsToRemove.isEmpty()) {
            smartLogTail.appendLine("Removing targets for '" + fqdn + "'...", logger, Priority.INFO);
            ec2.deregisterTargets(targetGroupArn, (Collection<String>)targetsToRemove);
            smartLogTail.replaceLastLine("Targets successfully removed for '" + fqdn + "'...", logger, Priority.INFO);
        }
        if (!(targetsToAdd = Sets.difference(desiredTargets, currentTargets)).isEmpty()) {
            smartLogTail.appendLine("Adding targets for '" + fqdn + "'...", logger, Priority.INFO);
            ec2.registerTargets(targetGroupArn, (Collection<String>)targetsToAdd);
            smartLogTail.replaceLastLine("Targets successfully added for '" + fqdn + "'...", logger, Priority.INFO);
        }
    }

    private static Set<String> getTargetGroupInstanceIds(LoadBalancingClientWrapper ec2, String targetGroupArn) {
        return ec2.describeTargetHealth(targetGroupArn).targetHealthDescriptions().stream().filter(targetHealthDescription -> targetHealthDescription.targetHealth().state() != TargetHealthStateEnum.DRAINING).map(targetHealthDescription -> targetHealthDescription.target().id()).collect(Collectors.toSet());
    }

    private static void updateLoadBalancerListener(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String listenerArn) {
        smartLogTail.appendLine("Updating listener", logger, Priority.INFO);
        Action defaultAction = AWSCloudLoadBalancerService.getDefaultAction();
        switch (lb.getCertificateMode()) {
            case AWS_CERTIFICATE_MANAGER: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(listenerArn).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsManagedCertificateARN()).build()}).build());
                break;
            }
            case AWS_ARN: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(listenerArn).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsCertificateARN()).build()}).build());
                break;
            }
            default: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(listenerArn).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTP).port(Integer.valueOf(80)).build());
            }
        }
        smartLogTail.replaceLastLine("Listener updated", logger, Priority.INFO);
    }

    private Optional<String> updateLoadBalancerManagedCertificate(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail) {
        if (lb.getAwsManagedCertificateARN() == null) {
            lb.setAwsManagedCertificateARN(this.issueCertificate(lb, smartLogTail));
            return Optional.empty();
        }
        String oldCertificateARN = lb.getAwsManagedCertificateARN();
        return this.issueCertificate(lb, smartLogTail, oldCertificateARN).map(newCertificateARN -> {
            lb.setAwsManagedCertificateARN((String)newCertificateARN);
            return oldCertificateARN;
        });
    }

    private void checkLoadBalancerDNSStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, LoadBalancer awsLoadBalancer) {
        if (loadBalancer.getVirtualNetwork().getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE) {
            List<String> subdomainList = loadBalancer.getLoadBalancerNodeMapping().stream().map(LoadBalancerNodeMapping::getSubdomainOrFQDN).distinct().toList();
            for (String subdomain : subdomainList) {
                try {
                    DNSservice.ZoneType zoneType = loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
                    Optional<String> dnsRecord = this.awsdnsService.getDNSRecordValueForSubdomain(loadBalancer.getVirtualNetwork(), subdomain, zoneType, DNSservice.RecordType.CNAME);
                    if (dnsRecord.isPresent()) {
                        if (dnsRecord.get().equals(awsLoadBalancer.dnsName())) continue;
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_WRONG_DNS_RECORD, "DNS record  '" + subdomain + "' = '" + dnsRecord.get() + "' not matching Load balancing DNS '" + awsLoadBalancer.dnsName() + "'.");
                        continue;
                    }
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_DNS_RECORD, "DNS record  '" + subdomain + "' not found.");
                }
                catch (Exception e) {
                    loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of DNS record '" + subdomain + "': " + e.getMessage());
                }
            }
        }
    }

    private void checkLoadBalancerRulesStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, PhysicalLoadBalancer currentPhysicalLoadBalancer, String regionId, LoadBalancingClientWrapper ec2) {
        Map nodeMappingsOfProvisionedInstancesPerFQDN = (Map)loadBalancer.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN().entrySet().stream().map(entry -> {
            Set nodeMappingsOfProvisionedInstances = ((Set)entry.getValue()).stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).collect(Collectors.toSet());
            return Map.entry(LoadBalancerUtils.getFQDN((String)entry.getKey(), loadBalancer, this.awsdnsService), nodeMappingsOfProvisionedInstances);
        }).filter(entry -> !((Set)entry.getValue()).isEmpty()).collect(CollectionUtils.entriesToMap());
        Map<String, RuleSummary> ruleSummaryPerFQDNMap = this.getRuleSummaryPerFQDNMap(currentPhysicalLoadBalancer.getAwsListenerARN(), loadBalancer.getName(), ec2);
        for (RuleSummary ruleSummary : ruleSummaryPerFQDNMap.values()) {
            Optional.ofNullable((Set)nodeMappingsOfProvisionedInstancesPerFQDN.get(ruleSummary.fqdn)).stream().flatMap(Collection::stream).map(nodeMapping -> nodeMapping.getLogicalInstance().getId()).forEach(logicalInstanceId -> {
                loadBalancerPhysicalStatus.addRoutingRuleLink((String)logicalInstanceId, this.buildLoadBalancerRuleLink(regionId, ruleSummary.arn));
                loadBalancerPhysicalStatus.addTargetGroupLink((String)logicalInstanceId, this.buildLoadBalancerTargetGroupLink(regionId, ruleSummary.targetGroupArn));
            });
            if (nodeMappingsOfProvisionedInstancesPerFQDN.containsKey(ruleSummary.fqdn)) continue;
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_ORPHANED_RULES, "Rules for hostnames [%s] are unused", new Object[]{ruleSummary.fqdn});
        }
        nodeMappingsOfProvisionedInstancesPerFQDN.forEach((fqdn, nodeMappingsSet) -> {
            RuleSummary ruleSummary = (RuleSummary)ruleSummaryPerFQDNMap.get(fqdn);
            if (ruleSummary == null) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_RULES, "Missing rules for hostname [%s]", new Object[]{fqdn});
            } else {
                Sets.SetView unwantedInstanceLabelsInTargetGroup;
                Map<String, String> awsInstanceIdToLabelMap = loadBalancer.getLoadBalancerNodeMapping().stream().map(LoadBalancerNodeMapping::getLogicalInstance).filter(logicalInstance -> logicalInstance.getCurrentPhysicalInstance() != null).collect(Collectors.toMap(logicalInstance -> logicalInstance.getCurrentPhysicalInstance().getAwsEC2InstanceId(), LogicalInstance::getLabel));
                Set targetGroupInstanceLabels = AWSCloudLoadBalancerService.getTargetGroupInstanceIds(ec2, ruleSummary.targetGroupArn).stream().map(awsInstanceIdToLabelMap::get).collect(Collectors.toSet());
                Set nodeMappingInstanceLabels = nodeMappingsSet.stream().map(nodeMapping -> nodeMapping.getLogicalInstance().getLabel()).collect(Collectors.toSet());
                Sets.SetView missingInstanceLabelsFromTargetGroup = Sets.difference(nodeMappingInstanceLabels, targetGroupInstanceLabels);
                if (!missingInstanceLabelsFromTargetGroup.isEmpty()) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_TARGET_MISSING_INSTANCES, "Load Balancer rule for hostname [%s] is missing instances [%s] in its target", new Object[]{fqdn, String.join((CharSequence)",", (Iterable<? extends CharSequence>)missingInstanceLabelsFromTargetGroup)});
                }
                if (!(unwantedInstanceLabelsInTargetGroup = Sets.difference(targetGroupInstanceLabels, nodeMappingInstanceLabels)).isEmpty()) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_TARGET_UNWANTED_INSTANCES, "Load Balancer rule for hostname [%s] has unwanted instances [%s] in its target", new Object[]{fqdn, String.join((CharSequence)",", (Iterable<? extends CharSequence>)unwantedInstanceLabelsInTargetGroup)});
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLoadBalancerListenerStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, PhysicalLoadBalancer currentPhysicalLoadBalancer, ElasticLoadBalancingV2Client ec2) {
        try {
            DescribeListenersResponse describeListenersResponse = ec2.describeListeners((DescribeListenersRequest)DescribeListenersRequest.builder().listenerArns(new String[]{currentPhysicalLoadBalancer.getAwsListenerARN()}).build());
            Listener listener = (Listener)describeListenersResponse.listeners().get(0);
            switch (loadBalancer.getCertificateMode()) {
                case AWS_CERTIFICATE_MANAGER: {
                    this.checkCertificateStatus(loadBalancer.getAwsManagedCertificateARN(), loadBalancerPhysicalStatus, listener);
                    if (loadBalancer.getAwsManagedCertificateARN() == null) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "No cloud load balancer managed certificate provisioned in AWS");
                        return;
                    }
                    try {
                        DescribeCertificateResponse describeResult = this.awsClientService.getACMClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService, FMApp.getFMSettingsUnsafe())).describeCertificate(loadBalancer.getAwsManagedCertificateARN());
                        HashSet<String> domainsFromCertificate = new HashSet<String>();
                        domainsFromCertificate.add(describeResult.certificate().domainName());
                        domainsFromCertificate.addAll(describeResult.certificate().subjectAlternativeNames());
                        Set domainsExpected = loadBalancer.getLoadBalancerNodeMapping().stream().map(nodeMapping -> LoadBalancerUtils.getFQDN(nodeMapping.getSubdomainOrFQDN(), loadBalancer, this.awsdnsService)).collect(Collectors.toSet());
                        if (!domainsFromCertificate.containsAll(domainsExpected)) {
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' is missing the domains '" + domainsExpected.stream().filter(d -> !domainsFromCertificate.contains(d)).collect(Collectors.joining("', '")) + "'.");
                            return;
                        }
                        for (DomainValidation domainValidation : describeResult.certificate().domainValidationOptions()) {
                            String validationDomain = domainValidation.resourceRecord().name();
                            Optional<String> dnsRecord = this.awsdnsService.getDNSRecordValue(loadBalancer.getVirtualNetwork(), validationDomain, DNSservice.ZoneType.PUBLIC, DNSservice.RecordType.CNAME);
                            if (!dnsRecord.isEmpty()) continue;
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' is missing the CNAME record for the validation domain '" + validationDomain + "'.");
                        }
                        return;
                    }
                    catch (CertificateNotFoundException e) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' doesn't exist anymore in AWS");
                        return;
                    }
                }
                case AWS_ARN: {
                    if (loadBalancer.getAwsManagedCertificateARN() != null) {
                        try {
                            this.awsClientService.getACMClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService, FMApp.getFMSettingsUnsafe())).describeCertificate(loadBalancer.getAwsManagedCertificateARN());
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The certificate '" + loadBalancer.getAwsManagedCertificateARN() + "', created when the certificate mode was fully managed by FM, still exist in FM and AWS");
                        }
                        catch (CertificateNotFoundException e) {
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The certificate '" + loadBalancer.getAwsManagedCertificateARN() + "', created when the certificate mode was fully managed by FM, still exist in FM");
                        }
                    }
                    this.checkCertificateStatus(loadBalancer.getAwsCertificateARN(), loadBalancerPhysicalStatus, listener);
                    return;
                }
                default: {
                    if (listener.certificates().isEmpty()) return;
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The cloud load balancer has a certificate setup whereas the load balancer settings doesn't have one.");
                }
            }
            return;
        }
        catch (ListenerNotFoundException e) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_LISTENER, "Listener '" + currentPhysicalLoadBalancer.getAwsListenerARN() + "' not found.");
            return;
        }
        catch (Exception e) {
            loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of listener '" + currentPhysicalLoadBalancer.getAwsListenerARN() + "': " + e.getMessage());
        }
    }

    private void checkCertificateStatus(String certificateARN, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, Listener listener) {
        if (listener.certificates().isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer hasn't got a certificate setup whereas the load balancer settings has one.");
        } else {
            Optional<Certificate> certificateOptional = listener.certificates().stream().filter(c -> c.certificateArn().equals(certificateARN)).findAny();
            if (certificateOptional.isEmpty()) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer has certificate(s) ( '" + listener.certificates().stream().map(Certificate::certificateArn).collect(Collectors.joining(", ")) + "') but not the one setup in Fleet manager '" + certificateARN + "'.");
            }
        }
    }

    private static Action getDefaultAction() {
        return (Action)Action.builder().type(ActionTypeEnum.FIXED_RESPONSE).order(Integer.valueOf(1)).fixedResponseConfig((FixedResponseActionConfig)FixedResponseActionConfig.builder().statusCode("400").contentType("text/plain").messageBody("No available instance matching this hostname or instance not running.").build()).build();
    }

    private String createRule(LoadBalancingClientWrapper ec2, LogicalLoadBalancer lb, String fqdn, int priority, String listenerArn, String targetGroupArn) {
        Set<Tag> tags = AWSLBUtils.getLoadBalancerTagsForResource(this.tagService.getCloudApplicableTags(lb), lb.getName() + "-" + fqdn);
        return ec2.createRule(listenerArn, fqdn, targetGroupArn, priority, tags);
    }

    private String buildLoadBalancerTargetGroupLink(String regionId, String targetGroupArn) {
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#TargetGroup:targetGroupArn=" + targetGroupArn;
    }

    private String buildLoadBalancerRuleLink(String regionId, String ruleArn) {
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#ListenerRuleDetails:ruleArn=" + ruleArn;
    }

    private static void validateConfigurationSanity(LogicalLoadBalancer lb) {
        if (lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER && lb.getVirtualNetwork().getDnsStrategy() == VirtualNetwork.DNSStrategy.NONE) {
            throw new IllegalStateException("Certificate mode ACM is only supported if a managed DNS is configured on the virtual network.");
        }
        if (lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER && StringUtils.isBlank((CharSequence)lb.getVirtualNetwork().getAwsRoute53PublicIPZoneId())) {
            throw new IllegalStateException("Load Balancers can't use Certificate Manager if no Zone id for Public IP  is configured in the Virtual Network.");
        }
    }

    public static enum LoadBalancerAWSCodes implements InfoMessage.MessageCode
    {
        AWS_LB_NOT_PROVISIONED("AWS load balancer not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_LISTENER_NOT_PROVISIONED("AWS load balancer listener not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_RULES("AWS load balancer misses some rules", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_TARGET_MISSING_INSTANCES("AWS load balancer target missing some instances.", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_TARGET_UNWANTED_INSTANCES("AWS load balancer target has unwanted instances.", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SCHEME_NOT_ALIGNED("AWS load balancer scheme is not aligned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_PROVISIONING("AWS load balancer is provisioning", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_DELETED_IN_CLOUD("AWS load balancer has been deleted outside of FM", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_CLOUD_LISTENER("AWS load balancer does not have any listener in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_DNS_RECORD("AWS load balancer is missing DNS records in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_WRONG_DNS_RECORD("AWS load balancer has wrong DNS records in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING("Load balancer has some rules which needs to be updated.", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_ORPHANED_RULES("AWS load balancer contains orphaned rules", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_ORPHANED_TARGET("AWS load balancer rule contains orphaned targets", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_WRONG_NETWORK("AWS load balancer is not on the WRONG VPC", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SSL_SETUP("AWS load balancer has SSL setup", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SSL_NOT_SETUP("AWS load balancer has no SSL setup", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_API_ERROR("AWS API error", InfoMessage.FixabilityCategory.IRRELEVANT);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private LoadBalancerAWSCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private record RuleSummary(String arn, String fqdn, String targetGroupArn, int priority) {
    }
}

