/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ApiErrorException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CachingTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.CreationSourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskStorageAccountTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.EncryptionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ImageReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.PowerState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshot;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshots;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineDataDisk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachines;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZone;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.CloudInstanceServiceUtils;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.cloud.VolumeNotFoundException;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.azure.AzureImageCacheService;
import com.dataiku.fm.cloud.azure.AzureUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.tag.TagService;
import com.dataiku.fm.utils.DnsUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AzureCloudInstanceService
implements CloudInstanceServiceInterface {
    @Autowired
    private AzureClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private InstancesEventLogService eventsLogService;
    @Autowired
    private AzureImageCacheService imageCacheService;
    @Autowired
    private AzureDNSService azureDNSservice;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private FMApp fmApp;
    @Autowired
    @Qualifier(value="defaultKeys")
    private TagService defaultKeysTagService;
    @Autowired
    @Qualifier(value="sanitizedKeys")
    private TagService sanitizedKeysTagService;
    private static final String vmUserName = "centos";
    private static final int RESOURCE_NAME_MAX_LENGTH = 62;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.instances");

    private AzureInstanceUserDataFMInfo generateFMInfo(FMSettings settings, DnsZone dnsZone, LogicalInstance li) {
        AzureInstanceUserDataFMInfo fmInfo = new AzureInstanceUserDataFMInfo();
        CloudInstanceServiceUtils.fillFMInfo(this.cryptoService, fmInfo, settings, li, this.fmApp);
        switch (li.getVirtualNetwork().getHttpsStrategy()) {
            case NONE: {
                break;
            }
            case SELF_SIGNED: 
            case LETSENCRYPT: {
                switch (li.getVirtualNetwork().getDnsStrategy()) {
                    case NONE: {
                        break;
                    }
                    case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                        fmInfo.domainNamesForCertificate.add(DnsUtils.relativeSafeDnsName(li.getLabel(), dnsZone.name()));
                        break;
                    }
                    case FM_MANAGED_CLOUD_DNS_SERVICE: {
                        String subzone = li.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                        fmInfo.domainNamesForCertificate.add(DnsUtils.relativeSafeDnsName(li.getLabel(), subzone, dnsZone.name()));
                        break;
                    }
                }
                if (StringUtils.isNotBlank((String)li.getAdditionalDomainNamesForCertificate())) {
                    fmInfo.domainNamesForCertificate.addAll((Collection)JSON.parse((String)li.getAdditionalDomainNamesForCertificate(), JSON.StringList.class));
                }
                fmInfo.certbotStaging = Boolean.parseBoolean(System.getenv("DKU_FMMAIN_CERTBOT_STAGING"));
                fmInfo.contactMail = li.getVirtualNetwork().getContactMail();
                break;
            }
            case CUSTOM_CERTIFICATE: {
                fmInfo.sslCertificatePEM = li.getSslCertificatePEM();
                fmInfo.azureSSLCertificateSecretName = li.getAzureSSLCertificateSecretName();
                fmInfo.azureSSLCertificateSecretVersion = li.getAzureSSLCertificateSecretVersion();
                fmInfo.azureKeyvaultURL = li.getAzureKeyvaultUrl();
                fmInfo.sslCertificateKeyStorageMode = li.getSSLCertificateKeyStorageMode();
                fmInfo.azureSSLCertificateName = li.getAzureSSLCertificateName();
                fmInfo.azureSSLCertificateVersion = li.getAzureSSLCertificateVersion();
                fmInfo.azureSSLCertificateContentType = li.getAzureSSLCertificateContentType();
                CloudAccount cloudAccount = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                Identities dssIdentities = this.clientService.getAzureClient(cloudAccount).identities();
                String managedIdentityForStartup = null;
                if (StringUtils.isNotBlank((String)li.getAzureUserAssignedManagedServiceIdentity())) {
                    managedIdentityForStartup = li.getAzureUserAssignedManagedServiceIdentity();
                } else if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getStartupManagedIdentity())) {
                    managedIdentityForStartup = li.getInstanceSettingsTemplate().getStartupManagedIdentity();
                } else if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getRuntimeManagedIdentity())) {
                    managedIdentityForStartup = li.getInstanceSettingsTemplate().getRuntimeManagedIdentity();
                }
                if (managedIdentityForStartup == null) break;
                Identity identity = (Identity)dssIdentities.getById(managedIdentityForStartup);
                fmInfo.azureUserAssignedManagedServiceClientId = identity.clientId();
                break;
            }
            case AWS_ACM_PCA: {
                throw new NotImplementedException();
            }
        }
        fmInfo.restrictAzureMetadataServerAccess = li.getInstanceSettingsTemplate().isRestrictAzureMetadataServerAccess();
        fmInfo.runtimeManagedIdentity = li.getInstanceSettingsTemplate().getRuntimeManagedIdentity();
        return fmInfo;
    }

    private void checkIdentity(String identity, Identities identities, String cloudAccount) {
        if (StringUtils.isEmpty((String)identity)) {
            return;
        }
        try {
            Identity id = (Identity)identities.getById(identity);
            if (id == null) {
                throw new IllegalArgumentException("The managed identity '" + identity + "' was not found when using the network cloud account '" + cloudAccount + "'");
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("The managed identity '" + identity + "' was not found when using the network cloud account '" + cloudAccount + "': " + exc.getMessage());
        }
    }

    @Override
    public void checkInstanceCreation(VirtualNetwork vn, InstanceSettingsTemplate ist) {
        CloudAccount cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
        Identities identities = this.clientService.getAzureClient(cloudAccount).identities();
        this.checkIdentity(ist.getStartupManagedIdentity(), identities, vn.getCloudAccountOrVirtualCloudAccount().getLabel());
        this.checkIdentity(ist.getRuntimeManagedIdentity(), identities, vn.getCloudAccountOrVirtualCloudAccount().getLabel());
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolume(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        String region = li.getVirtualNetwork().getAzureRegion();
        String resourceGroupForCreatedResources = AzureUtils.getResourceGroupForCreatedResources(li.getVirtualNetwork());
        logger.infoV("Creating initial physical data volume in %s resource group", new Object[]{resourceGroupForCreatedResources});
        CloudAccount cloudAccount = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        Disk.DefinitionStages.WithCreate withCreate = (Disk.DefinitionStages.WithCreate)((Disk.DefinitionStages.WithDiskSource)((Disk.DefinitionStages.WithGroup)((Disk.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).disks().define(this.getResourceName(li.getAzureDataVolumeName(), li, "data-disk"))).withRegion(region)).withExistingResourceGroup(resourceGroupForCreatedResources)).withData().withSizeInGB(li.getDataVolumeSizeGB()).withSku(DiskSkuTypes.fromStorageAccountType((DiskStorageAccountTypes)DiskStorageAccountTypes.fromString((String)li.getDataVolumeType()))).withTags(AzureUtils.getTagsWithName("Datadir for " + li.getLabel() + " (DSS managed by FM)", this.defaultKeysTagService.getCloudApplicableTags(li)));
        if (li.isAzureAvailabilityZoneSpecified()) {
            withCreate = withCreate.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
        }
        Disk dataDisk = (Disk)withCreate.create();
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setAzureImageId(FMApp.getInstanceImagesSettings((Cloud)Cloud.AZURE).get((String)li.getImageId()).getAzureImageReferenceForRegion((String)region).reference);
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        pdv.setAzureDiskId(dataDisk.id());
        pdv.setCreationState(pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolumeFromExternalSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String externalSnapshotId) throws CodedException {
        Disk previous;
        Snapshots snapshots = this.clientService.getAzureClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).snapshots();
        Snapshot externalSnapshot = (Snapshot)snapshots.getById(externalSnapshotId);
        if (externalSnapshot == null) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_SNAPSHOT_NOTFOUND, String.format("Snapshot '%s' was not found. Ensure that the snapshot exists or is in the same subscription as Fleet Manager.", externalSnapshotId));
        }
        li.setDataVolumeSizeGB(externalSnapshot.sizeInGB());
        String resourceGroupForCreatedResources = AzureUtils.getResourceGroupForCreatedResources(li.getVirtualNetwork());
        logger.infoV("Creating physical data volume in %s resource group from external snapshot %s", new Object[]{resourceGroupForCreatedResources, externalSnapshotId});
        Disks disks = this.clientService.getAzureClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).disks();
        Disk disk = previous = li.getAzureDataVolumeName() != null ? (Disk)disks.getByResourceGroup(resourceGroupForCreatedResources, li.getAzureDataVolumeName()) : null;
        if (previous != null) {
            disks.deleteById(previous.id());
        }
        Disk.DefinitionStages.WithCreate withCreate = (Disk.DefinitionStages.WithCreate)((Disk.DefinitionStages.WithDiskSource)((Disk.DefinitionStages.WithGroup)((Disk.DefinitionStages.Blank)disks.define(this.getResourceName(li.getAzureDataVolumeName(), li, "data-disk"))).withRegion(FMApp.getFMSettingsUnsafe().azureSettings.regionId)).withExistingResourceGroup(resourceGroupForCreatedResources)).withLinuxFromSnapshot(externalSnapshot).withSku(DiskSkuTypes.fromStorageAccountType((DiskStorageAccountTypes)DiskStorageAccountTypes.fromString((String)li.getDataVolumeType()))).withTags(AzureUtils.getTagsWithName("Datadir for " + li.getLabel() + " (DSS managed by FM)", this.defaultKeysTagService.getCloudApplicableTags(li, Optional.empty(), Optional.of(externalSnapshotId))));
        if (li.isAzureAvailabilityZoneSpecified()) {
            withCreate = withCreate.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
        }
        Disk dataDisk = (Disk)withCreate.create();
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        pdv.setAzureDiskId(dataDisk.id());
        pdv.setCreationState(pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    private String getResourceName(String resourceName, LogicalInstance li, String resourceType) {
        String prefix = "dss-";
        String suffix = "-" + resourceType + "-" + SecretKeyGenerator.generate((int)8);
        String sanitizedName = com.dataiku.dip.utils.StringUtils.truncate((String)li.getLabel().replaceAll("[^a-zA-Z0-9\\-]", ""), (int)(62 - prefix.length() - suffix.length()));
        return StringUtils.isBlank((String)resourceName) ? prefix + sanitizedName + suffix : resourceName;
    }

    @Override
    public PhysicalDataVolume createPhysicalDataVolumeFromSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String snapshotId) {
        Disk previous;
        DataVolumeSnapshot dvs = (DataVolumeSnapshot)this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)snapshotId);
        if (dvs == null) {
            throw new IllegalStateException("Snapshot cannot be found: " + snapshotId);
        }
        String resourceGroupForCreatedResources = AzureUtils.getResourceGroupForCreatedResources(li.getVirtualNetwork());
        logger.infoV("Creating physical data volume in %s resource group", new Object[]{resourceGroupForCreatedResources});
        CloudAccount cloudAccount = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        Disks disks = this.clientService.getAzureClient(cloudAccount).disks();
        Disk disk = previous = li.getAzureDataVolumeName() != null ? (Disk)disks.getByResourceGroup(resourceGroupForCreatedResources, li.getAzureDataVolumeName()) : null;
        if (previous != null) {
            disks.deleteById(previous.id());
        }
        Disk.DefinitionStages.WithCreate withCreateDisk = (Disk.DefinitionStages.WithCreate)((Disk.DefinitionStages.WithDiskSource)((Disk.DefinitionStages.WithGroup)((Disk.DefinitionStages.Blank)disks.define(this.getResourceName(li.getAzureDataVolumeName(), li, "data-disk"))).withRegion(li.getVirtualNetwork().getAzureRegion())).withExistingResourceGroup(resourceGroupForCreatedResources)).withLinuxFromSnapshot(dvs.getAzureSnapshotId()).withSizeInGB(li.getDataVolumeSizeGB()).withSku(DiskSkuTypes.fromStorageAccountType((DiskStorageAccountTypes)DiskStorageAccountTypes.fromString((String)li.getDataVolumeType()))).withTags(AzureUtils.getTagsWithName("Datadir for " + li.getLabel() + " (DSS managed by FM)", this.defaultKeysTagService.getCloudApplicableTags(li, Optional.empty(), Optional.of(dvs.getId()))));
        if (li.isAzureAvailabilityZoneSpecified()) {
            withCreateDisk = withCreateDisk.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
        }
        Disk dataDisk = (Disk)withCreateDisk.create();
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        pdv.setAzureDiskId(dataDisk.id());
        pdv.setCreationState(pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public DataVolumeSnapshot createPhysicalDataVolumeSnapshot(LogicalInstance li, String snapshotType, String description) {
        Snapshot diskSnapshot;
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No PDV for instance: " + li.getId());
        }
        long now = System.currentTimeMillis();
        String azureValidDescription = description.replaceAll(" ", "-").toLowerCase();
        String snapshotId = String.format("fm-snap-%s-%s-%s", li.getId(), azureValidDescription, DKUDateUtils.isoFormatFileFriendlyLocal((long)now));
        String resourceGroupForCreatedResources = StringUtils.isNotBlank((String)li.getAzureRGForSnapshots()) ? li.getAzureRGForSnapshots() : AzureUtils.getResourceGroupForCreatedResources(li.getVirtualNetwork());
        boolean enableIncrementalSnapshot = Boolean.parseBoolean(DKUApp.getProperty((String)"dku.fm.azure.incrementalSnapshot", (String)"true"));
        logger.info((Object)("Create physical data volume " + (enableIncrementalSnapshot ? "incremental" : "full") + " snapshot: " + snapshotId + " in " + resourceGroupForCreatedResources + " resource group"));
        try {
            CloudAccount cloudAccount = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            diskSnapshot = (Snapshot)((Snapshot.DefinitionStages.WithCreate)((Snapshot.DefinitionStages.WithSnapshotSource)((Snapshot.DefinitionStages.WithGroup)((Snapshot.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).snapshots().define(snapshotId)).withRegion(li.getVirtualNetwork().getAzureRegion())).withExistingResourceGroup(resourceGroupForCreatedResources)).withDataFromDisk(pdv.getAzureDiskId()).withIncremental(enableIncrementalSnapshot).withTags(this.defaultKeysTagService.getSnapshotCloudApplicableTags(li, snapshotType, description, Optional.of("Name")).asMap())).create();
        }
        catch (Throwable e) {
            throw new VolumeNotFoundException(pdv.getAzureDiskId(), e);
        }
        DataVolumeSnapshot dvs = new DataVolumeSnapshot();
        dvs.setId("dvs-" + SecretKeyGenerator.generate((int)12));
        dvs.setLogicalInstance(li);
        dvs.setAzureSnapshotId(diskSnapshot.id());
        dvs.setCreationDate(now);
        dvs.setSnapshotType(snapshotType);
        dvs.setDescription(description);
        return dvs;
    }

    @Override
    public void deletePhysicalDataVolumeSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance logicalInstance) {
        CloudAccount cloudAccount = logicalInstance.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        Snapshots snapshotsClient = this.clientService.getAzureClient(cloudAccount).snapshots();
        snapshotsClient.deleteById(dataVolumeSnapshot.getAzureSnapshotId());
    }

    @Override
    public void deletePhysicalDataVolume(PhysicalDataVolume physicalDataVolume, LogicalInstance logicalInstance) {
        CloudAccount cloudAccount = logicalInstance.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        Disks disksClient = this.clientService.getAzureClient(cloudAccount).disks();
        disksClient.deleteById(physicalDataVolume.getAzureDiskId());
    }

    @Override
    public String createPhysicalInstance(LogicalInstance li, DKUtils.SmartLogTailBuilder smartLogTail) throws MessagingException, IOException, InterruptedException {
        VirtualMachine.DefinitionStages.WithCreate withCreate;
        CloudAccount cloudAccount;
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No PDV for instance: " + li.getId());
        }
        Hibernate.initialize((Object)li.getTenant());
        Tenant tenant = li.getTenant();
        assert (tenant != null);
        String region = li.getVirtualNetwork().getAzureRegion();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        DnsZone dnsZone = this.azureDNSservice.getDNSZone(li.getVirtualNetwork());
        String azureSshKey = li.getInstanceSettingsTemplate().getAzureSshKey();
        if (StringUtils.isBlank((String)azureSshKey)) {
            throw new ApplicativeException("Missing SSH key", "An SSH key must be set in instance template: " + li.getInstanceSettingsTemplate().getLabel());
        }
        String physicalInstanceId = "pi-" + SecretKeyGenerator.generate((int)12);
        logger.info((Object)("Creating the physical instance: " + physicalInstanceId));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
            PhysicalInstance pi = new PhysicalInstance();
            pi.setId(physicalInstanceId);
            pi.setLogicalInstance(li);
            pi.setCreationState(pics);
            rwt.getThreadEM().persist((Object)pics);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        VirtualNetwork vn = li.getVirtualNetwork();
        String resourceGroupForCreatedResources = AzureUtils.getResourceGroupForCreatedResources(vn);
        logger.info((Object)("Created the physical instance: " + physicalInstanceId + " in " + resourceGroupForCreatedResources + " resource group"));
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("cloudInstanceType", li.getCloudInstanceType()).with("imageId", li.getImageId()));
        CloudAccount cloudAccount1 = vn.getCloudAccountOrVirtualCloudAccount();
        CloudAccount cloudAccount4 = vn.getCloudAccountOrVirtualCloudAccount();
        NetworkInterface.DefinitionStages.WithPrimaryPrivateIP withPrimaryPrivateIP = ((NetworkInterface.DefinitionStages.WithPrimaryNetwork)((NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount1).networkInterfaces().define(this.getResourceName(li.getAzureNicName(), li, "nic"))).withRegion(region)).withExistingResourceGroup(resourceGroupForCreatedResources)).withExistingPrimaryNetwork((Network)this.clientService.getAzureClient(cloudAccount4).networks().getById(vn.getAzureVnId())).withSubnet(vn.getAzureSubnet());
        NetworkInterface.DefinitionStages.WithCreate withCreateNic = StringUtils.isNotBlank((String)li.getAzurePrivateIP()) ? withPrimaryPrivateIP.withPrimaryPrivateIPAddressStatic(li.getAzurePrivateIP()) : withPrimaryPrivateIP.withPrimaryPrivateIPAddressDynamic();
        logger.info((Object)("Assign existing Public IP: " + li.isAzureAssignPublicIP()));
        if (li.isAzureAssignPublicIP()) {
            CloudAccount cloudAccount2 = vn.getCloudAccountOrVirtualCloudAccount();
            PublicIpAddress publicIPAddress = (PublicIpAddress)this.clientService.getAzureClient(cloudAccount2).publicIpAddresses().getById(li.getAzurePublicIPId());
            withCreateNic = withCreateNic.withExistingPrimaryPublicIPAddress(publicIPAddress);
        } else if (li.getVirtualNetwork().isAzureAssignPublicIP()) {
            String publicIPName = this.getResourceName(li.getAzurePublicIPName(), li, "publicIP");
            cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
            PublicIpAddress.DefinitionStages.WithCreate publicIP = (PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).publicIpAddresses().define(publicIPName)).withRegion(region)).withExistingResourceGroup(resourceGroupForCreatedResources)).withSku(PublicIPSkuType.STANDARD).withStaticIP().withLeafDomainLabel(publicIPName).withTags(AzureUtils.getTagsWithName(String.format("Public IP address for %s", li.getLabel()), this.defaultKeysTagService.getCloudApplicableTags(li, physicalInstanceId)));
            if (li.isAzureAvailabilityZoneSpecified()) {
                publicIP = publicIP.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
            }
            withCreateNic = withCreateNic.withNewPrimaryPublicIPAddress((Creatable)publicIP);
        }
        NetworkInterface networkInterface = (NetworkInterface)((NetworkInterface.DefinitionStages.WithCreate)withCreateNic.withTags(AzureUtils.getTagsWithName(String.format("Network interface for %s", li.getLabel()), this.defaultKeysTagService.getCloudApplicableTags(li, physicalInstanceId)))).create();
        cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
        VirtualMachine.DefinitionStages.WithProximityPlacementGroup withOS = ((VirtualMachine.DefinitionStages.WithNetwork)((VirtualMachine.DefinitionStages.WithGroup)((VirtualMachine.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).virtualMachines().define(this.getResourceName(li.getAzureInstanceName(), li, "vm"))).withRegion(region)).withExistingResourceGroup(resourceGroupForCreatedResources)).withExistingPrimaryNetworkInterface(networkInterface);
        int osDiskSize = li.getRootVolumeSizeGB() != null ? li.getRootVolumeSizeGB() : 32;
        logger.info((Object)("Created OS disk with size= " + osDiskSize));
        CloudAccount cloudAccount3 = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        Disks tenantDisks = this.clientService.getAzureClient(cloudAccount3).disks();
        Disk dataDisk = (Disk)tenantDisks.getById(pdv.getAzureDiskId());
        if (dataDisk == null) {
            throw new IllegalStateException(String.format("Data disk '%s' was not found, either reprovision from a snapshot, or re-create a new DSS instance using template '%s'", pdv.getAzureDiskId(), li.getInstanceSettingsTemplate().getId()));
        }
        if (dataDisk.sizeInGB() != li.getDataVolumeSizeGB()) {
            logger.info((Object)("Resizing data disk from size= " + dataDisk.sizeInGB() + "GB to size=" + li.getDataVolumeSizeGB() + "GB"));
            ((Disk.Update)dataDisk.update()).withSizeInGB(li.getDataVolumeSizeGB()).apply();
        }
        InstanceImagesSettings.AzureInstanceImageReference azureImageReferenceForRegion = FMApp.getInstanceImagesSettings(Cloud.AZURE).get(li.getImageId()).getAzureImageReferenceForRegion(region);
        if (azureImageReferenceForRegion.type == InstanceImagesSettings.AzureImageType.URN) {
            wmc = withOS.withSpecificLinuxImageVersion(AzureCloudInstanceService.toAzureImageReference(azureImageReferenceForRegion)).withRootUsername(vmUserName).withSsh(azureSshKey).withCustomData(CloudInstanceServiceUtils.generateUserData(this.generateFMInfo(settings, dnsZone, li))).withExistingDataDisk(dataDisk);
            if (li.isAzureAvailabilityZoneSpecified()) {
                wmc = wmc.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
            }
            if (li.getDataVolumeSizeGB() > 4000) {
                wmc = wmc.withDataDiskDefaultCachingType(CachingTypes.NONE);
            }
            withCreate = wmc.withOSDiskStorageAccountType(StorageAccountTypes.fromString((String)li.getDataVolumeType())).withOSDiskSizeInGB(osDiskSize);
        } else if (azureImageReferenceForRegion.type == InstanceImagesSettings.AzureImageType.RESOURCE_ID) {
            wmc = withOS.withGeneralizedLinuxCustomImage(azureImageReferenceForRegion.reference).withRootUsername(vmUserName).withSsh(azureSshKey).withCustomData(CloudInstanceServiceUtils.generateUserData(this.generateFMInfo(settings, dnsZone, li))).withExistingDataDisk(dataDisk);
            if (li.isAzureAvailabilityZoneSpecified()) {
                wmc = wmc.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
            }
            if (li.getDataVolumeSizeGB() > 4000) {
                wmc = wmc.withDataDiskDefaultCachingType(CachingTypes.NONE);
            }
            withCreate = wmc.withOSDiskStorageAccountType(StorageAccountTypes.fromString((String)li.getDataVolumeType())).withOSDiskSizeInGB(osDiskSize);
        } else if (azureImageReferenceForRegion.type == InstanceImagesSettings.AzureImageType.VHD) {
            String azureManagedImageResourceId = this.imageCacheService.cacheAndGetVirtualMachineCustomImage(vn.getCloudAccountOrVirtualCloudAccount(), settings, azureImageReferenceForRegion, region, smartLogTail);
            VirtualMachine.DefinitionStages.WithManagedCreate wmc = withOS.withGeneralizedLinuxCustomImage(azureManagedImageResourceId).withRootUsername(vmUserName).withSsh(azureSshKey).withCustomData(CloudInstanceServiceUtils.generateUserData(this.generateFMInfo(settings, dnsZone, li))).withExistingDataDisk(dataDisk);
            if (li.isAzureAvailabilityZoneSpecified()) {
                wmc = wmc.withAvailabilityZone(this.getAvailabilityZoneIdFromName(li.getAzureAvailabilityZone()));
            }
            if (li.getDataVolumeSizeGB() > 4000) {
                wmc = wmc.withDataDiskDefaultCachingType(CachingTypes.NONE);
            }
            withCreate = wmc.withOSDiskStorageAccountType(StorageAccountTypes.fromString((String)li.getDataVolumeType())).withOSDiskSizeInGB(osDiskSize);
        } else {
            throw new UnsupportedOperationException("VM creation is supported only with URN or with a image resource id");
        }
        withCreate.withOSDiskName(this.getResourceName(li.getAzureOSVolumeName(), li, "os-disk"));
        String managedIdentity = null;
        if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getStartupManagedIdentity())) {
            managedIdentity = li.getInstanceSettingsTemplate().getStartupManagedIdentity();
        } else if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getRuntimeManagedIdentity())) {
            managedIdentity = li.getInstanceSettingsTemplate().getRuntimeManagedIdentity();
        }
        try {
            CloudAccount cloudAccount2;
            if (StringUtils.isNotBlank((String)managedIdentity)) {
                cloudAccount2 = vn.getCloudAccountOrVirtualCloudAccount();
                withCreate = withCreate.withExistingUserAssignedManagedServiceIdentity((Identity)this.clientService.getAzureClient(cloudAccount2).identities().getById(managedIdentity));
            }
            if (StringUtils.isNotBlank((String)li.getAzureUserAssignedManagedServiceIdentity())) {
                cloudAccount2 = vn.getCloudAccountOrVirtualCloudAccount();
                withCreate = withCreate.withExistingUserAssignedManagedServiceIdentity((Identity)this.clientService.getAzureClient(cloudAccount2).identities().getById(li.getAzureUserAssignedManagedServiceIdentity()));
            }
        }
        catch (NullPointerException e) {
            String message = "An error occurred. Most probably, the provided managed identity does not exist. Used managed identity: " + managedIdentity;
            logger.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
        try {
            Disk.Update tagsUpdate = (Disk.Update)dataDisk.update();
            Optional<String> restoreFromSnapshotIdOptional = dataDisk.source().type() == CreationSourceType.COPIED_FROM_SNAPSHOT ? Optional.of(dataDisk.source().sourceId()) : Optional.empty();
            ((DiskInner)dataDisk.innerModel()).withTags(AzureUtils.getTagsWithName("Datadir for " + li.getLabel() + " (DSS managed by FM)", this.defaultKeysTagService.getCloudApplicableTags(li, Optional.of(physicalInstanceId), restoreFromSnapshotIdOptional)));
            tagsUpdate.apply();
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to update tags on data disk '%s' in resource group '%s'. Skipping.", new Object[]{dataDisk.id(), dataDisk.resourceGroupName()});
        }
        VirtualMachine virtualMachine = (VirtualMachine)((VirtualMachine.DefinitionStages.WithCreate)withCreate.withSize(VirtualMachineSizeTypes.fromString((String)li.getCloudInstanceType())).withTags(AzureUtils.getTagsWithName(li.getLabel() + " (DSS managed by FM)", this.defaultKeysTagService.getCloudApplicableTags(li, physicalInstanceId)))).create();
        if (li.getEncryptDataVolume() && StringUtils.isNotBlank((String)li.getDataVolumeEncryptionKey())) {
            virtualMachine.deallocate();
            Disk.Update update = (Disk.Update)dataDisk.update();
            Encryption encryption = new Encryption().withDiskEncryptionSetId(li.getDataVolumeEncryptionKey()).withType(EncryptionType.ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY);
            ((DiskInner)dataDisk.innerModel()).withEncryption(encryption);
            update.apply();
            if (li.getEncryptRootVolume()) {
                CloudAccount cloudAccount2 = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                Disk rootDisk = (Disk)this.clientService.getAzureClient(cloudAccount2).disks().getById(virtualMachine.osDiskId());
                Disk.Update update2 = (Disk.Update)rootDisk.update();
                Encryption encryption2 = new Encryption().withDiskEncryptionSetId(li.getDataVolumeEncryptionKey()).withType(EncryptionType.ENCRYPTION_AT_REST_WITH_CUSTOMER_KEY);
                ((DiskInner)rootDisk.innerModel()).withEncryption(encryption2);
                update2.apply();
            }
            virtualMachine.start();
        }
        String azureVMInstanceId = virtualMachine.id();
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-vm-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("azureVMInstanceId", azureVMInstanceId));
        this.eventsLogService.addEventASync_NT(li, null, "pi-volume-attached", JF.obj().with("physicalInstanceId", physicalInstanceId).with("azureVMInstanceId", azureVMInstanceId));
        logger.info((Object)("Updating physical instance: " + physicalInstanceId + " with VM instance id: " + azureVMInstanceId));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstance pi = (PhysicalInstance)this.dbService.getThreadEM().find(PhysicalInstance.class, (Object)physicalInstanceId);
            pi.setAzureVMInstanceId(azureVMInstanceId);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        String targetPublicIP = this.getPublicIPToAssignDNSTo(li, virtualMachine);
        Map<String, String> tags = AzureUtils.getTagsWithName("DNS record for " + li.getLabel() + " (DSS managed by FM)", this.sanitizedKeysTagService.getCloudApplicableTags(li));
        this.azureDNSservice.addDNSRecords(li.getVirtualNetwork(), li.getLabel(), targetPublicIP, virtualMachine.getPrimaryNetworkInterface().primaryPrivateIP(), DNSservice.RecordType.A, tags);
        try {
            List<DataVolumeSnapshot> snapshots = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", li);
            if (snapshots == null || snapshots.isEmpty()) {
                logger.debugV("The instance '%s' has no linked snapshots, or none was found", new Object[]{li.getLabel()});
            } else {
                Snapshots snapshotClient = this.clientService.getAzureClient(cloudAccount3).snapshots();
                for (DataVolumeSnapshot dvs : snapshots) {
                    String snapshotId = dvs.getAzureSnapshotId();
                    if (StringUtils.isBlank((String)snapshotId)) continue;
                    try {
                        Snapshot snapshot = (Snapshot)snapshotClient.getById(snapshotId);
                        CloudTagList newTags = this.defaultKeysTagService.getSnapshotCloudApplicableTags(li, dvs.getSnapshotType(), dvs.getDescription(), Optional.of("Name"));
                        Snapshot.Update update = (Snapshot.Update)((Snapshot.Update)snapshot.update()).withTags(newTags.asMap());
                        update.apply();
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Unable to update tags on snapshot '%s' for instance '%s'. Skipping.", new Object[]{snapshotId, li.getLabel()});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to update tags on snapshots for instance '%s'. Skipping.", new Object[]{li.getLabel()});
        }
        return physicalInstanceId;
    }

    private AvailabilityZoneId getAvailabilityZoneIdFromName(String availabilityZoneName) {
        AvailabilityZoneId availabilityZoneId = AvailabilityZoneId.fromString((String)availabilityZoneName);
        if (availabilityZoneId == null) {
            throw new IllegalArgumentException("The specified availability zone is not recognized: " + availabilityZoneName);
        }
        return availabilityZoneId;
    }

    @Override
    public boolean growPhysicalDataVolume(LogicalInstance li, double growthFactor) {
        return false;
    }

    private String getPublicIPToAssignDNSTo(LogicalInstance li, VirtualMachine virtualMachine) {
        if (li.isAzureAssignPublicIP()) {
            CloudAccount cloudAccount = li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            return ((PublicIpAddress)this.clientService.getAzureClient(cloudAccount).publicIpAddresses().getById(li.getAzurePublicIPId())).ipAddress();
        }
        if (li.getVirtualNetwork().isAzureAssignPublicIP()) {
            return virtualMachine.getPrimaryPublicIPAddress().ipAddress();
        }
        return null;
    }

    @Override
    public void terminatePhysicalInstance(PhysicalInstance pi) {
        CloudAccount cloudAccount1 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount1).virtualMachines().getById(pi.getAzureVMInstanceId());
        String primaryNetworkInterfaceId = virtualMachine.primaryNetworkInterfaceId();
        String osDiskId = virtualMachine.osDiskId();
        String primaryPublicIPAddressId = virtualMachine.getPrimaryPublicIPAddressId();
        logger.infoV("Requesting termination of instance li=%s pi=%s azurevm=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        this.clientService.getAzureClient(cloudAccount).virtualMachines().deleteById(pi.getAzureVMInstanceId());
        this.azureDNSservice.removeDNSRecords(pi.getLogicalInstance().getVirtualNetwork(), DnsUtils.relativeSafeDnsName(pi.getLogicalInstance().getLabel(), new String[0]), DNSservice.RecordType.A, true);
        logger.infoV("Termination of instance li=%s pi=%s azurevm=%s completed", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
        logger.infoV("Requesting removal of vm instance primary network interface li=%s pi=%s interface=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), primaryNetworkInterfaceId});
        CloudAccount cloudAccount2 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        this.clientService.getAzureClient(cloudAccount2).networkInterfaces().deleteById(primaryNetworkInterfaceId);
        logger.infoV("Requesting removal of vm instance disk li=%s pi=%s instance disk=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), osDiskId});
        CloudAccount cloudAccount3 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        this.clientService.getAzureClient(cloudAccount3).disks().deleteById(osDiskId);
        if (StringUtils.isNotEmpty((String)primaryPublicIPAddressId) && !pi.getLogicalInstance().isAzureAssignPublicIP()) {
            logger.infoV("Requesting removal of vm primary public IP Address li=%s pi=%s address=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), primaryPublicIPAddressId});
            CloudAccount cloudAccount4 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            this.clientService.getAzureClient(cloudAccount4).publicIpAddresses().deleteById(primaryPublicIPAddressId);
        }
    }

    @Override
    public void startPhysicalInstance(PhysicalInstance pi) {
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(pi.getAzureVMInstanceId());
        logger.infoV("Requesting start of instance li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
        virtualMachine.start();
        logger.infoV("Instance started li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
    }

    @Override
    public void stopPhysicalInstance(PhysicalInstance pi) {
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(pi.getAzureVMInstanceId());
        logger.infoV("Requesting deallocate of instance li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
        virtualMachine.deallocate();
        logger.infoV("Instance deallocate done li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
    }

    @Override
    public void rebootPhysicalInstance(PhysicalInstance pi) {
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(pi.getAzureVMInstanceId());
        logger.infoV("Requesting restart of instance li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
        virtualMachine.restart();
        logger.infoV("Instance restarted li=%s pi=%s azure=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), pi.getAzureVMInstanceId()});
    }

    @Override
    public void configurePhysicalInstanceBeforeStartupPhase(PhysicalInstance pi) {
        logger.info((Object)"Instance is starting up, switching the managed identity if needed");
        String runtimeManagedIdentity = pi.getLogicalInstance().getInstanceSettingsTemplate().getRuntimeManagedIdentity();
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(pi.getAzureVMInstanceId());
        Set userAssignedManagedServiceIdentityIds = virtualMachine.userAssignedManagedServiceIdentityIds();
        VirtualMachine.Update update = (VirtualMachine.Update)virtualMachine.update();
        String startupIdentity = pi.getLogicalInstance().getInstanceSettingsTemplate().getStartupManagedIdentity();
        if (StringUtils.isNotBlank((String)startupIdentity)) {
            String startupIdentityFound;
            logger.info((Object)"A startup identity is specified for this instance.");
            boolean updateNeeded = false;
            if (StringUtils.isNotBlank((String)runtimeManagedIdentity)) {
                String runtimeIdentityFound;
                String string = runtimeIdentityFound = StringUtils.isNotBlank((String)runtimeManagedIdentity) ? AzureCloudInstanceService.find(userAssignedManagedServiceIdentityIds, runtimeManagedIdentity) : null;
                if (runtimeIdentityFound != null) {
                    logger.info((Object)("Instance has a runtime identity " + runtimeManagedIdentity + ", disassociating runtime one first"));
                    update = update.withoutUserAssignedManagedServiceIdentity(runtimeManagedIdentity);
                    updateNeeded = true;
                }
            }
            String string = startupIdentityFound = StringUtils.isNotBlank((String)startupIdentity) ? AzureCloudInstanceService.find(userAssignedManagedServiceIdentityIds, startupIdentity) : null;
            if (startupIdentityFound == null) {
                logger.info((Object)("Instance doesn't have the startup identity " + startupIdentity + " associated yet, need to associate it to the VM"));
                CloudAccount cloudAccount1 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                update = update.withExistingUserAssignedManagedServiceIdentity((Identity)this.clientService.getAzureClient(cloudAccount1).identities().getById(startupIdentity));
                updateNeeded = true;
            }
            if (updateNeeded) {
                update.apply();
            }
        }
    }

    @Override
    public void configurePhysicalInstanceAfterStartupPhase(PhysicalInstance pi) {
        logger.info((Object)"Instance has finished startup, switching the managed identity if needed");
        String runtimeManagedIdentity = pi.getLogicalInstance().getInstanceSettingsTemplate().getRuntimeManagedIdentity();
        CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(pi.getAzureVMInstanceId());
        Set userAssignedManagedServiceIdentityIds = virtualMachine.userAssignedManagedServiceIdentityIds();
        VirtualMachine.Update update = (VirtualMachine.Update)virtualMachine.update();
        boolean needUpdate = false;
        if (!userAssignedManagedServiceIdentityIds.isEmpty()) {
            String startupIdentity;
            String startupIdentityFound;
            boolean disassociate = false;
            if (StringUtils.isBlank((String)runtimeManagedIdentity)) {
                logger.info((Object)"Instance has no runtime user managed identity profile, disassociating");
                disassociate = true;
            }
            String string = startupIdentityFound = StringUtils.isNotBlank((String)(startupIdentity = pi.getLogicalInstance().getInstanceSettingsTemplate().getStartupManagedIdentity())) ? AzureCloudInstanceService.find(userAssignedManagedServiceIdentityIds, startupIdentity) : null;
            if (StringUtils.isNotBlank((String)runtimeManagedIdentity) && startupIdentityFound != null) {
                logger.info((Object)("Instance has different runtime user managed identity " + runtimeManagedIdentity + ", disassociating startup one"));
                disassociate = true;
            }
            if (disassociate && StringUtils.isNotBlank((String)startupIdentityFound)) {
                update = update.withoutUserAssignedManagedServiceIdentity(startupIdentityFound);
                needUpdate = true;
            }
        }
        if (StringUtils.isNotBlank((String)runtimeManagedIdentity)) {
            CloudAccount cloudAccount1 = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            update.withExistingUserAssignedManagedServiceIdentity((Identity)this.clientService.getAzureClient(cloudAccount1).identities().getById(runtimeManagedIdentity));
            needUpdate = true;
        }
        if (needUpdate) {
            update.apply();
        }
    }

    @Override
    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(Tenant tenant, Collection<PhysicalInstance> piList) {
        return piList.stream().collect(Collectors.groupingBy(physicalInstance -> physicalInstance.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount())).entrySet().stream().flatMap(e -> this.getPhysicalInstancesCloudState((CloudAccount)e.getKey(), (Collection<PhysicalInstance>)((Collection)e.getValue())).stream()).collect(Collectors.toList());
    }

    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(CloudAccount cloudAccount, Collection<PhysicalInstance> piList) {
        VirtualMachines virtualMachines = this.clientService.getAzureClient(cloudAccount).virtualMachines();
        ArrayList<PhysicalInstanceCloudState> states = new ArrayList<PhysicalInstanceCloudState>(piList.size());
        for (PhysicalInstance pi : piList) {
            PhysicalInstanceCloudState state = new PhysicalInstanceCloudState(pi);
            if (pi.getAzureVMInstanceId() != null) {
                try {
                    VirtualMachine instance = (VirtualMachine)virtualMachines.getById(pi.getAzureVMInstanceId());
                    state.cloudMachineExists = true;
                    if (instance.powerState() == PowerState.RUNNING || instance.powerState() == PowerState.STARTING) {
                        state.cloudMachineIsUp = true;
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to describe physical instance " + pi.getId() + ", it is probably not available"), e);
                }
            }
            states.add(state);
        }
        return states;
    }

    @Override
    public void fillPhysicalStatusWithCloudSpecificData(PhysicalInstance pi, PhysicalDataVolume pdv, PublicPhysicalInstanceStatus status) {
        String azureVMInstanceId = pi.getAzureVMInstanceId();
        if (azureVMInstanceId == null) {
            return;
        }
        try {
            String state;
            CloudAccount cloudAccount = pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(azureVMInstanceId);
            status.azureInstanceName = virtualMachine.name();
            status.azureResouceGroup = virtualMachine.resourceGroupName();
            status.azureOSVolumeName = virtualMachine.storageProfile().osDisk().name();
            VirtualMachineDataDisk dataDisk = (VirtualMachineDataDisk)virtualMachine.dataDisks().get(0);
            status.azureDataVolumeName = dataDisk.name();
            status.azureDataVolumeResourceGroup = ResourceId.fromString((String)dataDisk.id()).resourceGroupName();
            status.externalURL = pi.getLogicalInstance().getExternalURL();
            Set availabilityZoneIds = virtualMachine.availabilityZones();
            status.azureAvailabilityZone = StringUtils.join((Collection)availabilityZoneIds, (String)",");
            switch (state = virtualMachine.powerState() == null ? "GONE" : virtualMachine.powerState().toString()) {
                case "PowerState/deallocated": 
                case "PowerState/deallocating": {
                    status.cloudMachineExists = true;
                    status.cloudMachineIsUp = false;
                    status.cloudInTransition = virtualMachine.powerState() == PowerState.DEALLOCATING;
                    break;
                }
                case "PowerState/running": 
                case "PowerState/starting": {
                    status.cloudMachineExists = true;
                    status.cloudMachineIsUp = true;
                    status.cloudInTransition = virtualMachine.powerState() == PowerState.STARTING;
                    break;
                }
                case "PowerState/stopped": 
                case "PowerState/stopping": {
                    status.cloudMachineExists = true;
                    status.cloudMachineIsUp = false;
                    status.cloudInTransition = virtualMachine.powerState() == PowerState.STOPPING;
                    status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "Azure VM is not RUNNING: it is '%s'", new Object[]{virtualMachine.powerState().toString()});
                    break;
                }
                case "GONE": {
                    status.cloudMachineExists = false;
                    status.cloudMachineIsUp = false;
                    status.cloudInTransition = false;
                }
            }
            NetworkInterface networkInterface = virtualMachine.getPrimaryNetworkInterface();
            status.azureNicName = networkInterface.name();
            NicIpConfiguration primaryIPConfiguration = networkInterface.primaryIPConfiguration();
            status.privateIP = primaryIPConfiguration.privateIpAddress();
            PublicIpAddress publicIPAddress = primaryIPConfiguration.getPublicIpAddress();
            if (publicIPAddress != null) {
                status.publicIP = publicIPAddress.ipAddress();
                status.azurePublicIPName = publicIPAddress.name();
            }
        }
        catch (Exception e) {
            ApiErrorException apiErrorException;
            if (e.getMessage() != null && e.getMessage().contains("Parameter resourceGroupName is required and cannot be null")) {
                logger.warn((Object)"Failed to describe instance, it's probably not available as resource group not set yet");
            } else if (e instanceof ApiErrorException && (apiErrorException = (ApiErrorException)e).getValue().getCode().equals("ResourceNotFound")) {
                logger.info((Object)("Resource not available yet. Message: " + apiErrorException.getValue().getMessage()));
            } else {
                logger.warn((Object)"Failed to describe instance, it's probably not available", (Throwable)e);
            }
            status.cloudMachineExists = false;
            status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "Failed to get the status of the Azure VM: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        LogicalInstance li = pi.getLogicalInstance();
        VirtualNetwork virtualNetwork = li.getVirtualNetwork();
        logger.info((Object)("DNS strategy: " + String.valueOf((Object)virtualNetwork.getDnsStrategy())));
        Map<DNSservice.ZoneType, String> domains = this.azureDNSservice.getFQDNs(virtualNetwork, li.getLabel());
        if (domains != null) {
            if (domains.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                status.privateDNS = domains.get((Object)DNSservice.ZoneType.PRIVATE);
            }
            if (domains.containsKey((Object)DNSservice.ZoneType.PUBLIC)) {
                status.publicDNS = domains.get((Object)DNSservice.ZoneType.PUBLIC);
            }
        }
        status.privateURL = AzureCloudInstanceService.computeUrl(virtualNetwork, status.privateDNS, status.privateIP);
        status.publicURL = StringUtils.isBlank((String)status.externalURL) ? AzureCloudInstanceService.computeUrl(virtualNetwork, status.publicDNS, status.publicIP) : status.externalURL;
    }

    private static String computeUrl(VirtualNetwork virtualNetwork, String dnsName, String ip) {
        String prefix;
        String string = prefix = virtualNetwork.getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? "http://" : "https://";
        if (dnsName != null) {
            return StringUtils.removeEnd((String)(prefix + dnsName), (String)".");
        }
        if (ip != null) {
            return prefix + ip;
        }
        return null;
    }

    private static String find(Set<String> userAssignedManagedServiceIdentityIds, String startupManagedIdentity) {
        if (!userAssignedManagedServiceIdentityIds.contains(startupManagedIdentity)) {
            for (String identityId : userAssignedManagedServiceIdentityIds) {
                if (!identityId.equalsIgnoreCase(startupManagedIdentity)) continue;
                return identityId;
            }
            return null;
        }
        return startupManagedIdentity;
    }

    private static ImageReference toAzureImageReference(InstanceImagesSettings.AzureInstanceImageReference azureImageReferenceForRegion) {
        if (azureImageReferenceForRegion.type != InstanceImagesSettings.AzureImageType.URN) {
            throw new IllegalArgumentException("Trying to convert a non URN instance image reference");
        }
        Matcher matcher = Pattern.compile("(.+):(.+):([\\d.]+):(.+)").matcher(azureImageReferenceForRegion.reference);
        if (matcher.find()) {
            return new ImageReference().withPublisher(matcher.group(1)).withOffer(matcher.group(2)).withSku(matcher.group(3)).withVersion(matcher.group(4));
        }
        throw new IllegalArgumentException("Cannot decode URN:" + azureImageReferenceForRegion.reference);
    }

    static class AzureInstanceUserDataFMInfo
    extends CloudInstanceServiceUtils.BaseInstanceUserDataFMInfo {
        String azureSSLCertificateSecretName;
        String azureSSLCertificateSecretVersion;
        String azureKeyvaultURL;
        String azureSSLCertificateName;
        String azureSSLCertificateVersion;
        InstanceSettingsTemplate.CertificateContentType azureSSLCertificateContentType;
        String azureUserAssignedManagedServiceClientId;
        boolean restrictAzureMetadataServerAccess;
        String runtimeManagedIdentity;

        AzureInstanceUserDataFMInfo() {
        }
    }
}

