/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.AzureResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkPeering;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Subnet;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.CloudNetworkServiceUtils;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.azure.AzureInstanceMetadataReader;
import com.dataiku.fm.cloud.azure.AzureUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Priority;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureCloudNetworkService
implements CloudNetworkServiceInterface {
    @Autowired
    private AzureClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudAccountsService cloudAccountsService;
    @Autowired
    private AzureDNSService azureDNSService;
    private static final String resourceGroupPrefix = "dssRG-";
    private static final String subnetPrefix = "dssSubnet-";
    private static final String securityGroupPrefix = "dssSG-";
    private static final String peeringPrefix = "dssPeer-";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.network");

    @Override
    public VirtualNetwork createManagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO protoVirtualNetworkDTO, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        VirtualNetwork newVN;
        String rgName = resourceGroupPrefix + SecretKeyGenerator.generate((int)8);
        String subnetName = subnetPrefix + SecretKeyGenerator.generate((int)8);
        String securityGroupName = securityGroupPrefix + SecretKeyGenerator.generate((int)8);
        String vnetId = "vn-" + SecretKeyGenerator.generate((int)12);
        String cidr = CloudNetworkServiceUtils.findUniqueCIDR(this.dbService);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        CloudAccount cloudAccount = StringUtils.isNotEmpty((String)protoVirtualNetworkDTO.accountId) ? this.cloudAccountsService.getAccountMandatory(tenant, protoVirtualNetworkDTO.accountId) : tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            newVN = new VirtualNetwork();
            newVN.setId(vnetId);
            newVN.setManagedCidr(cidr);
            if (StringUtils.isNotEmpty((String)protoVirtualNetworkDTO.accountId)) {
                newVN.setCloudAccount(cloudAccount);
            }
            newVN.setTenant(tenant);
            rwt.getThreadEM().persist((Object)newVN);
            smartLogTail.appendLine("Creating virtual network entity in DB ...", logger, Priority.INFO);
            rwt.commit();
            smartLogTail.replaceLastLine("Virtual network entity in DB created", logger, Priority.INFO);
        }
        rwt = this.dbService.rwTransaction();
        try {
            Network dss_vnet;
            NetworkSecurityGroup networkSecurityGroup;
            newVN = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)vnetId);
            newVN.setLabel(protoVirtualNetworkDTO.label);
            newVN.setDescription(protoVirtualNetworkDTO.description);
            newVN.setCloudTags(CloudTagList.toJSON(protoVirtualNetworkDTO.cloudTags));
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            NetworkSecurityGroup.DefinitionStages.WithCreate nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithGroup)((NetworkSecurityGroup.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).networkSecurityGroups().define(securityGroupName)).withRegion(Region.fromName((String)settings.azureSettings.regionId))).withNewResourceGroup(rgName)).withTags(AzureUtils.getTagsWithName(securityGroupName, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())));
            switch (protoVirtualNetworkDTO.mode) {
                case FM_MANAGED: 
                case EXISTING_MONOTENANT: {
                    nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithCreate)nsgWithCreate.defineRule("FMtoDSSinstances").allowInbound().fromAddress(settings.azureSettings.fmServerCIDR).fromAnyPort().toAnyAddress().toPortRanges(new String[]{"22", "80", "443"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(100).attach()).defineRule("DSSinstancesToFM").allowOutbound().fromAnyAddress().fromAnyPort().toAddress(settings.azureSettings.fmServerCIDR).toAnyPort().withAnyProtocol().withPriority(100).attach();
                    break;
                }
                case EXISTING_MULTITENANT_PUBLIC_IP: {
                    if (protoVirtualNetworkDTO.allowIngressSSH) {
                        nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)nsgWithCreate.defineRule("FMtoDSSinstances").allowInbound().fromAddress(settings.azureSettings.fmServerCIDR).fromAnyPort().toAnyAddress().toPortRanges(new String[]{"22"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(100).attach();
                    }
                    nsgWithCreate.defineRule("DSSinstancesToFM").allowOutbound().fromAnyAddress().fromAnyPort().toAddress(settings.azureSettings.fmServerCIDR).toAnyPort().withAnyProtocol().withPriority(100).attach();
                }
            }
            switch (protoVirtualNetworkDTO.internetAccessMode) {
                case NO: {
                    nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithCreate)nsgWithCreate.defineRule("DenyInternetInbound").denyInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toAnyPort().withAnyProtocol().withPriority(101).attach()).defineRule("DenyInternetOutbound").denyOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                    break;
                }
                case EGRESS_ONLY: {
                    nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithCreate)nsgWithCreate.defineRule("DenyInternetInbound").denyInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toAnyPort().withAnyProtocol().withPriority(101).attach()).defineRule("AllowInternetOutbound").allowOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                    break;
                }
                case YES: {
                    nsgWithCreate = (NetworkSecurityGroup.DefinitionStages.WithCreate)((NetworkSecurityGroup.DefinitionStages.WithCreate)nsgWithCreate.defineRule("AllowInternetInbound").allowInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toPortRanges(new String[]{"80", "443"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(101).attach()).defineRule("AllowInternetOutbound").allowOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                }
            }
            try (FutureProgress.AutocloseableFutureProgressState securityGroupStep = FutureProgress.pushAutoCloseableState((String)"Creating network security group");){
                networkSecurityGroup = (NetworkSecurityGroup)nsgWithCreate.create();
            }
            FutureProgress.updateState((double)1.0);
            try (FutureProgress.AutocloseableFutureProgressState virtualNetworkStep = FutureProgress.pushAutoCloseableState((String)"Creating virtual network");){
                smartLogTail.appendLine("Creating virtual network '" + vnetId + "' with subnet '" + subnetName + "' ...", logger, Priority.INFO);
                dss_vnet = (Network)((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithCreateAndSubnet)((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.clientService.getAzureClient(cloudAccount).networks().define(vnetId)).withRegion(Region.fromName((String)settings.azureSettings.regionId))).withExistingResourceGroup(rgName)).withAddressSpace(cidr).defineSubnet(subnetName).withAddressPrefix(cidr).withExistingNetworkSecurityGroup(networkSecurityGroup).attach()).withTags(AzureUtils.getTagsWithName(vnetId, newVN.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())))).create();
                smartLogTail.replaceLastLine("Virtual network '" + vnetId + "' created.", logger, Priority.INFO);
            }
            FutureProgress.updateState((double)2.0);
            try (FutureProgress.AutocloseableFutureProgressState peeringStep = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
                this.createPeering(tenant, cloudAccount, dss_vnet, newVN);
            }
            FutureProgress.updateState((double)3.0);
            newVN.setMode(VirtualNetwork.VirtualNetworkMode.FM_MANAGED);
            newVN.setAzureRgName(rgName);
            newVN.setAzureVnId(dss_vnet.id());
            newVN.setAzureSubnet(subnetName);
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
        finally {
            if (rwt != null) {
                rwt.close();
            }
        }
    }

    @Override
    public VirtualNetwork createUnmanagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        Subnet secondSubnet;
        CloudAccount cloudAccount;
        Object id = input.forcedID != null ? input.forcedID : "vn-" + SecretKeyGenerator.generate((int)12);
        String accountId = input.accountId != null ? input.accountId : tenantId;
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        CloudAccount cloudAccount2 = cloudAccount = input.accountId != null ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        assert (tenant != null);
        Network network = (Network)this.clientService.getAzureClient(cloudAccount).networks().getById(input.azureVnId);
        if (network == null) {
            throw new IllegalArgumentException("VNet not found: " + input.azureVnId);
        }
        Subnet subnet = (Subnet)network.subnets().get(input.azureSubnetId);
        if (subnet == null) {
            throw new IllegalArgumentException("Subnet not found: " + input.azureSubnetId);
        }
        if (StringUtils.isNotEmpty((String)input.azureSecondSubnetId) && (secondSubnet = (Subnet)network.subnets().get(input.azureSecondSubnetId)) == null) {
            throw new IllegalArgumentException("Second subnet not found: " + input.azureSecondSubnetId);
        }
        if (StringUtils.isNotBlank((String)input.azureRgNameForCreatedResources)) {
            try {
                if (!this.clientService.getAzureClient(tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe())).resourceGroups().contain(input.azureRgNameForCreatedResources)) {
                    throw new IllegalArgumentException("Resource group not found: " + input.azureRgNameForCreatedResources);
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Failed to check existence of resource group " + input.azureRgNameForCreatedResources, e);
            }
        }
        if (input.azureAutoUpdateSecurityGroups) {
            try (FutureProgress.AutocloseableFutureProgressState securityGroupStep = FutureProgress.pushAutoCloseableState((String)"Update security groups");){
                NetworkSecurityGroup nsg = subnet.getNetworkSecurityGroup();
                if (nsg == null) {
                    throw new IllegalArgumentException("Subnet " + input.azureSubnetId + " has no security group, can't update security group settings");
                }
                NetworkSecurityGroup.Update nsgUpdate = (NetworkSecurityGroup.Update)nsg.update();
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                switch (input.mode) {
                    case FM_MANAGED: 
                    case EXISTING_MONOTENANT: {
                        ((NetworkSecurityGroup.Update)nsgUpdate.defineRule("FMtoDSSinstances").allowInbound().fromAddress(settings.azureSettings.fmServerCIDR).fromAnyPort().toAnyAddress().toPortRanges(new String[]{"22", "80", "443"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(100).attach()).defineRule("DSSinstancesToFM").allowOutbound().fromAnyAddress().fromAnyPort().toAddress(settings.azureSettings.fmServerCIDR).toAnyPort().withAnyProtocol().withPriority(100).attach();
                        break;
                    }
                    case EXISTING_MULTITENANT_PUBLIC_IP: {
                        if (input.allowIngressSSH) {
                            nsgUpdate.defineRule("FMtoDSSinstances").allowInbound().fromAddress(settings.azureSettings.fmServerCIDR).fromAnyPort().toAnyAddress().toPortRanges(new String[]{"22"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(100).attach();
                        }
                        nsgUpdate.defineRule("DSSinstancesToFM").allowOutbound().fromAnyAddress().fromAnyPort().toAddress(settings.azureSettings.fmServerCIDR).toAnyPort().withAnyProtocol().withPriority(100).attach();
                    }
                }
                switch (input.internetAccessMode) {
                    case NO: {
                        ((NetworkSecurityGroup.Update)nsgUpdate.defineRule("DenyInternetInbound").denyInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toAnyPort().withAnyProtocol().withPriority(101).attach()).defineRule("DenyInternetOutbound").denyOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                        break;
                    }
                    case EGRESS_ONLY: {
                        ((NetworkSecurityGroup.Update)nsgUpdate.defineRule("DenyInternetInbound").denyInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toAnyPort().withAnyProtocol().withPriority(101).attach()).defineRule("AllowInternetOutbound").allowOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                        break;
                    }
                    case YES: {
                        ((NetworkSecurityGroup.Update)nsgUpdate.defineRule("AllowInternetInbound").allowInbound().fromAddress("INTERNET").fromAnyPort().toAnyAddress().toPortRanges(new String[]{"80", "443"}).withProtocol(SecurityRuleProtocol.TCP).withPriority(101).attach()).defineRule("AllowInternetOutbound").allowOutbound().fromAnyAddress().fromAnyPort().toAddress("INTERNET").toAnyPort().withAnyProtocol().withPriority(101).attach();
                    }
                }
                nsgUpdate.apply();
            }
        }
        FutureProgress.updateState((double)1.0);
        VirtualNetwork newVN = new VirtualNetwork();
        newVN.setId((String)id);
        newVN.setMode(input.mode);
        newVN.setLabel(input.label);
        newVN.setDescription(input.description);
        if (StringUtils.isNotEmpty((String)input.accountId)) {
            newVN.setCloudAccount(cloudAccount);
        }
        newVN.setTenant(tenant);
        newVN.setAzureRegion(network.region().name());
        newVN.setAzureAssignPublicIP(true);
        newVN.setAzureVnId(input.azureVnId);
        newVN.setAzureSubnet(input.azureSubnetId);
        newVN.setAzureSecondSubnet(input.azureSecondSubnetId);
        newVN.setAzureRgName(network.resourceGroupName());
        newVN.setAzureRgNameForCreatedResources(input.azureRgNameForCreatedResources);
        newVN.setCloudTags(CloudTagList.toJSON(input.cloudTags));
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String fmVNET = settings.azureSettings.vnetId;
        newVN.setPeeringState(VirtualNetwork.PeeringState.NONE);
        if (!input.azureVnId.equals(fmVNET)) {
            if (input.autoCreatePeerings) {
                try (FutureProgress.AutocloseableFutureProgressState createPeeringStep = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
                    smartLogTail.appendLine("Creating peering ...", logger, Priority.INFO);
                    this.createPeering(tenant, cloudAccount, network, newVN);
                    smartLogTail.replaceLastLine("Peering created", logger, Priority.INFO);
                }
            } else {
                smartLogTail.appendLine("No peering auto creation, peering should be defined externally.");
                if (this.detectPeering(tenant, cloudAccount, network, newVN)) {
                    smartLogTail.appendLine("Existing peering detected");
                } else {
                    smartLogTail.appendLine("No existing peering detected");
                }
            }
        }
        FutureProgress.updateState((double)2.0);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetwork(VirtualNetwork vn, boolean deletePeering) {
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", vn.getTenant().getId());
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        if (vn.getAzurePeeringConnectionId() == null || !deletePeering || vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL) {
            return result;
        }
        CloudAccount cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
        Network network = (Network)this.clientService.getAzureClient(cloudAccount).networks().getById(vn.getAzureVnId());
        if (network == null) {
            logger.warn((Object)("Error during vn deletion, network not found " + vn.getAzureVnId()));
            return result;
        }
        try {
            this.deletePeering(tenant, vn.getCloudAccountOrVirtualCloudAccount(), network);
        }
        catch (Exception e) {
            logger.warn((Object)"Error during peering deletion", (Throwable)e);
            result.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_PEERING_NOT_DELETED, e.getMessage());
        }
        return result;
    }

    private boolean detectPeering(Tenant tenant, CloudAccount networkCloudAccount, Network dssVnet, VirtualNetwork newVN) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Network fmVnet = (Network)this.clientService.getAzureClient(tenant.getVirtualCloudAccount(settings)).networks().getById(settings.azureSettings.vnetId);
        Peering peer = new Peering().withCloudAccount(networkCloudAccount).withSubscription(tenant.getAzureSubscription()).withLocalNetwork(fmVnet).withRemoteNetwork(dssVnet);
        NetworkPeering peering = peer.getPeering();
        if (peering != null) {
            newVN.setAzurePeeringConnectionId(peering.name());
            newVN.setPeeringState(VirtualNetwork.PeeringState.EXTERNAL);
            for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
                if (vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL || !peering.name().equals(vn.getAzurePeeringConnectionId())) continue;
                newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
            }
            return true;
        }
        return false;
    }

    private void createPeering(Tenant tenant, CloudAccount networkCloudAccount, Network dssVnet, VirtualNetwork newVN) throws Exception {
        if (this.detectPeering(tenant, networkCloudAccount, dssVnet, newVN)) {
            return;
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Network fmVnet = (Network)this.clientService.getAzureClient(tenant.getVirtualCloudAccount(settings)).networks().getById(settings.azureSettings.vnetId);
        Peering peeringFromFM = new Peering().withCloudAccount(networkCloudAccount).withSubscription(tenant.getAzureSubscription()).withLocalNetwork(fmVnet).withRemoteNetwork(dssVnet);
        peeringFromFM.createIfNotExists();
        try {
            Peering peeringToFM = new Peering().withCloudAccount(networkCloudAccount).withLocalNetwork(dssVnet).withRemoteNetwork(fmVnet);
            String peering = peeringToFM.createIfNotExists();
            newVN.setAzurePeeringConnectionId(peering);
            newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
        }
        catch (Exception exc) {
            peeringFromFM.delete();
        }
    }

    private void deletePeering(Tenant tenant, CloudAccount networkCloudAccount, Network dssVnet) throws Exception {
        String name = this.getPeeringName(tenant, dssVnet);
        if (this.countPeerings(tenant, name) > 1) {
            logger.info((Object)"Peering is not deleted, as it's still in use.");
            return;
        }
        logger.info((Object)("Deleting peering for " + dssVnet.name()));
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Network fmVnet = (Network)this.clientService.getAzureClient(tenant.getVirtualCloudAccount(settings)).networks().getById(settings.azureSettings.vnetId);
        new Peering().withCloudAccount(tenant.getVirtualCloudAccount(settings)).withLocalNetwork(fmVnet).withRemoteNetwork(dssVnet).delete();
        new Peering().withCloudAccount(networkCloudAccount).withLocalNetwork(dssVnet).withRemoteNetwork(fmVnet).delete();
    }

    private String getPeeringName(Tenant tenant, Network dssVnet) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Network fmVnet = (Network)this.clientService.getAzureClient(tenant.getVirtualCloudAccount(settings)).networks().getById(settings.azureSettings.vnetId);
        return new Peering().withLocalNetwork(fmVnet).withRemoteNetwork(dssVnet).getPeeringName();
    }

    private int countPeerings(Tenant tenant, String peeringName) {
        int count = 0;
        for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
            CloudAccount cloudAccount = vn.getCloudAccountOrVirtualCloudAccount();
            Network network = (Network)this.clientService.getAzureClient(cloudAccount).networks().getById(vn.getAzureVnId());
            if (!this.getPeeringName(tenant, network).equals(peeringName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetworkSecurityGroups(VirtualNetwork vn) {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public boolean needsPeering(String tenantId, VirtualNetwork vn) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String fmVnet = settings.azureSettings.vnetId;
        return !vn.getAzureVnId().equals(fmVnet);
    }

    @Override
    public Optional<String> getPeeringId(String tenantId, VirtualNetwork vn) {
        return StringUtils.isEmpty((String)vn.getAzurePeeringConnectionId()) ? Optional.empty() : Optional.of(vn.getAzurePeeringConnectionId());
    }

    @Override
    public VirtualNetworkMetadata getDefaultCreationValues(String tenantId) {
        VirtualNetworkMetadata virtualNetworkMetadata = new VirtualNetworkMetadata();
        JSONObject instanceMetadata = AzureInstanceMetadataReader.getInstanceMetadata();
        String resourceId = instanceMetadata.getJSONObject("compute").getString("resourceId");
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        CloudAccount cloudAccount = tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        VirtualMachine virtualMachine = (VirtualMachine)this.clientService.getAzureClient(cloudAccount).virtualMachines().getById(resourceId);
        NicIpConfiguration primaryIPConfiguration = virtualMachine.getPrimaryNetworkInterface().primaryIPConfiguration();
        virtualNetworkMetadata.azureVNId = primaryIPConfiguration.networkId();
        virtualNetworkMetadata.azureSubnetName = primaryIPConfiguration.subnetName();
        return virtualNetworkMetadata;
    }

    @Override
    public void validateSettings(VirtualNetwork vn, VirtualNetworkSettingsDTO dto) {
        Network network;
        Subnet secondSubnet;
        if (dto.dnsStrategy == VirtualNetwork.DNSStrategy.VN_SPECIFIC_CLOUD_DNS_SERVICE) {
            this.azureDNSService.checkIfZoneExist(vn, dto.azureDnsZoneId);
        }
        if (StringUtils.isNotEmpty((String)dto.azureSecondSubnet) && (secondSubnet = (Subnet)(network = (Network)this.clientService.getAzureClient(vn.getCloudAccountOrVirtualCloudAccount()).networks().getById(vn.getAzureVnId())).subnets().get(dto.azureSecondSubnet)) == null) {
            throw new IllegalArgumentException("Second subnet not found: " + dto.azureSecondSubnet);
        }
    }

    class Peering {
        CloudAccount account;
        String subscription;
        Network localNetwork;
        Network remoteNetwork;

        Peering() {
        }

        public Peering withSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        public Peering withCloudAccount(CloudAccount account) {
            this.account = account;
            return this;
        }

        public Peering withLocalNetwork(Network localNetwork) {
            this.localNetwork = localNetwork;
            return this;
        }

        public Peering withRemoteNetwork(Network remoteNetwork) {
            this.remoteNetwork = remoteNetwork;
            return this;
        }

        public String getPeeringName() {
            return AzureCloudNetworkService.peeringPrefix + this.localNetwork.name() + "-to-" + this.remoteNetwork.name();
        }

        public String createIfNotExists() throws Exception {
            NetworkPeering existing = this.getPeering();
            if (existing != null) {
                return existing.name();
            }
            String peeringName = this.getPeeringName();
            ((NetworkPeering.DefinitionStages.Blank)((Network)this.getAzureClient().networks().getById(this.localNetwork.id())).peerings().define(peeringName)).withRemoteNetwork(this.remoteNetwork).create();
            return peeringName;
        }

        public void delete() throws Exception {
            NetworkPeering peering = this.getPeering();
            if (peering == null) {
                return;
            }
            ((Network)this.getAzureClient().networks().getById(this.localNetwork.id())).peerings().deleteById(peering.id());
        }

        private NetworkPeering getPeering() {
            return ((Network)this.getAzureClient().networks().getById(this.localNetwork.id())).peerings().getByRemoteNetwork(this.remoteNetwork);
        }

        private AzureResourceManager getAzureClient() {
            if (this.subscription == null) {
                return AzureCloudNetworkService.this.clientService.getAzureClient(this.account);
            }
            return AzureCloudNetworkService.this.clientService.getAzureClient(this.account, this.subscription);
        }
    }
}

