/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.util.Utils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestInitializer;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.Compute;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.Dns;
import com.dataiku.dss.shadelibgcp.com.google.api.services.iam.v1.Iam;
import com.dataiku.dss.shadelibgcp.com.google.auth.http.HttpCredentialsAdapter;
import com.dataiku.dss.shadelibgcp.org.apache.http.HttpHost;
import com.dataiku.dss.shadelibgcp.org.apache.http.auth.AuthScope;
import com.dataiku.dss.shadelibgcp.org.apache.http.auth.Credentials;
import com.dataiku.dss.shadelibgcp.org.apache.http.auth.UsernamePasswordCredentials;
import com.dataiku.dss.shadelibgcp.org.apache.http.client.CredentialsProvider;
import com.dataiku.dss.shadelibgcp.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelibgcp.org.apache.http.impl.client.BasicCredentialsProvider;
import com.dataiku.dss.shadelibgcp.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelibgcp.org.apache.http.impl.client.HttpClients;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.gcp.GoogleCredentialBuilder;
import com.dataiku.fm.cloud.gcp.KMSClient;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public class GCPClientService {
    @Autowired
    private CloudAccountsService accountService;
    @Autowired
    private CloudCryptoService cryptoService;
    public static final String CLOUD_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    public static final String KMS_SCOPE = "https://www.googleapis.com/auth/cloudkms";
    public static final String CLOUDDNS_SCOPE = "https://www.googleapis.com/auth/ndev.clouddns.readwrite";

    public Compute getAPIClient(CloudAccount account) {
        try {
            return new Compute.Builder(GCPClientService.getHttpTransport(), Utils.getDefaultJsonFactory(), (HttpRequestInitializer)new HttpCredentialsAdapter((com.dataiku.dss.shadelibgcp.com.google.auth.Credentials)new GoogleCredentialBuilder().build_v2(this.getDecryptedCredentials(account)).createScoped(new String[]{CLOUD_SCOPE}))).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate api client", e);
        }
    }

    private String getDecryptedCredentials(CloudAccount account) {
        if (account.getGcpAuthenticationMode() == CloudAccount.GCPAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS) {
            return null;
        }
        return account.isEncrypted() ? this.cryptoService.decrypt(account.getTenant(), account.getGcpServiceAccountKeyOrKeyPath()) : account.getGcpServiceAccountKeyOrKeyPath();
    }

    public Dns getCloudDNSClient(CloudAccount account) {
        try {
            return new Dns.Builder(GCPClientService.getHttpTransport(), Utils.getDefaultJsonFactory(), (HttpRequestInitializer)new HttpCredentialsAdapter((com.dataiku.dss.shadelibgcp.com.google.auth.Credentials)new GoogleCredentialBuilder().build_v2(this.getDecryptedCredentials(account)).createScoped(new String[]{CLOUDDNS_SCOPE}))).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate api client", e);
        }
    }

    public Iam getCloudIAMClient(CloudAccount account) {
        try {
            return new Iam.Builder(GCPClientService.getHttpTransport(), Utils.getDefaultJsonFactory(), (HttpRequestInitializer)new HttpCredentialsAdapter((com.dataiku.dss.shadelibgcp.com.google.auth.Credentials)new GoogleCredentialBuilder().build_v2(this.getDecryptedCredentials(account)).createScoped(new String[]{CLOUD_SCOPE}))).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate api client", e);
        }
    }

    public KMSClient getKMSClient(CloudAccount account) {
        try {
            GoogleCredential credential = new GoogleCredentialBuilder().build_v1(this.getDecryptedCredentials(account));
            return new KMSClient(credential.createScoped((Collection)Lists.newArrayList((Object[])new String[]{KMS_SCOPE})), GCPClientService.getProxySettings(), "");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate api client", e);
        }
    }

    private static ProxySettings getProxySettings() {
        return FMApp.isCloudProxyEnabled() ? FMApp.getFMSettingsUnsafe().proxySettings : new ProxySettings();
    }

    private static HttpTransport getHttpTransport() {
        if (FMApp.isCloudProxyEnabled()) {
            ProxySettings proxySettings = FMApp.getFMSettingsUnsafe().proxySettings;
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setProxy(new HttpHost(proxySettings.host, proxySettings.port));
            if (proxySettings.hasAuthentication()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host, proxySettings.port), (Credentials)new UsernamePasswordCredentials(proxySettings.username, proxySettings.password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return new ApacheHttpTransport((HttpClient)httpClientBuilder.build());
        }
        return Utils.getDefaultTransport();
    }
}

