/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.license;

import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.license.LicenseRequestUtils;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenseFetcher {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.license");

    public LicenseFetcher() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void fetchAndSaveForTenant(Tenant tenant) throws IOException {
        block11: {
            String managerURL = DKUApp.getParams().getParam("dku.license.serverURL", "https://my.dataiku.com");
            try (NoAuthAPIClient apiClient = new NoAuthAPIClient(managerURL, false, FMApp.getFMSettingsUnsafe().proxySettings, 60000, 60000);){
                logger.info((Object)("Fetching license for tenant " + tenant.getId()));
                LicenseRequestUtils.LicenseRequest req = LicenseRequestUtils.buildRequest(tenant.getLicenseToken());
                ReturnedLicense newLicense = (ReturnedLicense)apiClient.postObject("/api/comm/managed/instance/license", ReturnedLicense.class, (Object)req);
                logger.info((Object)("Successfully got license for tenant " + tenant.getId()));
                if (newLicense.license == null || newLicense.license.equals(tenant.getLicense())) break block11;
                logger.info((Object)"License has changed, saving the new license");
                try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                    tenant.setLicense(newLicense.license);
                    rwt.getThreadEM().persist((Object)tenant);
                    rwt.commit();
                }
                this.enqueueLicenseRefreshForAllTenantInstances(tenant.getId());
            }
        }
    }

    private void enqueueLicenseRefreshForAllTenantInstances(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        logger.info((Object)("Enqueuing license refresh for all instances of tenant " + tenantId));
        for (LogicalInstance li : this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1", tenant)) {
            logger.infoV("may enqueue license update for tenant=%s instnace=%s", new Object[]{tenant.getId(), li.getId()});
            if (li.getCurrentPhysicalInstance() == null) {
                logger.infoV("Instance is not provisioned, not doing it", new Object[0]);
            }
            InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
            ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
            ac.type = InstanceAgentActionsQueueService.AgentCommandType.UPDATE_LICENSE;
            this.instanceAgentActionsQueueService.enqueueCommand(null, tenantId, li.getId(), ac);
            logger.info((Object)"command enqueued");
        }
    }

    static class ReturnedLicense {
        String license;

        ReturnedLicense() {
        }
    }
}

