/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class InstanceImagesSettings {
    public List<InstanceImage> images = new ArrayList<InstanceImage>();
    public String defaultImageId;

    public InstanceImage get(String id) {
        for (InstanceImage ii : this.images) {
            if (!ii.id.equals(id)) continue;
            return ii;
        }
        throw new IllegalArgumentException("Unknown image id: " + id);
    }

    public static class InstanceImage {
        public String id;
        public String label;
        public List<AWSAMI> awsAMIs = new ArrayList<AWSAMI>();
        public List<AzureMI> azureMIs = new ArrayList<AzureMI>();
        public List<GCPCI> gcpCIs = new ArrayList<GCPCI>();

        public String getAMIIdForRegion(String region) {
            for (AWSAMI ami : this.awsAMIs) {
                if (!region.equals(ami.region)) continue;
                return ami.awsAMIId;
            }
            throw new IllegalArgumentException("No known AMI id for image id: " + this.id + " in region " + region);
        }

        public AzureInstanceImageReference getAzureImageReferenceForRegion(String region) {
            for (AzureMI ami : this.azureMIs) {
                if (!Objects.equals(region, ami.region) || ami.region == null) continue;
                if (StringUtils.isNotBlank((String)ami.imageId)) {
                    return new AzureInstanceImageReference(ami.imageId, AzureImageType.RESOURCE_ID);
                }
                if (!StringUtils.isNotBlank((String)ami.vhdUrl)) continue;
                return new AzureInstanceImageReference(ami.vhdUrl, AzureImageType.VHD, ami.metadata);
            }
            for (AzureMI ami : this.azureMIs) {
                if (StringUtils.isNotBlank((String)ami.imageUrn)) {
                    return new AzureInstanceImageReference(ami.imageUrn, AzureImageType.URN);
                }
                if (!StringUtils.isNotBlank((String)ami.vhdUrl)) continue;
                return new AzureInstanceImageReference(ami.vhdUrl, AzureImageType.VHD, ami.metadata);
            }
            throw new IllegalArgumentException("No known MI id or URN for image id: " + this.id + " in region " + region);
        }

        public String getAzureImageIdForRegion(String region) {
            for (AzureMI ami : this.azureMIs) {
                if (!region.equals(ami.region)) continue;
                return ami.imageId;
            }
            throw new IllegalArgumentException("No known MI id for image id: " + this.id + " in region " + region);
        }

        public String getGCPCIIdForRegion(String region) {
            String regionNN = StringUtils.defaultIfBlank((String)region, (String)"");
            for (GCPCI ami : this.gcpCIs) {
                if (!regionNN.equals(ami.region)) continue;
                return ami.gcpCIId;
            }
            for (GCPCI ami : this.gcpCIs) {
                if (StringUtils.isEmpty((String)ami.region) || !regionNN.startsWith(ami.region)) continue;
                return ami.gcpCIId;
            }
            for (GCPCI ami : this.gcpCIs) {
                if (!StringUtils.isEmpty((String)ami.region)) continue;
                return ami.gcpCIId;
            }
            for (GCPCI ami : this.gcpCIs) {
                if (!"eu".equals(ami.region)) continue;
                return ami.gcpCIId;
            }
            throw new IllegalArgumentException("No known CI id for image id: " + this.id + " in region " + region);
        }
    }

    public static class AzureInstanceImageReference {
        public String reference;
        public AzureImageType type;
        public AzureImageMetadata azureImageMetadata = null;

        public AzureInstanceImageReference(String reference, AzureImageType type) {
            this.reference = reference;
            this.type = type;
            this.azureImageMetadata = null;
        }

        public AzureInstanceImageReference(String reference, AzureImageType type, AzureImageMetadata metadata) {
            this.reference = reference;
            this.type = type;
            this.azureImageMetadata = metadata;
        }
    }

    public static enum AzureImageType {
        URN,
        RESOURCE_ID,
        VHD;

    }

    static class GCPCI {
        public String region;
        public String gcpCIId;

        GCPCI() {
        }
    }

    static class AzureMI {
        public String region;
        public String imageId;
        public String imageUrn;
        public String vhdUrl;
        public AzureImageMetadata metadata;

        AzureMI() {
        }
    }

    public static class AzureImageMetadata {
        public String publisher;
        public String offer;
        public String SKU;
        public String version;
        public String imageNameSuffix;
    }

    public static class AWSAMI {
        public String region;
        public String awsAMIId;
    }
}

