/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.security.model;

public class Permissions {
    protected boolean admin;
    protected boolean write;
    protected boolean read;

    public Permissions() {
    }

    public Permissions(Permissions perm) {
        this.admin = perm.admin;
        this.write = perm.write;
        this.read = perm.read;
    }

    public Permissions deepCopy() {
        return new Permissions(this);
    }

    public Permissions withAdmin(boolean admin) {
        this.admin = admin;
        return this;
    }

    public Permissions withWrite(boolean write) {
        this.write = write;
        return this;
    }

    public Permissions withRead(boolean read) {
        this.read = read;
        return this;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean mayWrite() {
        return this.write || this.admin;
    }

    public boolean mayRead() {
        return this.read || this.write || this.admin;
    }

    public Permissions union(Permissions permissions) {
        Permissions result = new Permissions();
        result.admin = this.admin || permissions.admin;
        result.write = this.mayWrite() || permissions.mayWrite();
        result.read = this.mayRead() || permissions.mayRead();
        return result;
    }
}

