/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.MessagingChannel;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.MessagingChannelDTO;
import com.dataiku.fm.model.published.ProtoMessagingChannel;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.AlertingUtils;
import com.dataiku.fm.server.alerts.MessagingChannelService;
import com.dataiku.fm.server.alerts.senders.NotificationSender;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.utils.APIInputValidator;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessagingChannelCRUDService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.messagingChannelCRUDService");
    private static final String MSG_MESSAGING_CHANNEL_ID_MISSING = "The messaging channel ID is missing.";
    private static final String MSG_MESSAGING_CHANNEL_TYPE_NOT_EXISTING = "The specified messaging channel type does not exist.";
    private static final String MSG_CONFIGURATION_NULL = "The messaging channel configuration is empty.";
    private static final String MSG_CONFIGURATION_INVALID = "The JSON structure of the configuration supplied for a check definition does not match this check type.";
    private static final String MSG_MESSAGING_CHANNELS_EMPTY = "The supplied messaging channels configuration is empty";
    @Autowired
    private AlertingDBService dbService;
    @Autowired
    private MessagingChannelService messagingChannelService;

    private MessagingChannel create(Tenant tenant, ProtoMessagingChannel protoMessagingChannel, DatabaseAccessService.ReadWriteTransaction rwt) {
        MessagingChannel messagingChannel = this.buildEntity(tenant, protoMessagingChannel);
        String newId = "mc-" + SecretKeyGenerator.generate((int)12);
        messagingChannel.setId(newId);
        rwt.getThreadEM().persist((Object)messagingChannel);
        return messagingChannel;
    }

    private void validateInput(ProtoMessagingChannel protoMessagingChannel) {
        APIInputValidator.checkNotNull(protoMessagingChannel, MSG_MESSAGING_CHANNEL_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotNull((Object)protoMessagingChannel.type, MSG_MESSAGING_CHANNEL_TYPE_NOT_EXISTING, new Object[0]);
        APIInputValidator.checkNotEmpty(protoMessagingChannel.configuration, MSG_CONFIGURATION_NULL, new Object[0]);
    }

    private MessagingChannel buildEntity(Tenant tenant, ProtoMessagingChannel protoMessagingChannel) {
        MessagingChannel messagingChannel = new MessagingChannel();
        messagingChannel.setId(protoMessagingChannel.id);
        messagingChannel.setTenant(tenant);
        messagingChannel.setType(protoMessagingChannel.type);
        messagingChannel.setConfigurationVersion(AlertingUtils.getMessagingChannelConfigurationDefaultVersion(protoMessagingChannel.type));
        this.setSanitizedEncryptedConfiguration(protoMessagingChannel, messagingChannel, tenant);
        return messagingChannel;
    }

    private void setSanitizedEncryptedConfiguration(ProtoMessagingChannel protoMessagingChannel, MessagingChannel messagingChannel, Tenant tenant) {
        try {
            NotificationSender notificationSender = this.messagingChannelService.getNotificationSender(messagingChannel.getType(), messagingChannel.getConfigurationVersion());
            String sanitizedMessagingChannelConfiguration = notificationSender.sanitizeConfiguration(protoMessagingChannel.configuration);
            messagingChannel.setConfiguration(notificationSender.encryptConfiguration(tenant, sanitizedMessagingChannelConfiguration));
        }
        catch (JsonSyntaxException e) {
            logger.errorV((Throwable)e, MSG_CONFIGURATION_INVALID, new Object[0]);
            APIInputValidator.throwInvalidArgumentException(MSG_CONFIGURATION_INVALID, new Object[0]);
        }
    }

    private MessagingChannelDTO convertToDTO(MessagingChannel messagingChannel) {
        if (messagingChannel == null) {
            return null;
        }
        MessagingChannelDTO messagingChannelDTO = new MessagingChannelDTO();
        messagingChannelDTO.id = messagingChannel.getId();
        messagingChannelDTO.type = messagingChannel.getType();
        messagingChannelDTO.configuration = this.messagingChannelService.getNotificationSender(messagingChannel.getType(), messagingChannel.getConfigurationVersion()).decryptConfiguration(messagingChannel.getTenant(), messagingChannel.getConfiguration());
        messagingChannelDTO.configurationVersion = messagingChannel.getConfigurationVersion();
        return messagingChannelDTO;
    }

    public MessagingChannelDTO get(String tenantId, String messagingChannelId) {
        APIInputValidator.checkNotBlank(messagingChannelId, MSG_MESSAGING_CHANNEL_ID_MISSING, new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        MessagingChannel messagingChannel = this.dbService.getSingleMessagingChannel(tenantId, messagingChannelId);
        return this.convertToDTO(messagingChannel);
    }

    public void delete(String tenantId, String messagingChannelId) {
        APIInputValidator.checkNotBlank(messagingChannelId, MSG_MESSAGING_CHANNEL_ID_MISSING, new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        MessagingChannel messagingChannel = this.dbService.getSingleMessagingChannel(tenantId, messagingChannelId);
        if (messagingChannel == null) {
            return;
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.delete(messagingChannel, rwt);
            rwt.commit();
        }
    }

    private void delete(MessagingChannel messagingChannel, DatabaseAccessService.ReadWriteTransaction rwt) {
        Set<CheckReporter> reporters = messagingChannel.getCheckReporters();
        if (reporters != null) {
            for (CheckReporter reporter : reporters) {
                reporter.setMessagingChannel(null);
                rwt.getThreadEM().merge((Object)reporter);
            }
        }
        rwt.getThreadEM().remove((Object)messagingChannel);
    }

    public MessagingChannelDTO upsert(String tenantId, ProtoMessagingChannel protoMessagingChannel) {
        this.validateInput(protoMessagingChannel);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            MessagingChannel messagingChannel = this.upsert(tenant, protoMessagingChannel, rwt);
            rwt.commit();
            MessagingChannelDTO messagingChannelDTO = this.convertToDTO(messagingChannel);
            return messagingChannelDTO;
        }
    }

    private MessagingChannel upsert(Tenant tenant, ProtoMessagingChannel protoMessagingChannel, DatabaseAccessService.ReadWriteTransaction rwt) {
        MessagingChannel messagingChannel = this.dbService.getSingleMessagingChannel(tenant.getId(), protoMessagingChannel.id);
        if (messagingChannel == null) {
            return this.create(tenant, protoMessagingChannel, rwt);
        }
        this.setSanitizedEncryptedConfiguration(protoMessagingChannel, messagingChannel, tenant);
        rwt.getThreadEM().merge((Object)messagingChannel);
        return messagingChannel;
    }

    public List<MessagingChannelDTO> bulkUpsert(String tenantId, List<ProtoMessagingChannel> protoMessagingChannels, DatabaseAccessService.ReadWriteTransaction rwt) {
        APIInputValidator.checkNotBlank(tenantId, "The tenant ID is missing.", new Object[0]);
        APIInputValidator.checkNotNull(protoMessagingChannels, MSG_MESSAGING_CHANNELS_EMPTY, new Object[0]);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        ArrayList<MessagingChannel> messagingChannels = new ArrayList<MessagingChannel>();
        List<MessagingChannel> existingMessagingChannels = this.dbService.getAllMessagingChannels(tenantId);
        Set protoMessagingChannelIDs = protoMessagingChannels.stream().map(protoMessagingChannel -> protoMessagingChannel.id).collect(Collectors.toSet());
        for (MessagingChannel existingMessagingChannel : existingMessagingChannels) {
            if (protoMessagingChannelIDs.contains(existingMessagingChannel.getId())) continue;
            this.delete(existingMessagingChannel, rwt);
        }
        for (ProtoMessagingChannel protoMessagingChannel2 : protoMessagingChannels) {
            MessagingChannel messagingChannel = this.upsert(tenant, protoMessagingChannel2, rwt);
            messagingChannels.add(messagingChannel);
        }
        return this.convertToDTO(messagingChannels);
    }

    private List<MessagingChannelDTO> convertToDTO(List<MessagingChannel> messagingChannels) {
        ArrayList<MessagingChannelDTO> messagingChannelsDTO = new ArrayList<MessagingChannelDTO>();
        if (messagingChannels == null || messagingChannels.isEmpty()) {
            return messagingChannelsDTO;
        }
        for (MessagingChannel messagingChannel : messagingChannels) {
            messagingChannelsDTO.add(this.convertToDTO(messagingChannel));
        }
        return messagingChannelsDTO;
    }

    public List<MessagingChannelDTO> list(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, "The tenant ID is missing.", new Object[0]);
        List<MessagingChannel> messagingChannels = this.dbService.getAllMessagingChannels(tenantId);
        return messagingChannels.stream().map(this::convertToDTO).collect(Collectors.toList());
    }
}

