/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.futures.FMFutureThread;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceAgentActionsQueueService {
    private static final long WAIT_FOR_COMMAND_TIMEOUT = 60000L;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private InstancesEventLogService eventLogService;
    private final Map<String, List<AgentCommand>> queuePerInstance = new HashMap<String, List<AgentCommand>>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.commands");

    private String getKey(String tenantId, String instanceId) {
        return instanceId;
    }

    public synchronized AgentCommand waitForCommand(String tenantId, String instanceId) throws InterruptedException {
        String key = this.getKey(tenantId, instanceId);
        long startDate = System.currentTimeMillis();
        logger.infoV("Waiting for command tenant=%s instance=%s startDate=%d", new Object[]{tenantId, instanceId, startDate});
        while (true) {
            List<AgentCommand> pending;
            if ((pending = this.queuePerInstance.get(key)) != null) {
                for (AgentCommand ac : pending) {
                    if (ac.state != CommandState.QUEUED) continue;
                    ac.state = CommandState.SENT;
                    logger.infoV("Sending to agent command tenant=%s instance=%s command=%s", new Object[]{tenantId, instanceId, JSON.log((Object)ac)});
                    return ac;
                }
            } else {
                logger.debugV("Agent requested command for tenant=%s instance=%s, but there was no queue for this instance.", new Object[]{tenantId, instanceId});
            }
            if (System.currentTimeMillis() >= startDate + 60000L) {
                logger.info((Object)"Timeout waiting for command. Sending NO_OP to agent.");
                return AgentCommand.NO_OP;
            }
            this.wait(60000L);
        }
    }

    public synchronized void acknowledgeCommandCompletion(String tenantId, String instanceId, String commandId, AgentAPIController.CommandResult commandResult) {
        if (AgentCommand.NO_OP_ID.equals(commandId)) {
            return;
        }
        String key = this.getKey(tenantId, instanceId);
        logger.infoV("Acknowledging command completion tenant=%s instance=%s commandId=%s result=%s", new Object[]{tenantId, instanceId, commandId, JSON.log((Object)commandResult)});
        List<AgentCommand> pending = this.queuePerInstance.get(key);
        if (pending != null) {
            for (AgentCommand ac : pending) {
                if (!ac.commandId.equals(commandId)) continue;
                ac.response.hasResult = true;
                ac.response.result = commandResult.result;
                ac.state = commandResult.outcome;
                if (commandResult.outcome == CommandState.FAILED) {
                    this.eventLogService.addEventASync_NT(tenantId, instanceId, null, "li-command-failed", JF.obj().with("commandType", ac.type.toString()).with("errorMessage", commandResult.error.detailedMessage));
                    ac.error = commandResult.error;
                    continue;
                }
                this.eventLogService.addEventASync_NT(tenantId, instanceId, null, "li-command-completed", JF.obj().with("commandType", ac.type.toString()).with("responseResult", (JsonElement)commandResult.result));
            }
        } else {
            logger.warnV("Agent sent command completion for tenant=%s instance=%s, but there was no queue for this instance.", new Object[]{tenantId, instanceId});
        }
    }

    public synchronized <T> FutureResponse<T> getState(String tenantId, String instanceId, String commandId) throws APIError.SerializedErrorException {
        String key = this.getKey(tenantId, instanceId);
        List<AgentCommand> pending = this.queuePerInstance.get(key);
        assert (pending != null);
        for (AgentCommand ac : pending) {
            if (!ac.commandId.equals(commandId)) continue;
            logger.infoV("Returning state of command tenant=%s instance=%s commandId=%s -> %s", new Object[]{tenantId, instanceId, commandId, JSON.log((Object)ac)});
            if (ac.error != null) {
                throw new APIError.SerializedErrorException(ac.error);
            }
            return ac.response;
        }
        throw new IllegalStateException("Command not found");
    }

    public synchronized <JsonObjet> void updateState(String tenantId, String instanceId, String commandId, FutureResponse<JsonObject> state) {
        String key = this.getKey(tenantId, instanceId);
        List<AgentCommand> pending = this.queuePerInstance.get(key);
        assert (pending != null);
        logger.infoV("Agent updating state of command tenant=%s instance=%s commandId=%s -> %s", new Object[]{tenantId, instanceId, commandId, JSON.log(state)});
        for (AgentCommand ac : pending) {
            if (!ac.commandId.equals(commandId)) continue;
            ac.response = state;
            return;
        }
        throw new IllegalStateException("Command not found");
    }

    public synchronized void remove(String tenantId, String instanceId, String commandId) {
        logger.infoV("Removing command tenant=%s instance=%s commandId=%s", new Object[]{tenantId, instanceId, commandId});
        String key = this.getKey(tenantId, instanceId);
        List<AgentCommand> pending = this.queuePerInstance.get(key);
        ListIterator<AgentCommand> it = pending.listIterator();
        while (it.hasNext()) {
            AgentCommand ac = it.next();
            if (!ac.commandId.equals(commandId)) continue;
            it.remove();
        }
    }

    public synchronized void enqueueCommand(AuthCtx authCtx, String tenantId, String instanceId, AgentCommand command) {
        command.state = CommandState.QUEUED;
        command.response = new FutureResponse();
        command.response.hasResult = false;
        logger.infoV("Enqueue command tenant=%s instance=%s command=%s", new Object[]{tenantId, instanceId, JSON.log((Object)command)});
        String key = this.getKey(tenantId, instanceId);
        List<AgentCommand> pending = this.queuePerInstance.get(key);
        if (pending == null) {
            pending = new ArrayList<AgentCommand>();
            this.queuePerInstance.put(key, pending);
        }
        this.eventLogService.addEventASync_NT(tenantId, instanceId, null, "li-command-enqueue", JF.obj().with("commandType", command.type.toString()));
        pending.add(command);
        this.notifyAll();
    }

    public FutureResponse<JsonObject> enqueueAndStartWait(FMAuthCtx authCtx, String instanceId, AgentCommand command, OnCommandResultSuccess onSuccess) throws Exception {
        this.enqueueCommand(authCtx, authCtx.getTenantId(), instanceId, command);
        AgentWaitFutureThread awt = new AgentWaitFutureThread(authCtx, instanceId, command.commandId, onSuccess, -1L);
        return this.futureService.runFuture(awt, 0L, (TypeToken)new TypeToken<FutureResponse<JsonObject>>(){});
    }

    public FutureResponse<JsonObject> enqueueAndStartWaitWithTimeout(FMAuthCtx authCtx, String instanceId, AgentCommand command, OnCommandResultSuccess onSuccess, long maxWaitTimeMS) throws Exception {
        this.enqueueCommand(authCtx, authCtx.getTenantId(), instanceId, command);
        AgentWaitFutureThread awt = new AgentWaitFutureThread(authCtx, instanceId, command.commandId, onSuccess, maxWaitTimeMS);
        return this.futureService.runFuture(awt, 0L, (TypeToken)new TypeToken<FutureResponse<JsonObject>>(){});
    }

    public FutureResponse<JsonObject> enqueueAndStartWait(FMAuthCtx authCtx, String instanceId, AgentCommand command) throws Exception {
        return this.enqueueAndStartWait(authCtx, instanceId, command, null);
    }

    public FutureResponse<JsonObject> enqueueAndStartWaitWithTimeout(FMAuthCtx authCtx, String instanceId, AgentCommand command, long maxWaitTimeMS) throws Exception {
        return this.enqueueAndStartWaitWithTimeout(authCtx, instanceId, command, null, maxWaitTimeMS);
    }

    public static class AgentCommand {
        public static String NO_OP_ID = "NO_OP";
        public static AgentCommand NO_OP = AgentCommand.create(NO_OP_ID, AgentCommandType.NO_OP);
        public String commandId;
        public AgentCommandType type;
        public JsonObject payload;
        public transient CommandState state;
        public transient FutureResponse<JsonObject> response;
        public transient SerializedError error;

        public static AgentCommand create(String commandId, AgentCommandType type) {
            AgentCommand result = new AgentCommand();
            result.type = type;
            result.commandId = commandId;
            return result;
        }
    }

    public static enum CommandState {
        QUEUED,
        SENT,
        DONE,
        FAILED;

    }

    public static enum AgentCommandType {
        NO_OP,
        PING,
        RESTART_DSS,
        RESET_USER_PASSWORD,
        UPDATE_INSTANCE_SETTINGS,
        REPLAY_SETUP_ACTIONS,
        GROW_FILESYSTEM,
        SEND_LOGS,
        UPDATE_NODES_DIRECTORY,
        UPDATE_LICENSE,
        GET_USER_INFO,
        ENABLE_OR_DISABLE_USER;

    }

    public class AgentWaitFutureThread
    extends FMFutureThread<JsonObject> {
        private final InfoMessage.InfoMessages infoMessages;
        private FutureResponse<JsonObject> currentReponse;
        private String instanceId;
        private String commandId;
        private OnCommandResultSuccess onSuccess;
        private final long maxWaitTimeMS;
        private long delayForLostAgent;

        AgentWaitFutureThread(FMAuthCtx authCtx, String instanceId, String commandId, OnCommandResultSuccess onSuccess, long maxWaitTimeMS) throws IOException {
            super(authCtx, "x");
            this.delayForLostAgent = TimeUnit.SECONDS.toMillis(20L);
            this.instanceId = instanceId;
            this.commandId = commandId;
            this.onSuccess = onSuccess;
            this.maxWaitTimeMS = maxWaitTimeMS;
            this.infoMessages = new InfoMessage.InfoMessages();
        }

        public FuturePayload getPayload() {
            return null;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public JsonObject getResult() {
            if (this.currentReponse == null) {
                return null;
            }
            JsonObject response = (JsonObject)this.currentReponse.result;
            if (response == null) {
                response = new JsonObject();
            }
            response.add("infoMessages", JSON.toJsonElement((Object)this.infoMessages));
            return response;
        }

        public FutureProgressStateSnapshot getProgressSnapshot() {
            return this.currentReponse != null ? this.currentReponse.progress : super.getProgressSnapshot();
        }

        public void abort() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            try (DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx((String[])new String[]{"dku.futures.agentExecute.overall"});){
                FutureProgress currentProgress = FutureProgress.getLocalDangerous();
                try {
                    long start = System.currentTimeMillis();
                    long delay = 50L;
                    Duration duration = Duration.ZERO;
                    while (true) {
                        Thread.sleep(delay);
                        duration = duration.plusMillis(delay);
                        delay = this.calculateNewDelay(delay, duration);
                        this.currentReponse = InstanceAgentActionsQueueService.this.getState(this.tenantId, this.instanceId, this.commandId);
                        if (this.currentReponse.hasResult) {
                            logger.info((Object)"Command has result, interrupting wait loop");
                            if (this.onSuccess != null) {
                                this.onSuccess.onSuccess((JsonObject)this.currentReponse.result, this.infoMessages);
                            }
                            break;
                        }
                        if (currentProgress != null && this.currentReponse.progress != null) {
                            FutureProgress futureProgress = currentProgress;
                            synchronized (futureProgress) {
                                currentProgress.stateStack = this.currentReponse.progress;
                            }
                        }
                        if (this.maxWaitTimeMS > 0L && System.currentTimeMillis() - start > this.maxWaitTimeMS) {
                            logger.warn((Object)"Timeout waiting for agent response, bailing out ...");
                            this.currentReponse.aborted = true;
                            throw new IOException("Timeout waiting for agent to respond");
                        }
                        PhysicalInstance instance = InstancesHelper.getPhysicalInstance(InstanceAgentActionsQueueService.this.dbService, this.tenantId, this.instanceId);
                        PhysicalInstance.LifecycleStage stage = InstancesHelper.computeLifeCycleStage(instance);
                        InstancesHelper.assertInstanceRunning(stage);
                        InstanceAgentActionsQueueService.this.dbService.close();
                    }
                }
                finally {
                    InstanceAgentActionsQueueService.this.remove(this.tenantId, this.instanceId, this.commandId);
                    if (currentProgress != null) {
                        currentProgress.stateStack.clear();
                    }
                }
            }
        }

        private long calculateNewDelay(long delay, Duration duration) {
            if (duration.toMinutes() >= 20L) {
                return this.delayForLostAgent;
            }
            return Math.min(delay + 50L, 500L);
        }
    }

    public static interface OnCommandResultSuccess {
        public void onSuccess(JsonObject var1, InfoMessage.InfoMessages var2);
    }
}

