/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.model.published.SaveInstanceResult;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.CloudStaticData;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances");
    private final InstancesCRUDService instancesCRUDService;
    private final LoadBalancersCRUDService loadBalancersCRUDService;
    private final DatabaseAccessService dbService;
    private final CloudInstanceService cloudInstanceService;
    private final CloudCryptoService cryptoService;
    private final DNSservice dnsService;
    private final InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    private final NodesDirectoryUpdateService nodesDirectoryUpdateService;
    private final Map<String, String> volatileAdminPasswords = new HashMap<String, String>();

    @Autowired
    public InstanceService(InstancesCRUDService instancesCRUDService, LoadBalancersCRUDService loadBalancersCRUDService, DatabaseAccessService dbService, CloudInstanceService cloudInstanceService, CloudCryptoService cryptoService, DNSservice dnsService, InstanceAgentActionsQueueService instanceAgentActionsQueueService, NodesDirectoryUpdateService nodesDirectoryUpdateService) {
        this.instancesCRUDService = instancesCRUDService;
        this.loadBalancersCRUDService = loadBalancersCRUDService;
        this.dbService = dbService;
        this.cloudInstanceService = cloudInstanceService;
        this.cryptoService = cryptoService;
        this.dnsService = dnsService;
        this.instanceAgentActionsQueueService = instanceAgentActionsQueueService;
        this.nodesDirectoryUpdateService = nodesDirectoryUpdateService;
    }

    public List<PublicLogicalInstance> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        Map<String, String> dssImagesLabelById = InstanceService.buildDssImagesLabelById(FMApp.getFMSettingsUnsafe());
        return this.instancesCRUDService.listInternal(tenantId).stream().map(logicalInstance -> this.convertToDTO(tenantId, (LogicalInstance)logicalInstance, dssImagesLabelById)).toList();
    }

    public PublicLogicalInstance create(String tenantId, PublicProtoLogicalInstance protoInstance) throws CodedException {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, protoInstance.virtualNetworkId, protoInstance.label);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)protoInstance.virtualNetworkId);
            if (vn == null) {
                throw new IllegalArgumentException("Invalid network id");
            }
            tenant = vn.getTenant();
            InstanceSettingsTemplate ist = (InstanceSettingsTemplate)this.dbService.getThreadEM().find(InstanceSettingsTemplate.class, (Object)protoInstance.instanceSettingsTemplateId);
            if (ist == null) {
                throw new IllegalArgumentException("Invalid instance settings template id");
            }
            this.cloudInstanceService.checkInstanceCreation(vn, ist);
            LogicalInstance li = new LogicalInstance();
            li.setId("li-" + SecretKeyGenerator.generate((int)12));
            li.setTenant(tenant);
            li.setVirtualNetwork(vn);
            li.setInstanceSettingsTemplate(ist);
            if (this.cryptoService.isAbleToEncrypt(li.getTenant())) {
                li.setPossiblyEncryptedAgentSecret(this.cryptoService.encrypt(li.getTenant(), SecretKeyGenerator.generate((int)16)));
            } else {
                li.setPossiblyEncryptedAgentSecret(SecretKeyGenerator.generate((int)16));
            }
            li.setLabel(protoInstance.label);
            li.setDescription(protoInstance.description);
            li.setDssNodeType(protoInstance.dssNodeType);
            li.setExternalURL(protoInstance.externalURL);
            li.setImageId(protoInstance.imageId);
            li.setSingleNodeAsInfrastructure(protoInstance.singleNodeAsInfrastructure);
            CreationDataUtils.InstanceCreationData icd = CreationDataUtils.getInstanceCreationData(tenantId);
            li.setAzureInstanceName(protoInstance.azureInstanceName);
            li.setAzureAvailabilityZone(protoInstance.azureAvailabilityZone);
            li.setAzurePublicIPId(protoInstance.azurePublicIPId);
            li.setAzureDataVolumeName(protoInstance.azureDataVolumeName);
            li.setAzureOSVolumeName(protoInstance.azureOSVolumeName);
            li.setAzureNicName(protoInstance.azureNicName);
            li.setAzurePublicIPName(protoInstance.azurePublicIPName);
            li.setGcpInstanceName(protoInstance.gcpInstanceName);
            li.setGcpDataVolumeName(protoInstance.gcpDataVolumeName);
            if (protoInstance.additionalDomainNamesForCertificate != null && !protoInstance.additionalDomainNamesForCertificate.isEmpty()) {
                li.setAdditionalDomainNamesForCertificate(this.arrayToStringCleaned(protoInstance.additionalDomainNamesForCertificate));
            }
            li.setCloudInstanceType(protoInstance.cloudInstanceType == null ? icd.defaultCloudInstanceType : protoInstance.cloudInstanceType);
            li.setDataVolumeType(protoInstance.dataVolumeType == null ? icd.defaultDataVolumeType : protoInstance.dataVolumeType);
            li.setDataVolumeSizeGB(protoInstance.dataVolumeSizeGB == null ? icd.defaultDataVolumeSizeGB : protoInstance.dataVolumeSizeGB);
            li.setDataVolumeSizeMaxGB(protoInstance.dataVolumeSizeMaxGB == null ? icd.defaultDataVolumeSizeMaxGB : protoInstance.dataVolumeSizeMaxGB);
            li.setDataVolumeIOPS(protoInstance.dataVolumeIOPS == null ? icd.defaultDataVolumeIOPS : protoInstance.dataVolumeIOPS);
            this.setVolumeEncryption(protoInstance, settings, li);
            li.setCloudTags(CloudTagList.toJSON(protoInstance.cloudTags));
            li.setFMTags(JSON.json(protoInstance.fmTags));
            li.setRootVolumeSizeGB(protoInstance.rootVolumeSizeGB == null ? icd.defaultRootVolumeSizeGB : protoInstance.rootVolumeSizeGB);
            li.setAwsRootVolumeType(protoInstance.awsRootVolumeType);
            li.setAwsRootVolumeIOPS(protoInstance.awsRootVolumeIOPS);
            li.setEnableAutomatedSnapshot(Optional.ofNullable(protoInstance.enableAutomatedSnapshot).orElse(icd.defaultEnableAutomatedSnapshot));
            li.setAutomatedSnapshotPeriod(Optional.ofNullable(protoInstance.automatedSnapshotPeriod).orElse(icd.defaultAutomatedSnapshotPeriod));
            li.setAutomatedSnapshotRetention(Optional.ofNullable(protoInstance.automatedSnapshotRetention).orElse(icd.defaultAutomatedSnapshotRetention));
            logger.infoV("Logical instance created: %s", new Object[]{li.getId()});
            boolean awsInstanceCreateFromExternalSnapshotEnabled = DKUApp.getParams().getBoolParam("dku.fm.feature.awsinstancecreatefromexternalsnapshot.enabled", false) || FeatureFlags.isEnabled((String)"fm.aws.instancecreatefromexternalsnapshot");
            boolean azureInstanceCreateFromExternalSnapshotEnabled = FeatureFlags.isEnabled((String)"fm.azure.instancecreatefromexternalsnapshot");
            if (awsInstanceCreateFromExternalSnapshotEnabled && StringUtils.isNotBlank((String)protoInstance.awsSnapshotId)) {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolumeFromExternalSnapshot(rwt, li, protoInstance.awsSnapshotId);
                logger.infoV("Physical data volume created: %s, based on snapshot: %s", new Object[]{pdv.getId(), protoInstance.awsSnapshotId});
            } else if (azureInstanceCreateFromExternalSnapshotEnabled && StringUtils.isNotBlank((String)protoInstance.azureSnapshotId)) {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolumeFromExternalSnapshot(rwt, li, protoInstance.azureSnapshotId);
                logger.infoV("Physical data volume created: %s, based on snapshot: %s", new Object[]{pdv.getId(), protoInstance.azureSnapshotId});
            } else {
                pdv = this.cloudInstanceService.createInitialPhysicalDataVolume(rwt, li);
                logger.infoV("Physical data volume created: %s", new Object[]{pdv.getId()});
            }
            this.dbService.getThreadEM().persist((Object)li);
            rwt.commit();
            PublicLogicalInstance publicLogicalInstance = this.convertToDTO(tenantId, li, InstanceService.buildDssImagesLabelById(settings));
            return publicLogicalInstance;
        }
    }

    public PublicLogicalInstance get(String tenantId, String instanceId) {
        LogicalInstance li = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
        Map<String, String> dssImagesLabelById = InstanceService.buildDssImagesLabelById(FMApp.getFMSettingsUnsafe());
        return this.convertToDTO(tenantId, li, dssImagesLabelById);
    }

    public SaveInstanceResult update(String tenantId, PublicLogicalInstance pli) throws CodedException {
        String encryptedSslCertificateKeyPEM;
        LogicalInstance li = this.instancesCRUDService.getLogicalInstanceMand(tenantId, pli.id);
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, pli.virtualNetworkId, pli.label, pli.id);
        InstanceSettingsTemplate ist = this.dbService.getSingleResult(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.id = ?1", pli.instanceSettingsTemplateId);
        if (ist == null) {
            throw new Error("unknown InstanceSettingsTemplate");
        }
        SaveInstanceResult ret = new SaveInstanceResult();
        ret.needsReprovision = this.requireReprovision(li, pli);
        ret.success = true;
        li.setLabel(pli.label);
        li.setDescription(pli.description);
        li.setImageId(pli.imageId);
        li.setDssNodeType(pli.dssNodeType);
        li.setExternalURL(pli.externalURL);
        li.setCloudInstanceType(pli.cloudInstanceType);
        li.setDataVolumeSizeGB(pli.dataVolumeSizeGB);
        li.setDataVolumeSizeMaxGB(pli.dataVolumeSizeMaxGB);
        li.setDataVolumeType(pli.dataVolumeType);
        li.setDataVolumeIOPS(pli.dataVolumeIOPS);
        li.setEncryptDataVolume(pli.encryptDataVolume);
        li.setDataVolumeEncryptionKey(pli.dataVolumeEncryptionKey);
        li.setEncryptRootVolume(pli.encryptRootVolume);
        li.setSingleNodeAsInfrastructure(pli.singleNodeAsInfrastructure);
        li.setInstanceSettingsTemplate(ist);
        li.setFMTags(JSON.json(pli.fmTags));
        li.setCloudTags(CloudTagList.toJSON(pli.cloudTags));
        li.setLicenseSelectionMode(pli.licenseSelectionMode);
        if (pli.sublicenseId != null) {
            Sublicense sl = this.dbService.getSingleResult(Sublicense.class, "SELECT sl from sublicense sl where sl.id = ?1 and sl.tenant = ?2", pli.sublicenseId, li.getTenant());
            if (sl == null) {
                throw new Error("unknown Sublicense");
            }
            li.setSublicense(sl);
        }
        li.setEnableAutomatedSnapshot(pli.enableAutomatedSnapshot);
        li.setAutomatedSnapshotPeriod(pli.automatedSnapshotPeriod);
        li.setAutomatedSnapshotRetention(pli.automatedSnapshotRetention);
        li.setAwsAssignElasticIP(pli.awsAssignElasticIP);
        li.setAwsElasticIPAllocationId(pli.awsElasticIPAllocationId);
        li.setAwsPrivateIP(pli.awsPrivateIP);
        li.setRootVolumeSizeGB(pli.rootVolumeSizeGB);
        li.setAwsRootVolumeType(pli.awsRootVolumeType);
        li.setAwsRootVolumeIOPS(pli.awsRootVolumeIOPS);
        li.setAzureAssignPublicIP(pli.azureAssignElasticIP);
        li.setAzurePublicIPId(pli.azurePublicIPId);
        li.setAzurePrivateIP(pli.azurePrivateIP);
        li.setAzureInstanceName(pli.azureInstanceName);
        li.setAzurePublicIPName(pli.azurePublicIPName);
        li.setAzureDataVolumeName(pli.azureDataVolumeName);
        li.setAzureOSVolumeName(pli.azureOSVolumeName);
        li.setAzureNicName(pli.azureNicName);
        li.setAzureRGForSnapshots(StringUtils.stripToNull((String)pli.azureRGForSnapshots));
        li.setGcpAssignPublicIP(pli.gcpAssignPublicIP);
        li.setGcpPublicIPId(pli.gcpPublicIPId);
        li.setGcpZone(pli.gcpZone);
        li.setGcpPrivateIP(pli.gcpPrivateIP);
        li.setGcpInstanceName(pli.gcpInstanceName);
        li.setGcpDataVolumeName(pli.gcpDataVolumeName);
        li.setAdditionalDomainNamesForCertificate(this.arrayToStringCleaned(pli.additionalDomainNamesForCertificate));
        li.setSslCertificatePEM(pli.sslCertificatePEM);
        li.setSslCertificateAwsSecretName(pli.sslCertificateAwsSecretName);
        li.setSslCertificateGcpSecretId(pli.sslCertificateGcpSecretId);
        li.setSslCertificateKeyStorageMode(pli.sslCertificateKeyStorageMode);
        li.setAzureSSLCertificateSecretName(pli.azureSSLCertificateSecretName);
        li.setAzureSSLCertificateSecretVersion(pli.azureSSLCertificateSecretVersion);
        li.setAzureKeyvaultUrl(pli.azureKeyvaultUrl);
        li.setAzureSSLCertificateName(pli.azureSSLCertificateName);
        li.setAzureSSLCertificateVersion(pli.azureSSLCertificateVersion);
        li.setAzureSSLCertificateContentType(pli.azureSSLCertificateContentType);
        if (StringUtils.isNotBlank((String)pli.sslCertificateKeyPEM) && pli.sslCertificateKeyPEM.replaceAll("\\*", "").length() > 0 && (encryptedSslCertificateKeyPEM = this.encryptSslCertificateKeyPEM(pli.sslCertificateKeyPEM, pli.sslCertificateKeyStorageMode, li.getTenant())) != null) {
            li.setSslCertificateKeyPEM(encryptedSslCertificateKeyPEM);
        }
        this.dbService.getThreadEM().persist((Object)li);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInitialAdminPassword(String tenantId, String instanceId) {
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            String key = tenantId + "__" + instanceId;
            this.volatileAdminPasswords.remove(key);
        }
    }

    public InitialPassword getInitialAdminPassword(String tenantId, String instanceId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        LogicalInstance li = this.dbService.getSingleResult(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1 AND li.id=?2", tenant, instanceId);
        if (li == null) {
            throw new RuntimeException("Instance not found");
        }
        String key = tenantId + "__" + li.getId();
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            if (this.volatileAdminPasswords.containsKey(key)) {
                InitialPassword ret = new InitialPassword();
                ret.password = this.volatileAdminPasswords.get(key);
                this.volatileAdminPasswords.remove(key);
                return ret;
            }
            throw new IllegalStateException("Initial password is no longer available. It has already been retrieved or FM server has been recently restarted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstanceSecrets(String tenantId, String instanceId, AgentAPIController.InstanceSecrets secrets) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            LogicalInstance li = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
            if (secrets.adminAPIKey != null) {
                if (this.cryptoService.isAbleToEncrypt(li.getTenant())) {
                    li.setPossiblyEncryptedAdminAPIKey(this.cryptoService.encrypt(li.getTenant(), secrets.adminAPIKey));
                } else {
                    li.setPossiblyEncryptedAdminAPIKey(secrets.adminAPIKey);
                }
                rwt.getThreadEM().persist((Object)li);
                rwt.commit();
            }
        }
        if (secrets.adminPassword != null) {
            String key = tenantId + "__" + instanceId;
            Map<String, String> map = this.volatileAdminPasswords;
            synchronized (map) {
                this.volatileAdminPasswords.put(key, secrets.adminPassword);
            }
        }
    }

    public void onHeartbeatReceived(String tenantId, String instanceId, AgentAPIController.HeartbeatState hs) {
        PhysicalInstance pi = this.instancesCRUDService.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Updating instance heartbeat=%s liId=%s (%s)", new Object[]{tenantId, instanceId, JSON.log((Object)hs)});
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi.setLastHeartbeatTimestamp(System.currentTimeMillis());
            pi.setLastHeartbeatState(JSON.json((Object)hs));
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        LogicalInstance li = pi.getLogicalInstance();
        double diskUsageRatio = (double)hs.bytesUsed / (double)(0x40000000L * (long)li.getDataVolumeSizeGB());
        logger.infoV("Computed disk usage ratio tenantId=%s liId=%s size=%d sizeMax=%d ratio=%f", new Object[]{tenantId, instanceId, li.getDataVolumeSizeGB(), li.getDataVolumeSizeMaxGB(), diskUsageRatio});
        CloudStaticData csd = FMApp.getCloudStaticData(FMApp.getFMSettingsUnsafe().cloud);
        if (csd.dataVolumeSettings.defaultOverCapacityRatio <= diskUsageRatio && li.getDataVolumeSizeGB() < li.getDataVolumeSizeMaxGB()) {
            logger.infoV("Disk instance usage is over %f, try to grow disk", new Object[]{diskUsageRatio});
            if (this.cloudInstanceService.growPhysicalDataVolume(li, csd.dataVolumeSettings.defaultGrowthFactor)) {
                InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
                ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
                ac.type = InstanceAgentActionsQueueService.AgentCommandType.GROW_FILESYSTEM;
                this.instanceAgentActionsQueueService.enqueueCommand(null, tenantId, instanceId, ac);
            }
        }
    }

    public NodesDirectory getNodesDirectory(String tenantId, String instanceId) {
        LogicalInstance li = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
        return this.nodesDirectoryUpdateService.getCurrentNodesDirectory(tenantId, li.getVirtualNetwork().getId());
    }

    private void checkLabelUnicityAcrossVirtualNetwork(String tenantId, String virtualNetworkId, String label) throws CodedException {
        this.checkLabelUnicityAcrossVirtualNetwork(tenantId, virtualNetworkId, label, null);
    }

    private void checkLabelUnicityAcrossVirtualNetwork(String tenantId, String virtualNetworkId, String label, String nodeId) throws CodedException {
        if (this.instancesCRUDService.listInternal(tenantId).stream().filter(p -> !p.getId().equals(nodeId)).filter(p -> p.getVirtualNetwork().getId().equals(virtualNetworkId)).anyMatch(p -> StringUtils.isBlank((String)p.getLabel()) ? StringUtils.isBlank((String)label) : p.getLabel().equalsIgnoreCase(label))) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_LABEL_DUPLICATE, "An instance with the name '" + label + "' already exists in your virtual network.  Please choose an unique name.");
        }
    }

    private String arrayToStringCleaned(List<String> array) {
        if (array == null) {
            return null;
        }
        ListIterator<String> listIterator = array.listIterator();
        while (listIterator.hasNext()) {
            String next = listIterator.next();
            if (!StringUtils.isBlank((String)next)) continue;
            listIterator.remove();
        }
        return array.isEmpty() ? null : JSON.json(array);
    }

    private boolean requireReprovision(LogicalInstance li, PublicLogicalInstance pli) {
        return li.getCurrentPhysicalInstance() != null && (!Objects.equals(li.getImageId(), pli.imageId) || !Objects.equals(li.getCloudInstanceType(), pli.cloudInstanceType) || !Objects.equals(li.getInstanceSettingsTemplate().getId(), pli.instanceSettingsTemplateId) || !Objects.equals(li.isAwsAssignElasticIP(), pli.awsAssignElasticIP) || !Objects.equals(li.getAwsElasticIPAllocationId(), pli.awsElasticIPAllocationId) || !Objects.equals(li.getAwsPrivateIP(), pli.awsPrivateIP) || !Objects.equals(li.isAzureAssignPublicIP(), pli.azureAssignElasticIP) || !Objects.equals(li.getAzurePublicIPId(), pli.azurePublicIPId) || !Objects.equals(li.getAzurePublicIPName(), pli.azurePublicIPName) || !Objects.equals(li.getAzureNicName(), pli.azureNicName) || !Objects.equals(li.getAzureOSVolumeName(), pli.azureOSVolumeName) || !Objects.equals(li.getAzureInstanceName(), pli.azureInstanceName) || !Objects.equals(li.isGcpAssignPublicIP(), pli.gcpAssignPublicIP) || !Objects.equals(li.getGcpPublicIPId(), pli.gcpPublicIPId) || !Objects.equals(li.getGcpZone(), pli.gcpZone) || !Objects.equals(li.getGcpPrivateIP(), pli.gcpPrivateIP) || !Objects.equals(li.getAzurePrivateIP(), pli.azurePrivateIP) || !Objects.equals(Optional.ofNullable(li.getAdditionalDomainNamesForCertificate()).orElse("[]"), JSON.json(pli.additionalDomainNamesForCertificate)) || !Objects.equals(li.getSslCertificatePEM(), pli.sslCertificatePEM) || !Objects.equals(li.getSslCertificateAwsSecretName(), pli.sslCertificateAwsSecretName) || !Objects.equals(li.getSslCertificateGcpSecretId(), pli.sslCertificateGcpSecretId) || !Objects.equals((Object)li.getSslCertificateKeyStorageMode(), (Object)pli.sslCertificateKeyStorageMode) || !Objects.equals(li.getAzureSSLCertificateSecretName(), pli.azureSSLCertificateSecretName) || !Objects.equals(li.getAzureSSLCertificateSecretVersion(), pli.azureSSLCertificateSecretVersion) || !Objects.equals(li.getAzureKeyvaultUrl(), pli.azureKeyvaultUrl) || !Objects.equals(li.getAzureSSLCertificateName(), pli.azureSSLCertificateName) || !Objects.equals(li.getAzureSSLCertificateVersion(), pli.azureSSLCertificateVersion) || !Objects.equals((Object)li.getAzureSSLCertificateContentType(), (Object)pli.azureSSLCertificateContentType) || !Objects.equals(li.getSslCertificatePEM(), this.encryptSslCertificateKeyPEM(pli.sslCertificateKeyPEM, pli.sslCertificateKeyStorageMode, li.getTenant())) || !Objects.equals(li.getDataVolumeSizeGB(), pli.dataVolumeSizeGB) || !Objects.equals(CloudTagList.fromJSON(li.getCloudTags()), pli.cloudTags));
    }

    private String encryptSslCertificateKeyPEM(String sslCertificateKeyPEM, LogicalInstance.CustomCertificateKeyStorageMode sslCertificateKeyStorageMode, Tenant tenant) {
        String pliSslCertificateKeyPEM;
        if (StringUtils.isNotBlank((String)sslCertificateKeyPEM) && sslCertificateKeyStorageMode == LogicalInstance.CustomCertificateKeyStorageMode.INLINE_ENCRYPTED) {
            logger.info((Object)"Encrypting the key");
            pliSslCertificateKeyPEM = this.cryptoService.encrypt(tenant, sslCertificateKeyPEM);
        } else {
            pliSslCertificateKeyPEM = null;
        }
        return pliSslCertificateKeyPEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicLogicalInstance convertToDTO(String tenantId, LogicalInstance li, Map<String, String> dssImagesLabelById) {
        PublicLogicalInstance pli = new PublicLogicalInstance();
        VirtualNetwork vn = li.getVirtualNetwork();
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        Optional<LogicalLoadBalancer> loadBalancerOptional = this.loadBalancersCRUDService.getLoadBalancer(li.getId());
        pli.id = li.getId();
        pli.virtualNetworkId = vn.getId();
        pli.dssNodeType = li.getDssNodeType();
        pli.externalURL = li.getExternalURL();
        loadBalancerOptional.ifPresent(loadBalancer -> {
            if (loadBalancer.getCurrentPhysicalLoadBalancer() != null) {
                pli.loadBalancerId = loadBalancer.getId();
                pli.loadBalancerName = loadBalancer.getName();
                String protocol = loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE ? "http" : "https";
                pli.linkViaLoadBalancer = loadBalancer.getLoadBalancerNodeMapping().stream().filter(m -> m.getLogicalInstance().getId().equals(li.getId())).map(m -> protocol + "://" + LoadBalancerUtils.getFQDN(m.getSubdomainOrFQDN(), loadBalancer, this.dnsService)).findAny().orElse(null);
            }
        });
        pli.instanceSettingsTemplateId = ist.getId();
        pli.label = li.getLabel();
        pli.description = li.getDescription();
        pli.imageId = li.getImageId();
        pli.imageLabel = dssImagesLabelById.get(li.getImageId());
        pli.cloudInstanceType = li.getCloudInstanceType();
        pli.dataVolumeType = li.getDataVolumeType();
        pli.dataVolumeIOPS = li.getDataVolumeIOPS();
        pli.dataVolumeSizeGB = li.getDataVolumeSizeGB();
        pli.dataVolumeSizeMaxGB = li.getDataVolumeSizeMaxGB();
        pli.encryptDataVolume = li.getEncryptDataVolume();
        pli.dataVolumeEncryptionKey = li.getDataVolumeEncryptionKey();
        pli.encryptRootVolume = li.getEncryptRootVolume();
        pli.singleNodeAsInfrastructure = li.getSingleNodeAsInfrastructure() == null || li.getSingleNodeAsInfrastructure() != false;
        String fmTags = li.getFMTags();
        pli.fmTags = StringUtils.isNotBlank((String)fmTags) ? (List)JSON.parse((String)fmTags, (TypeToken)new TypeToken<List<String>>(){}) : Collections.emptyList();
        pli.cloudTags = CloudTagList.fromJSON(li.getCloudTags());
        pli.inheritedCloudTags = li.getInheritedCloudTags(loadBalancerOptional);
        pli.licenseSelectionMode = li.getLicenseSelectionMode();
        if (li.getSublicense() != null) {
            pli.sublicenseId = li.getSublicense().getId();
        }
        pli.enableAutomatedSnapshot = li.getEnableAutomatedSnapshot();
        pli.automatedSnapshotPeriod = li.getAutomatedSnapshotPeriod();
        pli.automatedSnapshotRetention = li.getAutomatedSnapshotRetention();
        pli.awsAssignElasticIP = li.isAwsAssignElasticIP();
        pli.awsElasticIPAllocationId = li.getAwsElasticIPAllocationId();
        pli.awsPrivateIP = li.getAwsPrivateIP();
        pli.rootVolumeSizeGB = li.getRootVolumeSizeGB();
        pli.awsRootVolumeType = li.getAwsRootVolumeType();
        pli.awsRootVolumeIOPS = li.getAwsRootVolumeIOPS();
        pli.awsRegion = vn.getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe());
        pli.azureRGForSnapshots = li.getAzureRGForSnapshots();
        pli.azureAvailabilityZone = li.getAzureAvailabilityZone();
        pli.azureAssignElasticIP = li.isAzureAssignPublicIP();
        pli.azurePublicIPId = li.getAzurePublicIPId();
        pli.azurePrivateIP = li.getAzurePrivateIP();
        pli.azureInstanceName = li.getAzureInstanceName();
        pli.azurePublicIPName = li.getAzurePublicIPName();
        pli.azureDataVolumeName = li.getAzureDataVolumeName();
        pli.azureOSVolumeName = li.getAzureOSVolumeName();
        pli.azureNicName = li.getAzureNicName();
        pli.azureRegion = vn.getAzureRegion();
        pli.gcpAssignPublicIP = li.isGcpAssignPublicIP();
        pli.gcpPublicIPId = li.getGcpPublicIPId();
        pli.gcpZone = li.getGcpZone();
        pli.gcpPrivateIP = li.getGcpPrivateIP();
        pli.gcpInstanceName = li.getGcpInstanceName();
        pli.gcpDataVolumeName = li.getGcpDataVolumeName();
        pli.additionalDomainNamesForCertificate = li.getAdditionalDomainNamesForCertificate() != null ? (List<Object>)JSON.parse((String)li.getAdditionalDomainNamesForCertificate(), JSON.StringList.class) : Collections.emptyList();
        pli.sslCertificatePEM = li.getSslCertificatePEM();
        pli.sslCertificateKeyPEM = StringUtils.isNotBlank((String)li.getSslCertificateKeyPEM()) ? "************" : "";
        pli.sslCertificateKeyStorageMode = li.getSslCertificateKeyStorageMode();
        pli.sslCertificateAwsSecretName = li.getSslCertificateAwsSecretName();
        pli.sslCertificateGcpSecretId = li.getSslCertificateGcpSecretId();
        pli.azureSSLCertificateSecretName = li.getAzureSSLCertificateSecretName();
        pli.azureSSLCertificateSecretVersion = li.getAzureSSLCertificateSecretVersion();
        pli.azureKeyvaultUrl = li.getAzureKeyvaultUrl();
        pli.azureSSLCertificateName = li.getAzureSSLCertificateName();
        pli.azureSSLCertificateVersion = li.getAzureSSLCertificateVersion();
        pli.azureSSLCertificateContentType = li.getAzureSSLCertificateContentType();
        String key = tenantId + "__" + li.getId();
        Map<String, String> map = this.volatileAdminPasswords;
        synchronized (map) {
            if (this.volatileAdminPasswords.containsKey(key)) {
                pli.hasInitialAdminPassword = true;
            }
        }
        pli.virtualNetworkLabel = StringUtils.isBlank((String)vn.getLabel()) ? vn.getId() : vn.getLabel();
        pli.resourceGroupForCreatedResources = StringUtils.isBlank((String)vn.getAzureRgNameForCreatedResources()) ? vn.getAzureRgName() : vn.getAzureRgNameForCreatedResources();
        pli.instanceSettingsTemplateLabel = StringUtils.isBlank((String)ist.getLabel()) ? ist.getId() : ist.getLabel();
        return pli;
    }

    private void setVolumeEncryption(PublicProtoLogicalInstance protoInstance, FMSettings settings, LogicalInstance li) {
        if (protoInstance.volumesEncryption == null) {
            protoInstance.volumesEncryption = PublicProtoLogicalInstance.VolumeEncryptionMode.NONE;
        }
        block0 : switch (settings.cloud) {
            case AWS: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break;
                    }
                    case TENANT: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(li.getTenant().getAwsCMKId());
                        break;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break;
                    }
                    case NONE: {
                        li.setEncryptDataVolume(false);
                        li.setEncryptRootVolume(false);
                    }
                }
                break;
            }
            case AZURE: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break block0;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break block0;
                    }
                    case TENANT: 
                    case NONE: {
                        throw new UnsupportedOperationException("Cannot encrypt with TENANT or NONE on Azure");
                    }
                }
                break;
            }
            case GCP: {
                switch (protoInstance.volumesEncryption) {
                    case DEFAULT_KEY: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        break block0;
                    }
                    case TENANT: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        String tenantProjectId = StringUtils.defaultIfBlank((String)li.getTenant().getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()).getGcpProjectId(), (String)settings.gcpSettings.projectId);
                        String cryptoKeyVersionSuffix = StringUtils.isBlank((String)li.getTenant().getGcpCryptoKeyVersion()) ? "" : "/cryptoKeyVersions/" + li.getTenant().getGcpCryptoKeyVersion();
                        li.setDataVolumeEncryptionKey(String.format("projects/%s/locations/%s/keyRings/%s/cryptoKeys/%s%s", tenantProjectId, li.getTenant().getGcpLocationId(), li.getTenant().getGcpKeyRing(), li.getTenant().getGcpCryptoKey(), cryptoKeyVersionSuffix));
                        break block0;
                    }
                    case CUSTOM: {
                        li.setEncryptDataVolume(true);
                        li.setEncryptRootVolume(true);
                        li.setDataVolumeEncryptionKey(protoInstance.volumesEncryptionKey);
                        break block0;
                    }
                    case NONE: {
                        li.setEncryptDataVolume(false);
                        li.setEncryptRootVolume(false);
                    }
                }
            }
        }
    }

    private static Map<String, String> buildDssImagesLabelById(FMSettings settings) {
        HashMap<String, String> dssImagesLabelById = new HashMap<String, String>();
        for (InstanceImagesSettings.InstanceImage ii : FMApp.getInstanceImagesSettings((Cloud)settings.cloud).images) {
            dssImagesLabelById.put(ii.id, ii.label);
        }
        return dssImagesLabelById;
    }

    public static class InitialPassword {
        public String password;
    }
}

