/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.SublicenseEnforcer;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.SublicenseDTO;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SublicenseCRUDService {
    @Autowired
    private DatabaseAccessService dbService;

    public List<SublicenseDTO> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        return this.dbService.listResults(Sublicense.class, "SELECT sl from sublicense sl where sl.tenant=?1", tenant).stream().map(SublicenseCRUDService::convertToDTO).collect(Collectors.toList());
    }

    public SublicenseDTO get(String tenantId, String slId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        Sublicense sl = this.dbService.getSingleResult(Sublicense.class, "SELECT sl from sublicense sl where sl.tenant=?1 AND sl.id=?2", tenant, slId);
        if (sl == null) {
            throw new IllegalArgumentException("Sublicense does not exist");
        }
        return SublicenseCRUDService.convertToDTO(sl);
    }

    public CommandResult delete(String tenantId, String slId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        Sublicense sl = this.dbService.getSingleResult(Sublicense.class, "SELECT sl from sublicense sl where sl.tenant=?1 AND sl.id=?2", tenant, slId);
        if (sl == null) {
            throw new IllegalArgumentException("Sublicense does not exist");
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().remove((Object)sl);
            rwt.commit();
            CommandResult commandResult = CommandResult.withSuccess(true);
            return commandResult;
        }
    }

    public SublicenseDTO create(AuthCtx authCtx, String tenantId, SublicenseDTO dto) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            Sublicense sl = new Sublicense();
            sl.setId("sl-" + SecretKeyGenerator.generate((int)12));
            sl.setTenant(tenant);
            sl.setLabel(dto.label);
            if (dto.sublicense != null) {
                sl.setSublicense(JSON.json((Object)dto.sublicense));
            }
            rwt.getThreadEM().persist((Object)sl);
            rwt.commit();
            SublicenseDTO sublicenseDTO = SublicenseCRUDService.convertToDTO(sl);
            return sublicenseDTO;
        }
    }

    public void update(AuthCtx authCtx, String tenantId, SublicenseDTO dto) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        Sublicense sl = this.dbService.getSingleResult(Sublicense.class, "SELECT sl from sublicense sl where sl.tenant=?1 AND sl.id=?2", tenant, dto.id);
        if (sl == null) {
            throw new IllegalArgumentException("Sublicense does not exist");
        }
        sl.setLabel(dto.label);
        if (dto.sublicense != null) {
            sl.setSublicense(JSON.json((Object)dto.sublicense));
        }
        this.dbService.getThreadEM().persist((Object)sl);
    }

    private static SublicenseDTO convertToDTO(Sublicense sl) {
        SublicenseDTO dto = new SublicenseDTO();
        dto.id = sl.getId();
        dto.label = sl.getLabel();
        dto.sublicense = sl.getSublicense() != null ? (SublicenseEnforcer.StandardSublicense)JSON.parse((String)sl.getSublicense(), SublicenseEnforcer.StandardSublicense.class) : new SublicenseEnforcer.StandardSublicense();
        return dto;
    }
}

