/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.loadbalancers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.FMFutureResponse;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.loadbalancers.LoadBalancerCodes;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadBalancerService {
    private static final DKULogger logger = DKULogger.getLogger((String)"fm.lb");
    private final DatabaseAccessService dbService;
    private final CloudLoadBalancerServiceInterface cloudLoadBalancerService;
    private final LoadBalancersCRUDService crudService;
    private final NodesDirectoryUpdateService nodesDirectoryUpdateService;
    private final FMFutureService futureService;
    private final InstancesCRUDService instancesCRUDService;
    private final LoadBalancersCRUDService loadBalancersCRUDService;

    @Autowired
    public LoadBalancerService(DatabaseAccessService dbService, CloudLoadBalancerServiceInterface cloudLoadBalancerService, LoadBalancersCRUDService crudService, NodesDirectoryUpdateService nodesDirectoryUpdateService, FMFutureService futureService, InstancesCRUDService instancesCRUDService, LoadBalancersCRUDService loadBalancersCRUDService) {
        this.dbService = dbService;
        this.cloudLoadBalancerService = cloudLoadBalancerService;
        this.crudService = crudService;
        this.nodesDirectoryUpdateService = nodesDirectoryUpdateService;
        this.futureService = futureService;
        this.instancesCRUDService = instancesCRUDService;
        this.loadBalancersCRUDService = loadBalancersCRUDService;
    }

    public FutureResponse<CommandResult> startDeprovisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(authCtx, FMFutureResponse.Action.DEPROVISION, 0L, loadBalancerId, FMFutureResponse.SourceObjectType.LOAD_BALANCER, smartLogTailBuilder, () -> this.deprovisionLoadBalancer(authCtx.getTenantId(), loadBalancerId, smartLogTailBuilder));
    }

    public FutureResponse<CommandResult> startProvisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(authCtx, FMFutureResponse.Action.PROVISION, 0L, loadBalancerId, FMFutureResponse.SourceObjectType.LOAD_BALANCER, smartLogTailBuilder, () -> this.provisionLoadBalancer(authCtx.getTenantId(), loadBalancerId, smartLogTailBuilder));
    }

    public FutureResponse<CommandResult> startDeleteLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(authCtx, FMFutureResponse.Action.DELETE, 0L, loadBalancerId, FMFutureResponse.SourceObjectType.LOAD_BALANCER, smartLogTailBuilder, () -> this.crudService.deleteLoadBalancer(authCtx.getTenantId(), loadBalancerId, smartLogTailBuilder));
    }

    public FutureResponse<CommandResult> startReprovisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(authCtx, FMFutureResponse.Action.REPROVISION, 0L, loadBalancerId, FMFutureResponse.SourceObjectType.LOAD_BALANCER, smartLogTailBuilder, () -> this.reprovisionLoadBalancer(authCtx.getTenantId(), loadBalancerId, smartLogTailBuilder));
    }

    public FutureResponse<CommandResult> startUpdateLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(authCtx, FMFutureResponse.Action.UPDATE, 0L, loadBalancerId, FMFutureResponse.SourceObjectType.LOAD_BALANCER, smartLogTailBuilder, () -> this.updateLoadBalancer(authCtx.getTenantId(), loadBalancerId, smartLogTailBuilder));
    }

    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer loadBalancer = this.crudService.getLoadBalancerMand(tenantId, loadBalancerId);
        return this.getPhysicalLoadBalancerStatus(loadBalancer);
    }

    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return new LoadBalancerPhysicalStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
        }
        return this.cloudLoadBalancerService.getPhysicalLoadBalancerStatus(loadBalancer);
    }

    public LoadBalancerDTO save(String tenantId, LoadBalancerDTO loadBalancerDTO) {
        LogicalLoadBalancer loadBalancer = this.loadBalancersCRUDService.getLoadBalancerMand(tenantId, loadBalancerDTO.id);
        Set<String> provisionNodeIdSet = loadBalancer.getLoadBalancerNodeMapping().stream().filter(loadBalancerNodeMapping -> this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned(loadBalancer, (LoadBalancerNodeMapping)loadBalancerNodeMapping)).map(LoadBalancerNodeMapping::getId).collect(Collectors.toSet());
        return this.loadBalancersCRUDService.save(tenantId, loadBalancerDTO, provisionNodeIdSet);
    }

    public void onAfterInstanceStatusUpdate(String tenantId, String instanceId) {
        LogicalInstance logicalInstance = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
        this.loadBalancersCRUDService.getLoadBalancer(logicalInstance.getId()).ifPresent(loadBalancer -> {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                this.cloudLoadBalancerService.onInstancePhysicalStateChange((LogicalLoadBalancer)loadBalancer, logicalInstance);
                rwt.getThreadEM().persist(loadBalancer);
                rwt.commit();
            }
        });
    }

    public void deleteLoadBalancerDependencies(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance logicalInstance) {
        this.loadBalancersCRUDService.getLoadBalancer(logicalInstance.getId()).ifPresent(loadBalancer -> {
            LoadBalancerNodeMapping nodeMapping = loadBalancer.getLoadBalancerNodeMapping().stream().filter(n -> n.getLogicalInstance().equals(logicalInstance)).findAny().orElseThrow(() -> new IllegalStateException("Node mapping does not exist although instance '" + logicalInstance.getLabel() + " ' is linked to lb '" + loadBalancer.getName() + "'"));
            loadBalancer.getLoadBalancerNodeMapping().remove(nodeMapping);
            if (this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned((LogicalLoadBalancer)loadBalancer, nodeMapping)) {
                this.cloudLoadBalancerService.onInstanceDeleteEvent(rwt, (LogicalLoadBalancer)loadBalancer, nodeMapping, logicalInstance);
            }
            rwt.getThreadEM().remove((Object)nodeMapping);
            rwt.getThreadEM().persist(loadBalancer);
            if (loadBalancer.getCurrentPhysicalLoadBalancer() != null) {
                rwt.getThreadEM().persist((Object)loadBalancer.getCurrentPhysicalLoadBalancer());
            }
        });
    }

    private Optional<CommandResult> checkLoadBalancerError(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE && loadBalancer.getVirtualNetwork().getHttpsStrategy() != VirtualNetwork.HTTPSStrategy.NONE) {
            return Optional.of(CommandResult.withSuccess(false).withError(LoadBalancerCodes.LOAD_BALANCER_CONFIGURATION_INVALID, "HTTP Load Balancer cannot work with an HTTPS Virtual Network."));
        }
        List<LogicalLoadBalancer> loadBalancersWithConflicts = this.crudService.getLoadBalancersWithConflictingSubdomainOrFQDN(loadBalancer.getId());
        if (!loadBalancersWithConflicts.isEmpty()) {
            return Optional.of(CommandResult.withSuccess(false).withError(LoadBalancerCodes.LOAD_BALANCER_CONFLICTING_CONFIGURATION, "Hostname conflicts detected with Load Balancers: " + String.join((CharSequence)",", loadBalancersWithConflicts.stream().map(LogicalLoadBalancer::getName).toList())));
        }
        return Optional.empty();
    }

    private CommandResult provisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        logger.infoV("Starting load balancer provisioning", new Object[0]);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction(true);){
            Tenant tenant = this.dbService.getSingleResultById(Tenant.class, tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.crudService.getLoadBalancerMand(tenantId, loadBalancerId);
            Optional<CommandResult> checkResult = this.checkLoadBalancerError(lb);
            if (checkResult.isPresent()) {
                CommandResult commandResult = checkResult.get();
                return commandResult;
            }
            try (Object globalState = FutureProgress.pushAutoCloseableState((String)"Creating load balancer", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                smartLogTail.appendLine("Starting the setup of load balancer components in the cloud", logger, Priority.INFO);
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement s1 = FutureProgress.pushAutoCloseableState((String)"Creating load balancer components", (double)1.0);){
                    this.cloudLoadBalancerService.createPhysicalLoadBalancer(lb, rwt, smartLogTail);
                    for (LoadBalancerNodeMapping m : lb.getLoadBalancerNodeMapping()) {
                        if (m.getStatus() == LoadBalancerNodeMapping.Status.ACTIVE) continue;
                        m.setStatus(LoadBalancerNodeMapping.Status.ACTIVE);
                        if (m.getPublicPhysicalDNSRecord() != null) {
                            rwt.getThreadEM().persist((Object)m.getPublicPhysicalDNSRecord());
                        }
                        if (m.getPrivatePhysicalDNSRecord() != null) {
                            rwt.getThreadEM().persist((Object)m.getPrivatePhysicalDNSRecord());
                        }
                        rwt.getThreadEM().persist((Object)m);
                    }
                    rwt.getThreadEM().persist((Object)lb.getCurrentPhysicalLoadBalancer());
                    rwt.getThreadEM().persist((Object)lb);
                    rwt.commit();
                }
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement s2 = FutureProgress.pushAutoCloseableState((String)"Provisioning load balancer components in the cloud", (double)1.0);){
                    LogicalLoadBalancer logicalLoadBalancer = this.crudService.getLoadBalancerMand(tenantId, loadBalancerId);
                    if (this.cloudLoadBalancerService.isLoadBalancerProvisioning(logicalLoadBalancer)) {
                        int count = 0;
                        smartLogTail.appendLine("Awaiting the provisioning of load balancer components...", logger, Priority.INFO);
                        do {
                            Thread.sleep(2000L);
                            smartLogTail.replaceLastLine("Awaiting the provisioning of load balancer components..." + ".".repeat(++count), logger, Priority.INFO);
                            logger.debugV("Checking physical load balancer status to see if the load balancer components were provisioned", new Object[0]);
                        } while (this.cloudLoadBalancerService.isLoadBalancerProvisioning(logicalLoadBalancer));
                    }
                }
            }
            smartLogTail.appendLine("Load balancer has been successfully provisioned.", logger, Priority.INFO);
            this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "provisioned");
            globalState = CommandResult.withSuccess(true);
            return globalState;
        }
    }

    private CommandResult deprovisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.crudService.getLoadBalancerMand(tenantId, loadBalancerId);
            PhysicalLoadBalancer currentPhysicalLoadBalancer = lb.getCurrentPhysicalLoadBalancer();
            if (currentPhysicalLoadBalancer == null) {
                FutureProgress.pushState((String)"Already deprovisioned.");
                CommandResult commandResult = CommandResult.withSuccess(true);
                return commandResult;
            }
            CommandResult commandResult = null;
            try {
                this.cloudLoadBalancerService.deletePhysicalLoadBalancer(lb, rwt, smartLogTail);
                for (LoadBalancerNodeMapping node : lb.getLoadBalancerNodeMapping()) {
                    if (node.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE) continue;
                    this.dbService.getThreadEM().remove((Object)node);
                }
                lb.getLoadBalancerNodeMapping().removeIf(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE);
                rwt.getThreadEM().remove((Object)currentPhysicalLoadBalancer);
                lb.setCurrentPhysicalLoadBalancer(null);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(true);
            }
            catch (Exception e) {
                logger.error((Object)"Could not deprovision physical LB.", (Throwable)e);
                logger.info((Object)("Saving current LB physical state: " + String.valueOf(currentPhysicalLoadBalancer)));
                rwt.getThreadEM().persist((Object)currentPhysicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DEPROVISIONING_ERROR, e.getMessage());
            }
            this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "deprovisioned");
            CommandResult commandResult2 = commandResult;
            return commandResult2;
        }
    }

    private CommandResult updateLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.crudService.getLoadBalancerMand(tenantId, loadBalancerId);
            PhysicalLoadBalancer currentPhysicalLoadBalancer = lb.getCurrentPhysicalLoadBalancer();
            if (currentPhysicalLoadBalancer == null) {
                throw new IllegalStateException("Application gateway not provisioned. Please provision or re-provision instead.");
            }
            Optional<CommandResult> checkResult = this.checkLoadBalancerError(lb);
            if (checkResult.isPresent()) {
                CommandResult commandResult = checkResult.get();
                return commandResult;
            }
            LoadBalancerPhysicalStatus physicalLoadBalancerPhysicalStatus = this.cloudLoadBalancerService.getPhysicalLoadBalancerStatus(lb);
            if (physicalLoadBalancerPhysicalStatus.getPhysicalStatus() != LoadBalancerDTO.PhysicalStatus.NEED_UPDATING) {
                logger.warn((Object)("Could not update physical LB with status: " + String.valueOf((Object)physicalLoadBalancerPhysicalStatus.getPhysicalStatus())));
                CommandResult commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DEPROVISIONING_ERROR, "Could not update physical LB with status: " + String.valueOf((Object)physicalLoadBalancerPhysicalStatus.getPhysicalStatus()));
                CommandResult commandResult2 = commandResult;
                return commandResult2;
            }
            CommandResult commandResult = null;
            try {
                this.cloudLoadBalancerService.updatePhysicalLoadBalancer(lb, rwt, smartLogTail, currentPhysicalLoadBalancer);
                for (LoadBalancerNodeMapping node : lb.getLoadBalancerNodeMapping()) {
                    if (node.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE) continue;
                    this.dbService.getThreadEM().remove((Object)node);
                }
                lb.getLoadBalancerNodeMapping().removeIf(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(true);
            }
            catch (Exception e) {
                logger.error((Object)"Could not update physical LB.", (Throwable)e);
                commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_UPDATE_ERROR, e.getMessage());
            }
            this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "updated");
            CommandResult commandResult3 = commandResult;
            return commandResult3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult reprovisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        CommandResult commandResult = new CommandResult();
        try (FutureProgress.AutocloseableFutureProgressState s1 = FutureProgress.pushAutoCloseableState((String)"Reprovision load balancer", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deprovisionStep = FutureProgress.pushAutoCloseableState((String)"Deprovisioning load balancer", (double)1.0);){
                commandResult = this.deprovisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
                if (!commandResult.success) {
                    CommandResult commandResult2 = commandResult;
                    return commandResult2;
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement provisionStep = FutureProgress.pushAutoCloseableState((String)"Provisioning load balancer", (double)1.0);){
                commandResult = this.provisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
            CommandResult commandResult3 = commandResult;
            return commandResult3;
        }
        catch (InterruptedException e) {
            logger.warnV("Thread reprovisioning load balancer has been interrupted", new Object[0]);
            smartLogTail.appendLine("An error occurred while reprovisioning the load balancer.", logger, Priority.INFO);
            commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_REPROVISIONING_ERROR, e.getMessage());
            return commandResult;
        }
    }
}

