/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.ProtoLoadBalancer;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.loadbalancers.LoadBalancerService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPILoadBalancersController
extends PublicAPIControllerBase {
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private LoadBalancersCRUDService loadBalancersCRUDService;
    @Autowired
    private LoadBalancerService loadBalancerService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/load-balancers"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        List<LoadBalancerDTO> ret = this.loadBalancersCRUDService.list(tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/load-balancers"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        ProtoLoadBalancer plb = (ProtoLoadBalancer)this.getRequestBodyAs(req, ProtoLoadBalancer.class);
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        LoadBalancerDTO lbdto = this.loadBalancersCRUDService.create(tenantId, plb);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)lbdto);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}/physical/status"})
    public void getPhysicalLoadBalancerStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancerService.getPhysicalLoadBalancerStatus(tenantId, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.get(tenantId, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}"})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        LoadBalancerDTO dto = (LoadBalancerDTO)this.getRequestBodyAs(req, LoadBalancerDTO.class);
        dto.id = loadBalancerId;
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancerService.save(tenantId, dto));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancerService.startDeleteLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}/actions/provision"})
    public void provision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancerService.startProvisionLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}/actions/deprovision"})
    public void deprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancerService.startDeprovisionLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/public/tenants/{tenantId}/load-balancers/{loadBalancerId}/actions/reprovision"})
    public void reprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPILoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancerService.startReprovisionLoadBalancer(authCtx, loadBalancerId));
    }
}

