/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.fm.model.published.CloudCredentialsDTO;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.TenantCredentialsService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPITenantController
extends PublicAPIControllerBase {
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private TenantCredentialsService tenantCredentialsService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-credentials"}, method={RequestMethod.GET})
    public void getCloudCredentials(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPITenantController.writeJSON((HttpServletResponse)resp, (Object)this.tenantCredentialsService.getCloudCredentialsDTO(tenantId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-credentials"}, method={RequestMethod.PUT})
    public void updateCloudCredentials(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        CloudCredentialsDTO credentials = (CloudCredentialsDTO)this.getRequestBodyAs(req, CloudCredentialsDTO.class);
        this.tenantCredentialsService.updateCloudCredentials(authCtx, tenantId, credentials);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-tags"}, method={RequestMethod.GET})
    public void getCloudTags(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPITenantController.writeJSON((HttpServletResponse)resp, (Object)CloudTagList.toJSON(this.tenantCredentialsService.getCloudTags(tenantId)));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-tags"}, method={RequestMethod.PUT})
    public void updateCloudTags(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        String tagsString = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
        CloudTagList tags = CloudTagList.fromJSON(tagsString);
        this.tenantCredentialsService.updateCloudTags(authCtx, tenantId, tags);
    }
}

