/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.fm.security.FMAuthCtx;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FMPermissionsService {
    public void checkOwnTenantAdmin(AuthCtx authCtx) throws Exception {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                throw new Error("unreachable");
            }
            case NONE: {
                throw new Error("no permissions on this authctx");
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                FMAuthCtx dic = (FMAuthCtx)authCtx;
                if (StringUtils.isBlank((String)dic.getTenantId())) {
                    throw new UnauthorizedException("Unauthorized", "bad-tenant");
                }
                if (!dic.getPermissions().isAdmin()) {
                    throw new UnauthorizedException("Unauthorized", "not-tenant-admin");
                }
                return;
            }
        }
        throw new Error("unreachable");
    }

    public void checkTenantAdmin(AuthCtx authCtx, String tenantId) throws Exception {
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: 
            case CONFIGURABLE_API_KEY_GLOBAL: 
            case GLOBAL_API_KEY_WITH_GROUPS: {
                throw new Error("unreachable");
            }
            case NONE: {
                throw new Error("no permissions on this authctx");
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                FMAuthCtx dic = (FMAuthCtx)authCtx;
                if (StringUtils.isBlank((String)dic.getTenantId()) || !dic.getTenantId().equals(tenantId)) {
                    throw new UnauthorizedException("Unauthorized", "bad-tenant");
                }
                if (!dic.getPermissions().isAdmin()) {
                    throw new UnauthorizedException("Unauthorized", "not-tenant-admin");
                }
                return;
            }
        }
        throw new Error("unreachable");
    }
}

