/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.fm.model.db.FMGroup;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.FMUserDTO;
import com.dataiku.fm.model.published.FMUserNoLeakDTO;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FMUsersService
implements DkuUsersService {
    private static final String BASE_LOGIN_PATTEN = "[a-zA-Z0-9@.+_-]+";
    private static final Pattern LOGIN_PATTERN = Pattern.compile("^[a-zA-Z0-9@.+_-]+$");
    private final DatabaseAccessService dbService;
    private final Tenant tenant;

    @Autowired
    public FMUsersService(String tenantId, DatabaseAccessService dbService) {
        this.dbService = dbService;
        this.tenant = (Tenant)dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (this.tenant != null);
    }

    public DkuUser createForeignUser(UserSourceType sourceType, String login, String displayName, String email, Set<String> groups, String userProfile, Map<String, String> secrets) {
        return this.createForeignUser(sourceType, login, displayName, null);
    }

    public FMUserNoLeakDTO create(FMUserDTO dto) {
        return new FMUserNoLeakDTO(this.createForeignUser(dto.getUserSourceType(), StringUtils.trimToEmpty((String)dto.emailAddress), dto.displayName, dto.password));
    }

    public DkuUser createForeignUser(UserSourceType sourceType, String login, String displayName, String password) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            String loginTrimmed = StringUtils.trimToEmpty((String)login);
            List<FMUser> existingUsers = this.dbService.listResults(FMUser.class, "SELECT usr from fmuser usr where usr.tenant=?1 and usr.emailAddress=?2", this.tenant, loginTrimmed);
            if (!existingUsers.isEmpty()) {
                throw new IllegalArgumentException("A user with the same username/email address already exists.");
            }
            List<FMGroup> existingGroups = this.dbService.listResults(FMGroup.class, "SELECT grp from fmgroup grp where grp.tenant=?1", this.tenant);
            if (existingGroups.isEmpty()) {
                throw new IllegalStateException("No group defined for this tenant. Create a group first.");
            }
            HashSet fmGroups = Sets.newHashSet(existingGroups);
            FMUser fmUser = new FMUser();
            fmUser.setCreatedBy(null);
            fmUser.setCreationDate(System.currentTimeMillis());
            fmUser.setDisplayName(displayName == null ? null : StringUtils.trimToNull((String)displayName.trim()));
            fmUser.setGroups(fmGroups);
            fmUser.setEmailAddress(loginTrimmed);
            fmUser.setSourceType(sourceType);
            fmUser.setSessions(null);
            fmUser.setTenant(this.tenant);
            if (sourceType == UserSourceType.LOCAL) {
                fmUser.setSecurePassword(password);
            }
            this.dbService.getThreadEM().persist((Object)fmUser);
            rwt.commit();
            FMUser fMUser = fmUser;
            return fMUser;
        }
    }

    public List<? extends DkuGroup> listGroups() {
        return this.dbService.listResults(FMGroup.class, "SELECT grp from fmgroup grp where grp.tenant=?1", this.tenant);
    }

    public List<? extends DkuUser> listUsers() {
        return this.listFMUsers();
    }

    public boolean checkPassword(String login, String password) throws CodedException {
        FMUser user = this.getUserOrNull(login);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    public boolean areLoginsCaseSensitive() {
        return false;
    }

    public boolean isValidLogin(String login) {
        return !StringUtils.isBlank((CharSequence)login) && LOGIN_PATTERN.matcher(login).find();
    }

    public void sendWelcomeEmail(DkuUser user) {
    }

    public void sendWelcomeEmailWhenProfileChange(DkuUser oldUser) {
    }

    public List<FMUserNoLeakDTO> list() {
        return this.listFMUsers().stream().map(FMUserNoLeakDTO::new).collect(Collectors.toList());
    }

    public List<FMUser> listFMUsers() {
        return this.dbService.listResults(FMUser.class, "SELECT usr from fmuser usr where usr.tenant=?1", this.tenant);
    }

    public FMUser getUserOrNull(String login) {
        return this.dbService.getSingleResult(FMUser.class, "SELECT u FROM fmuser u WHERE u.emailAddress = ?1 AND u.tenant = ?2", login, this.tenant);
    }

    public UserDiff updateUser(DkuUser user) {
        this.updateUser(user.getLogin(), user, null);
        return new UserDiff();
    }

    public void disableDkuUser(String userLogin) {
        DkuUser syncedUser = this.getUserWithCaseSensitiveRule(userLogin);
        syncedUser.setEnabled(false);
        this.updateUser(syncedUser);
    }

    public void updateUser(String oldLogin, FMUserDTO user) {
        this.updateUser(oldLogin, user, user.password);
    }

    public void updateUser(String oldLogin, DkuUser user, String password) {
        String oldLoginTrimmed = StringUtils.trimToEmpty((String)oldLogin);
        Preconditions.checkArgument((!oldLoginTrimmed.isEmpty() ? 1 : 0) != 0, (Object)"emailAddress cannot be null or empty");
        FMUser fmUser = this.getUserMandatory(oldLoginTrimmed);
        String newLogin = StringUtils.trimToEmpty((String)user.getEmail());
        Preconditions.checkArgument((!newLogin.isEmpty() ? 1 : 0) != 0, (Object)"username/email cannot be null or empty");
        if (!newLogin.equalsIgnoreCase(oldLogin.trim())) {
            FMUser otherUser = this.getUserOrNull(newLogin);
            if (otherUser != null) {
                throw new IllegalArgumentException("Cannot use this email address because it is already used by another user.");
            }
            fmUser.setEmailAddress(newLogin);
        }
        fmUser.setDisplayName(StringUtils.trimToNull((String)user.getDisplayName()));
        fmUser.setSourceType(user.getUserSourceType());
        if (!StringUtils.isBlank((CharSequence)password)) {
            fmUser.setSecurePassword(password);
        }
        this.dbService.getThreadEM().persist((Object)fmUser);
    }

    public void delete(String login) {
        String currentEmailAddress = StringUtils.trimToEmpty((String)login);
        Preconditions.checkArgument((!currentEmailAddress.isEmpty() ? 1 : 0) != 0, (Object)"emailAddress cannot be null or empty");
        FMUser user = this.getUserMandatory(currentEmailAddress);
        this.dbService.getThreadEM().remove((Object)user);
    }

    public DkuUser getUserWithCaseSensitiveRule(String login) {
        return this.getUserOrNull(login);
    }

    public FMUserNoLeakDTO getUserNoLeakDTO(String emailAddress) throws NotFoundException {
        FMUser user = this.getUserOrNull(emailAddress);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        return new FMUserNoLeakDTO(user);
    }

    private FMUser getUserMandatory(String login) {
        FMUser user = this.getUserOrNull(login);
        if (user == null) {
            throw new IllegalArgumentException("Unknown User. It may have been deleted.");
        }
        return user;
    }
}

