/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security.auth;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.LocalUserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.ldap.LDAPConnectionFactory;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.fm.server.licensing.CentralLicensingStatusService;
import com.dataiku.fm.server.security.FMLicenseEnforcementService;
import com.dataiku.fm.server.security.FMUsersService;
import com.dataiku.fm.server.security.FMUsersServiceFactory;
import com.dataiku.fm.server.security.auth.FMAzureADUserSupplier;
import com.dataiku.fm.server.security.auth.FMLdapCredentialsAuthenticatorAndSupplier;
import com.dataiku.fm.server.security.auth.FMSSOUserSupplier;
import com.dataiku.fm.server.security.auth.FMUserAuthenticationService;
import com.dataiku.fm.server.services.PubSubService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMUserAuthenticationFactory {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CentralLicensingStatusService centralLicensingStatusService;
    @Autowired
    private FMSSOUserSupplier fmssoUserSupplier;
    @Autowired
    private FMAzureADUserSupplier fmAzureADUserSupplier;
    @Autowired
    private LDAPConnectionFactory ldapConnectionFactory;
    @Autowired
    private FMUsersServiceFactory fmUsersServiceFactory;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private final Map<String, UserAuthenticationService> userAuthenticationServiceByTenant = new HashMap<String, UserAuthenticationService>();

    public UserAuthenticationService getUserAuthenticationService(String tenantId) {
        return this.userAuthenticationServiceByTenant.computeIfAbsent(tenantId, tenant -> {
            FMLicenseEnforcementService licenseEnforcementService = new FMLicenseEnforcementService(tenantId, this.centralLicensingStatusService);
            FMLicenseEnforcementService fmLicenseEnforcementService = new FMLicenseEnforcementService(tenantId, this.centralLicensingStatusService);
            FMLdapCredentialsAuthenticatorAndSupplier ldapCredentialsAuthenticatorAndSupplier = new FMLdapCredentialsAuthenticatorAndSupplier(this.ldapConnectionFactory, fmLicenseEnforcementService, this.pubSubService);
            FMUsersService fmUsersService = this.fmUsersServiceFactory.get(tenantId);
            LocalUserCredentialsAuthenticator localUserCredentialsAuthenticator = new LocalUserCredentialsAuthenticator(this.transactionService, (DkuUsersService)fmUsersService);
            return new FMUserAuthenticationService(this.auditTrailService, fmUsersService, this.transactionService, Stream.of(new UserCredentialsAuthenticator[]{localUserCredentialsAuthenticator, ldapCredentialsAuthenticatorAndSupplier}).collect(Collectors.toList()), Stream.of(new UserSupplier[]{this.fmssoUserSupplier, this.fmAzureADUserSupplier, ldapCredentialsAuthenticatorAndSupplier}).collect(Collectors.toList()), licenseEnforcementService, this.symetricCryptoService);
        });
    }
}

