/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.settings;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMUserDataSettings;
import com.dataiku.fm.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.fm.server.services.PubSubService;
import com.dataiku.fm.server.settings.UserDataSettingsDAO;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingsDAO {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UserDataSettingsDAO userDataSettingsDAO;
    private static RelFile f = RelFile.global((String)"settings.json");
    private static DKULogger logger = DKULogger.getLogger((String)"fm.settings.dao");

    public FMSettings read() throws IOException {
        FMUserDataSettings userData = this.userDataSettingsDAO.read();
        TransactionRef t = TransactionContext.retrieveRead();
        FMSettings fmSettings = (FMSettings)t.readObjectDefault(f, FMSettings.class);
        this.loadUserDataIntoFMSetting(fmSettings, userData);
        return fmSettings;
    }

    public FMSettings getUnsafe() throws IOException {
        FMUserDataSettings userData = this.userDataSettingsDAO.getUnsafe();
        TransactionRef t = TransactionContext.retrieveRead();
        FMSettings fmSettings = t.isFile(f) ? (FMSettings)t.readObjectUnsafe(f, FMSettings.class) : new FMSettings();
        this.loadUserDataIntoFMSetting(fmSettings, userData);
        return fmSettings;
    }

    public void save(FMSettings settings) throws IOException {
        FMSettings previous = this.read();
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(f, (Object)settings);
        this.pubSubService.publishAfterTransaction((DSSEvent)new GeneralSettingsChangedEvent(previous, settings));
    }

    public FMSettings getUnsafeAutoTXN() throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.getUnsafe();
        }
        if (this.transactionService == null) {
            logger.warn((Object)"dep injection mess : transactionService isn't ready");
            this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            FMSettings fMSettings = this.getUnsafe();
            return fMSettings;
        }
    }

    public void loadUserDataIntoFMSetting(FMSettings settings, FMUserDataSettings fmUserDataSettings) {
        settings.databaseSettings = fmUserDataSettings.databaseSettings;
        settings.cloud = fmUserDataSettings.cloud;
        settings.awsSettings = fmUserDataSettings.awsSettings;
        settings.azureSettings = fmUserDataSettings.azureSettings;
        settings.gcpSettings = fmUserDataSettings.gcpSettings;
        settings.instanceVisibleURL = fmUserDataSettings.instanceVisibleURL;
        if (logger.isTraceEnabled()) {
            try {
                logger.trace((Object)("FM settings: " + JSON.prettyLog((Object)settings)));
            }
            catch (Exception e) {
                logger.trace((Object)"Couldn't print FM settings as json", (Throwable)e);
            }
        }
    }
}

