/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.snapshots;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.published.DataVolumeSnapshotDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.snapshots.SnapshotsCRUDService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SnapshotsController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private SnapshotsCRUDService snapshotsCRUDService;
    @Autowired
    private PhysicalInstanceProvisioningService provisioningService;
    @Autowired
    private FMPermissionsService permissionsService;

    @RequestMapping(value={"/api/ui/snapshots/list"})
    public void listTenantInstances(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        List<DataVolumeSnapshotDTO> ret = this.snapshotsCRUDService.list(authCtx.getTenantId(), instanceId);
        SnapshotsController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/ui/snapshots/create"})
    public void createSnapshot(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String reasonForSnapshot) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        DataVolumeSnapshotDTO ret = this.provisioningService.snapshot(authCtx.getTenantId(), instanceId, reasonForSnapshot);
        SnapshotsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @RequestMapping(value={"/api/ui/snapshots/delete"})
    public void deleteSnapshot(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String snapshotId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        SnapshotsController.writeJSON((HttpServletResponse)resp, (Object)this.provisioningService.deleteSnapshot(authCtx.getTenantId(), instanceId, snapshotId));
    }

    @RequestMapping(value={"/api/ui/snapshots/start-delete"})
    public void startDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String snapshotId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        SnapshotsController.writeJSON((HttpServletResponse)resp, this.provisioningService.startDeleteSnapshot(authCtx, instanceId, snapshotId));
    }

    @RequestMapping(value={"/api/ui/snapshots/start-deletes"})
    public void startDeletes(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String snapshots) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        List ids = (List)JSON.parse((String)snapshots, List.class);
        SnapshotsController.writeJSON((HttpServletResponse)resp, this.provisioningService.startDeleteSnapshots(authCtx, instanceId, ids));
    }

    @RequestMapping(value={"/api/ui/snapshots/reprovision-instance"})
    public void reprovisionInstanceFromSnapshot(HttpServletRequest req, HttpServletResponse resp, @RequestParam String instanceId, @RequestParam String snapshotId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        SnapshotsController.writeJSON((HttpServletResponse)resp, this.provisioningService.startReprovisionFromPreviousSnapshot(authCtx, instanceId, snapshotId));
    }
}

