/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.internal.NodeTraversalChecker;
import se.fishtank.css.selectors.specifier.AttributeSpecifier;
import se.fishtank.css.util.Assert;

public class AttributeSpecifierChecker
extends NodeTraversalChecker {
    private final AttributeSpecifier specifier;

    public AttributeSpecifierChecker(AttributeSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        for (Node node : nodes) {
            Attr attr;
            NamedNodeMap map = node.getAttributes();
            if (map == null || (attr = (Attr)map.getNamedItem(this.specifier.getName())) == null) continue;
            if (this.specifier.getValue() == null) {
                result.add(node);
                continue;
            }
            String value = attr.getNodeValue().trim();
            if (value.length() == 0) continue;
            String val = this.specifier.getValue();
            switch (this.specifier.getMatch()) {
                case EXACT: {
                    if (!value.equals(val)) break;
                    result.add(node);
                    break;
                }
                case HYPHEN: {
                    if (!value.equals(val) && !value.startsWith(val + '-')) break;
                    result.add(node);
                    break;
                }
                case PREFIX: {
                    if (!value.startsWith(val)) break;
                    result.add(node);
                    break;
                }
                case SUFFIX: {
                    if (!value.endsWith(val)) break;
                    result.add(node);
                    break;
                }
                case CONTAINS: {
                    if (!value.contains(val)) break;
                    result.add(node);
                    break;
                }
                case LIST: {
                    for (String v : value.split("\\s+")) {
                        if (!v.equals(val)) continue;
                        result.add(node);
                    }
                    break;
                }
            }
        }
        return result;
    }
}

