/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.LogManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;

public class MainLoggingConfiguratorBase {
    public static void loadFile(File f) {
        Logger logger = Logger.getLogger((String)"dku.logging");
        if (f.isFile()) {
            logger.info((Object)("Configuring additional logging settings from " + String.valueOf(f)));
            try (FileInputStream is = new FileInputStream(f);){
                PropertyConfigurator.configure((InputStream)is);
            }
            catch (Throwable e) {
                System.err.println("Failed to configure logging from: " + String.valueOf(f));
                e.printStackTrace();
            }
        }
    }

    public static void loadJULFile(File f) {
        Logger logger = Logger.getLogger((String)"dku.logging");
        if (f.isFile()) {
            logger.info((Object)("Configuring additional JUL logging settings from " + String.valueOf(f)));
            try (FileInputStream is = new FileInputStream(f);){
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (Throwable e) {
                System.err.println("Failed to configure logging from: " + String.valueOf(f));
                e.printStackTrace();
            }
        }
    }

    public static void loadMainLog4JProperties() {
        URL u = Loader.getResource((String)"log4j.properties");
        if (u == null) {
            System.err.println("Logging resource not found ...");
            BasicConfigurator.configure();
        } else {
            PropertyConfigurator.configure((URL)Loader.getResource((String)"log4j.properties"));
        }
    }
}

