/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.StreamUtils;
import com.dataiku.dip.utils.WindowsUtils;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class DKUFileUtils {
    public static final FilenameFilter JAR_FILES = (dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".jar");
    public static final FilenameFilter JSON_FILES = (dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".json");
    private static final int MAX_PREVIEW_LENGTH = 65536;
    private static final Pattern archiveMimeTypePattern = Pattern.compile("^.*\\/.*(zip|tar|bz|gz)2?$", 2);
    private static final Logger logger = Logger.getLogger((String)"dku.fileutils");

    public static File build(File folder, String ... chunks) {
        File f = folder;
        for (String c : chunks) {
            f = new File(f, c);
        }
        return f;
    }

    public static File build(String ... chunks) {
        if (chunks.length == 0) {
            throw new IllegalArgumentException("empty path");
        }
        File f = new File(chunks[0]);
        for (int i = 1; i < chunks.length; ++i) {
            f = new File(f, chunks[i]);
        }
        return f;
    }

    public static void mkdirs(File folder) throws IOException {
        if (folder.exists()) {
            if (folder.isDirectory()) {
                return;
            }
            throw new IOException("Can't create " + folder.getAbsolutePath() + ": is a file");
        }
        FileUtils.forceMkdir((File)folder);
    }

    public static void mkdirsParent(File file) throws IOException {
        DKUFileUtils.mkdirs(file.getParentFile());
    }

    public static void mkdirs700(File folder) throws IOException {
        Path path = folder.toPath();
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        DKUFileUtils.createDirectories(path, attr);
    }

    public static void mkdirs711(File folder) throws IOException {
        Path path = folder.toPath();
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx--x--x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        DKUFileUtils.createDirectories(path, attr);
    }

    public static void delete(File f) throws IOException {
        if (f.exists() && !f.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(f));
        }
    }

    public static String readFileToStringUTF8(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"utf8");
    }

    public static void writeFileUTF8(File file, String content) throws IOException {
        File tmpFile = new File(file.getPath() + "." + content.hashCode());
        FileUtils.write((File)tmpFile, (CharSequence)content, (String)"utf8");
        if (file.exists()) {
            DKUFileUtils.forceDelete(file);
        }
        FileUtils.moveFile((File)tmpFile, (File)file);
    }

    public static void createIfNotExists(File file) throws IOException {
        if (!file.exists()) {
            DKUFileUtils.writeFileUTF8(file, "", true);
        }
    }

    public static <E extends Exception> void writeFile(File file, ExceptionUtils.ThrowingConsumer<OutputStream, E> streamWriter) throws E, IOException {
        long ts = System.currentTimeMillis();
        File tmpFile = new File(file.getPath() + "." + ts + ".__tmp__");
        try (FileOutputStream os = FileUtils.openOutputStream((File)tmpFile);){
            streamWriter.accept(os);
        }
        if (file.exists()) {
            DKUFileUtils.forceDelete(file);
        }
        FileUtils.moveFile((File)tmpFile, (File)file);
    }

    public static String readFileToStringUTF8OrEmpty(File file) throws IOException {
        if (file.exists()) {
            return DKUFileUtils.readFileToStringUTF8(file);
        }
        return "";
    }

    public static void writeFileUTF8(File file, String content, boolean mkdirs) throws IOException {
        if (mkdirs) {
            DKUFileUtils.mkdirsParent(file);
        }
        DKUFileUtils.writeFileUTF8(file, content);
    }

    public static List<File> listFiles(File parent) {
        return DKUFileUtils.listFiles(parent, null);
    }

    public static List<File> listFiles(File parent, FilenameFilter filter) {
        Object[] files = parent != null ? parent.listFiles(filter) : null;
        return files != null ? Lists.newArrayList((Object[])files) : new ArrayList();
    }

    public static List<File> listJarFiles(String parent) {
        return DKUFileUtils.listJarFiles(parent != null ? new File(parent) : null);
    }

    public static List<File> listJarFiles(File parent) {
        return DKUFileUtils.listFiles(parent, JAR_FILES);
    }

    public static List<File> listJsonFiles(String parent) {
        return DKUFileUtils.listJsonFiles(parent != null ? new File(parent) : null);
    }

    public static List<File> listJsonFiles(File parent) {
        return DKUFileUtils.listFiles(parent, JSON_FILES);
    }

    public static List<File> recursiveListFiles(File root) throws IOException {
        return DKUFileUtils.recursiveListFiles(root, FileFilter.FILES);
    }

    public static void deleteDirectory(File root) throws IOException {
        if (DKUtils.isOsWindows()) {
            WindowsUtils.recursivelyRemoveReadOnlyFlag(root);
        }
        FileUtils.deleteDirectory((File)root);
    }

    public static void forceDelete(File file) throws IOException {
        if (DKUtils.isOsWindows()) {
            WindowsUtils.recursivelyRemoveReadOnlyFlag(file);
        }
        FileUtils.forceDelete((File)file);
    }

    public static List<File> recursiveListFiles(File root, java.io.FileFilter fileFilter) throws IOException {
        if (!root.isDirectory()) {
            throw new IOException("Root " + String.valueOf(root) + " is not a directory");
        }
        ArrayList<File> ret = new ArrayList<File>();
        DKUFileUtils.listRec(root, ret, fileFilter);
        return ret;
    }

    private static Path createDirectories(Path dir, FileAttribute<Set<PosixFilePermission>> attribute) throws IOException {
        if (DKUtils.isOsWindows()) {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        return Files.createDirectories(dir, attribute);
    }

    private static void listRec(File f, List<File> ret, java.io.FileFilter fileFilter) {
        File[] children;
        if (f.isDirectory() && (children = f.listFiles()) != null) {
            Arrays.sort(children, new Comparator<File>(){

                @Override
                public int compare(File a, File b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (File child : children) {
                DKUFileUtils.listRec(child, ret, fileFilter);
            }
        }
        if (fileFilter.accept(f)) {
            ret.add(f);
        }
    }

    public static String fileToString(File path) throws IOException {
        return DKUFileUtils.fileToString(path, "UTF-8");
    }

    public static String fileToString(File path, String encoding) throws IOException {
        try (BufferedReader br = StreamUtils.readFile(path, encoding);){
            String string = DKUFileUtils.streamToString(br);
            return string;
        }
    }

    public static String streamToString(BufferedReader in) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static long highestFileNumber(File root, String prefix) {
        return DKUFileUtils.highestFileNumber(root, prefix, null);
    }

    public static long highestFileNumber(File root, String prefix, @Nullable Long upperBoundExclusive) {
        long maxNumber = -1L;
        if (!root.isDirectory()) {
            return maxNumber;
        }
        File[] files = root.listFiles();
        if (files == null) {
            return maxNumber;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith(prefix)) continue;
            try {
                long currentNumber = Long.parseLong(fileName.replace(prefix, ""));
                if (upperBoundExclusive != null && currentNumber >= upperBoundExclusive) continue;
                maxNumber = Math.max(currentNumber, maxNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxNumber;
    }

    public static File newestFile(File folder, String prefix) {
        Validate.isTrue((boolean)folder.isDirectory(), (String)("folder must be a directory: " + String.valueOf(folder)));
        Logger.getLogger((String)"dku").info((Object)("Newest file in folder " + String.valueOf(folder) + " ..."));
        long latest = -1L;
        File newest = null;
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                Logger.getLogger((String)"dku").info((Object)("Newest file in folder " + String.valueOf(f)));
                if (prefix == null || f.getName().startsWith(prefix)) {
                    long cur = f.lastModified();
                    Logger.getLogger((String)"dku").info((Object)("  valid " + cur));
                    if (cur <= latest) continue;
                    newest = f;
                    latest = cur;
                    continue;
                }
                Logger.getLogger((String)"dku").info((Object)("invalid " + prefix));
            }
        }
        return newest;
    }

    public static File newestByNameFile(File folder, String regex) {
        Validate.isTrue((boolean)folder.isDirectory(), (String)("folder must be a directory: " + String.valueOf(folder)));
        Logger.getLogger((String)"dku").info((Object)("Newest by name file in folder " + String.valueOf(folder) + " ... (pattern=" + regex + ")"));
        final Pattern pattern = Pattern.compile(regex);
        File[] files = folder.listFiles(new java.io.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && pattern.matcher(f.getName()).matches();
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        Arrays.sort(files, (a, b) -> -a.getName().compareTo(b.getName()));
        return files[0];
    }

    public static File transmogrify(File folder, String filename) {
        Validate.isTrue((boolean)folder.isDirectory(), (String)("folder must be a directory: " + String.valueOf(folder)));
        File f = new File(folder, filename);
        if (!f.exists()) {
            return f;
        }
        int suffix = 1;
        while ((f = new File(folder, filename + "-" + suffix)).exists()) {
            ++suffix;
        }
        return f;
    }

    public static boolean isWithin(File container, File content) throws IOException {
        return DKUFileUtils.isWithin(container, content, false);
    }

    public static boolean isWithinFollowLinks(File container, File content) throws IOException {
        return DKUFileUtils.isWithinFollowLinks(container, content, false);
    }

    public static boolean isWithinOrSame(File container, File content) throws IOException {
        return DKUFileUtils.isWithin(container, content, true);
    }

    public static boolean isWithinOrSameFollowLinks(File container, File content) throws IOException {
        return DKUFileUtils.isWithinFollowLinks(container, content, true);
    }

    private static boolean isWithin(File container, File content, boolean allowEqualPaths) {
        Path parent = container.toPath().toAbsolutePath().normalize();
        Path child = content.toPath().toAbsolutePath().normalize();
        return Objects.equals(child, parent) ? allowEqualPaths : child.startsWith(parent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isWithinFollowLinks(File container, File content, boolean allowEqualPaths) throws IOException {
        boolean bl;
        Path child;
        Path parent;
        block6: {
            if (container.exists()) {
                parent = container.toPath().toRealPath(new LinkOption[0]);
                if (content.exists()) {
                    child = content.toPath().toRealPath(new LinkOption[0]);
                    break block6;
                } else {
                    File last;
                    for (last = content.getParentFile(); last != null && !last.exists(); last = last.getParentFile()) {
                    }
                    if (last != null) return DKUFileUtils.isWithinFollowLinks(container, last, true);
                    return false;
                }
            }
            if (content.exists()) {
                return false;
            }
            parent = container.getCanonicalFile().toPath();
            child = content.getCanonicalFile().toPath();
        }
        if (Objects.equals(child, parent)) {
            bl = allowEqualPaths;
            return bl;
        }
        bl = child.startsWith(parent);
        return bl;
    }

    public static File getWithin(File parent, String ... children) {
        return DKUFileUtils.getWithin(parent, false, false, children);
    }

    public static File getWithinFollowLink(File parent, String ... children) {
        return DKUFileUtils.getWithin(parent, false, true, children);
    }

    public static File getWithinOrSame(File parent, String ... children) {
        return DKUFileUtils.getWithin(parent, true, false, children);
    }

    private static File getWithin(File parent, Boolean sameAllowed, boolean followLink, String ... children) {
        File file = parent;
        for (String child : children) {
            File c = new File(file, child);
            try {
                if (followLink && !DKUFileUtils.isWithinFollowLinks(file, c, sameAllowed) || !followLink && !DKUFileUtils.isWithin(file, c, sameAllowed)) {
                    throw new IllegalArgumentException("Incorrect path: " + c.getCanonicalPath());
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Incorrect path: " + c.getAbsolutePath(), e);
            }
            file = c;
        }
        return file;
    }

    public static boolean exists(File parent, String ... children) {
        File file = parent;
        if (children.length < 1) {
            return file.exists();
        }
        for (String child : children) {
            File c = new File(file, child);
            try {
                if (!c.exists() || !DKUFileUtils.isWithin(file, c)) {
                    return false;
                }
                file = c;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void checkNoPossibleEscape(String str, String name) {
        if (StringUtils.isNotBlank((String)str) && (str.startsWith("..") || str.contains("/.."))) {
            throw new IllegalArgumentException("The field '" + name + "' is contains a '..'");
        }
    }

    public static Collection<File> listSubfoldersOf(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!root.isDirectory()) {
            return ret;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File sub : files) {
                if (!sub.isDirectory()) continue;
                ret.add(sub);
            }
        }
        ret.sort(Comparator.comparing(File::getName));
        return ret;
    }

    public static Collection<File> listSubfoldersContainingFile(File root, String filename) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!root.isDirectory()) {
            return ret;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File sub : files) {
                File lookup;
                if (!sub.isDirectory() || !(lookup = new File(sub, filename)).isFile()) continue;
                ret.add(sub);
            }
        }
        ret.sort(Comparator.comparing(File::getName));
        return ret;
    }

    public static FilePreview preview(File file) throws Exception {
        FilePreview preview = new FilePreview();
        preview.contentType = DKUtils.probeContentTypeWithFallback(file);
        boolean isText = DKUtils.isTextLikeMimeType(preview.contentType);
        try (FileInputStream itemStream = new FileInputStream(file);){
            Charset[] charsets;
            byte[] readBytes = new byte[65536];
            int readFromStream = ((InputStream)itemStream).read(readBytes);
            ByteBuffer buffer = readFromStream > 0 ? ByteBuffer.wrap(readBytes, 0, readFromStream) : ByteBuffer.allocate(0);
            boolean hasMoreBytes = readFromStream > 0 && file.length() > (long)readFromStream;
            for (Charset charset : charsets = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1}) {
                logger.info((Object)("Trying to get sample with charset " + charset.name()));
                CharsetDecoder cd = charset.newDecoder();
                cd.onMalformedInput(CodingErrorAction.REPORT);
                cd.onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer decoded = CharBuffer.allocate(131072);
                buffer.rewind();
                CoderResult decoding = cd.decode(buffer, decoded, !hasMoreBytes);
                if (decoding.isError()) continue;
                decoded.flip();
                String previewHead = decoded.toString();
                if (DKUFileUtils.hasStrangeCharacters(previewHead) || !isText && DKUFileUtils.hasLongLine(previewHead)) continue;
                preview.type = GenericFileType.TEXT;
                preview.hasMore = hasMoreBytes;
                preview.charsetUsed = charset.name();
                preview.head = previewHead;
                FilePreview filePreview = preview;
                return filePreview;
            }
        }
        preview.type = DKUFileUtils.getGenericType(preview.contentType);
        return preview;
    }

    private static GenericFileType getGenericType(String contentType) {
        if (contentType != null) {
            if (contentType.startsWith("image/")) {
                return GenericFileType.IMAGE;
            }
            if (archiveMimeTypePattern.matcher(contentType).matches()) {
                return GenericFileType.ARCHIVE;
            }
            if ("application/pdf".equals(contentType) || "application/x-pdf".equals(contentType)) {
                return GenericFileType.PDF;
            }
        }
        return GenericFileType.BINARY;
    }

    private static boolean hasStrangeCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\b') continue;
            return true;
        }
        return false;
    }

    private static boolean hasLongLine(String s) {
        String[] lines;
        for (String line : lines = s.split("\n")) {
            if (line.length() <= 3072) continue;
            return true;
        }
        return false;
    }

    public static BasicFileAttributes getAttributesNoFollowLinksOrNull(File file) {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to read file attributes", (Throwable)e);
            return null;
        }
        return attributes;
    }

    public static boolean isFileOrDirectory(File file) {
        BasicFileAttributes attributes = DKUFileUtils.getAttributesNoFollowLinksOrNull(file);
        return attributes != null && (attributes.isRegularFile() || attributes.isDirectory());
    }

    public static boolean isDirectory(File file) {
        BasicFileAttributes attributes = DKUFileUtils.getAttributesNoFollowLinksOrNull(file);
        return attributes != null && attributes.isDirectory();
    }

    public static boolean isFile(File file) {
        BasicFileAttributes attributes = DKUFileUtils.getAttributesNoFollowLinksOrNull(file);
        return attributes != null && attributes.isRegularFile();
    }

    public static void copyDirectory(File from, File to) throws IOException {
        DKUFileUtils.copyDirectory(from, to, EnumSet.noneOf(CopyDirectoryFlags.class), new java.io.FileFilter[0]);
    }

    public static void copyDirectory(File from, File to, EnumSet<CopyDirectoryFlags> flags, java.io.FileFilter ... filters) throws IOException {
        java.io.FileFilter filter = DKUFileUtils::isFileOrDirectory;
        for (java.io.FileFilter ff : filters) {
            filter = DKUFileUtils.andFilter(filter, ff);
        }
        if (flags.contains((Object)CopyDirectoryFlags.ExcludeGitFolder)) {
            filter = DKUFileUtils.andFilter(filter, f -> f.isFile() || f.isDirectory() && !f.getName().equals(".git"));
        }
        if (flags.contains((Object)CopyDirectoryFlags.NoReplacing)) {
            filter = DKUFileUtils.andFilter(filter, f -> {
                Path relative = from.toPath().relativize(f.toPath());
                Path destPath = to.toPath().resolve(relative);
                return !destPath.toFile().exists();
            });
        }
        boolean preserveFileDate = !flags.contains((Object)CopyDirectoryFlags.NoPreserveFileDate);
        FileUtils.copyDirectory((File)from, (File)to, (java.io.FileFilter)filter, (boolean)preserveFileDate);
        if (DKUtils.isOsWindows()) {
            WindowsUtils.recursivelyRemoveReadOnlyFlag(to);
        }
    }

    private static java.io.FileFilter andFilter(java.io.FileFilter a, java.io.FileFilter b) {
        return f -> a.accept(f) && b.accept(f);
    }

    /*
     * Exception decompiling
     */
    public static void unzipInputStream(File targetDirectory, InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getWithAutoDecompress(File base) {
        if (base.getName().endsWith(".gz")) {
            return base;
        }
        File gzFile = new File(base.getParentFile(), base.getName() + ".gz");
        if (gzFile.isFile() && !base.isFile()) {
            return gzFile;
        }
        return base;
    }

    public static void gzCompress(File f) throws IOException {
        File gzFile = new File(f.getParentFile(), f.getName() + ".gz");
        try (OutputStream gzStream = DKUFileUtils.writeWithAutoCompress(gzFile, false);
             FileInputStream fis = new FileInputStream(f);){
            IOUtils.copyLarge((InputStream)fis, (OutputStream)gzStream);
        }
        DKUFileUtils.forceDelete(f);
    }

    public static InputStream readWithAutoDecompress(File f) throws FileNotFoundException, IOException {
        if (f.getName().endsWith(".gz")) {
            return new GZIPInputStream(new FileInputStream(f));
        }
        return new FileInputStream(f);
    }

    public static OutputStream writeWithAutoCompress(File f, boolean append) throws FileNotFoundException, IOException {
        if (f.getName().endsWith(".gz")) {
            return new GZIPOutputStream(new FileOutputStream(f, append));
        }
        return new FileOutputStream(f, append);
    }

    public static void compressAndKeepLastFilesUpToSize(File directory, String prefix, String suffix, long purgeThreshold, String keepUncompressed) throws IOException {
        File[] logGzFilesToPurge;
        String filterException = keepUncompressed != null ? keepUncompressed : "///////";
        File[] logFilesToCompress = directory.listFiles(f -> f.isFile() && !filterException.equals(f.getName()) && f.getName().startsWith(prefix) && f.getName().endsWith(suffix));
        if (logFilesToCompress != null) {
            for (File f2 : logFilesToCompress) {
                logger.info((Object)("Compress " + f2.getName()));
                DKUFileUtils.gzCompress(f2);
            }
        }
        if ((logGzFilesToPurge = directory.listFiles(f -> f.isFile() && f.getName().startsWith(prefix) && f.getName().endsWith(suffix + ".gz"))) != null) {
            Arrays.sort(logGzFilesToPurge, (a, b) -> -a.getName().compareTo(b.getName()));
            long total = 0L;
            long purged = 0L;
            for (File f3 : logGzFilesToPurge) {
                long s = f3.length();
                if (total >= purgeThreshold) {
                    logger.info((Object)("Purging " + f3.getName() + " (total " + total + " >= " + purgeThreshold + ")"));
                    DKUFileUtils.forceDelete(f3);
                    purged += s;
                }
                total += s;
            }
            logger.info((Object)("Removed " + purged + " of old logs"));
        }
    }

    public static void keepLastNItemsInFolder(File directory, int n) throws IOException {
        File[] items = directory.listFiles();
        if (items == null) {
            return;
        }
        logger.info((Object)("Cleaning up folder " + String.valueOf(directory) + ", keeping only last " + n + "/" + items.length));
        Set toKeep = Arrays.stream(items).sorted((i1, i2) -> i1.lastModified() > i2.lastModified() ? -1 : 1).limit(n).map(f -> f.getName()).collect(Collectors.toSet());
        for (File item : items) {
            if (toKeep.contains(item.getName())) continue;
            logger.debug((Object)("Deleting old: " + String.valueOf(item)));
            try {
                DKUFileUtils.forceDelete(item);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to delete " + String.valueOf(item)), (Throwable)e);
            }
        }
    }

    public static String digestDirectoryMD5(File base) throws IOException {
        if (null == base || !base.exists() || !base.isDirectory()) {
            return null;
        }
        MessageDigest digest = DigestUtils.getMd5Digest();
        List<File> files = DKUFileUtils.recursiveListFiles(base);
        for (File f : files) {
            digest.update(Files.readAllBytes(f.toPath()));
        }
        return DigestUtils.md5Hex((byte[])digest.digest());
    }

    public static Path forceCreateSymbolicLink(Path link, Path target) throws IOException {
        if (Files.exists(link, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(link);
        }
        return Files.createSymbolicLink(link, target, new FileAttribute[0]);
    }

    private static File lockFileForFile(File file) {
        return new File(file.toString() + ".lock");
    }

    public static boolean isLockFile(File file) {
        return file.toString().endsWith(".lock");
    }

    public static void lockFile(File file) throws IOException {
        File lockFile = DKUFileUtils.lockFileForFile(file);
        Files.writeString(lockFile.toPath(), (CharSequence)String.valueOf(ProcessHandle.current().pid()), StandardOpenOption.CREATE_NEW);
        lockFile.deleteOnExit();
    }

    public static void unlockFile(File file) throws IOException {
        File lockFile = DKUFileUtils.lockFileForFile(file);
        if (lockFile.exists()) {
            DKUFileUtils.delete(lockFile);
        }
    }

    public static boolean isFileLocked(File file) {
        File lockFile = DKUFileUtils.lockFileForFile(file);
        if (!lockFile.exists()) {
            return false;
        }
        long pid = 0L;
        try {
            String content = DKUFileUtils.readFileToStringUTF8OrEmpty(lockFile);
            if (content.isEmpty()) {
                DKUFileUtils.delete(lockFile);
                return false;
            }
            pid = Long.parseLong(content);
        }
        catch (IOException | NumberFormatException e) {
            lockFile.delete();
            return false;
        }
        try {
            Optional<ProcessHandle> processHandleOpt = ProcessHandle.of(pid);
            if (processHandleOpt.isEmpty() || !processHandleOpt.get().isAlive()) {
                DKUFileUtils.delete(lockFile);
                return false;
            }
        }
        catch (IOException e) {
            lockFile.delete();
            return false;
        }
        return true;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FileFilter implements java.io.FileFilter
    {
        FILES{

            @Override
            public boolean accept(File f) {
                return !f.isDirectory();
            }
        }
        ,
        DIRECTORIES{

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        }
        ,
        FILES_AND_DIRECTORIES{

            @Override
            public boolean accept(File f) {
                return true;
            }
        };

    }

    public static class FilePreview {
        public String itemPath;
        public GenericFileType type;
        public String head;
        public String charsetUsed;
        public String contentType;
        public boolean hasMore;
    }

    public static enum GenericFileType {
        TEXT,
        IMAGE,
        BINARY,
        PDF,
        ARCHIVE;

    }

    public static enum CopyDirectoryFlags {
        NoPreserveFileDate,
        ExcludeGitFolder,
        NoReplacing;

    }
}

