/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.exceptions.PivotMissingColumnException;
import com.dataiku.dip.exceptions.PivotMissingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;

public class ErrorContext {
    static ThreadLocal<List<String>> chunks = new ThreadLocal();

    public static ACNDC pushWithNDC(String chunk) {
        ErrorContext.push(chunk);
        NDC.push((String)chunk);
        return new ACNDC();
    }

    public static void popWithNDC() {
        ErrorContext.pop();
        NDC.pop();
    }

    public static void push(String chunk) {
        if (chunks.get() == null) {
            chunks.set(new ArrayList());
        }
        chunks.get().add(chunk);
    }

    public static void pop() {
        if (chunks.get() == null) {
            chunks.set(new ArrayList());
        }
        if (chunks.get().size() > 0) {
            chunks.get().remove(chunks.get().size() - 1);
        }
    }

    public static void clear() {
        if (chunks.get() != null) {
            chunks.get().clear();
        }
    }

    public static String format() {
        if (chunks.get() == null) {
            chunks.set(new ArrayList());
        }
        StringBuilder sb = new StringBuilder();
        for (String chunk : chunks.get()) {
            sb.append("in ").append(chunk).append(": ");
        }
        return sb.toString();
    }

    public static void checkNotEmpty(String obj, String details) {
        if (obj == null) {
            throw ErrorContext.iae("Unexpected null value for " + details);
        }
        if (obj.length() == 0) {
            throw ErrorContext.iae("Unexpected empty value for " + details);
        }
    }

    public static void checkNotEmpty(Collection<?> col, String message) {
        if (col == null || col.size() == 0) {
            throw ErrorContext.iae(message);
        }
    }

    public static void checkNotEmpty(int[] arr, String message) {
        if (arr == null || arr.length == 0) {
            throw ErrorContext.iae(message);
        }
    }

    public static void checkNotEmpty(double[] arr, String message) {
        if (arr == null || arr.length == 0) {
            throw ErrorContext.iae(message);
        }
    }

    public static void checkNotEmpty(float[] arr, String message) {
        if (arr == null || arr.length == 0) {
            throw ErrorContext.iae(message);
        }
    }

    public static void checkNotEmptyOrBlank(String obj, String details) {
        ErrorContext.checkNotEmpty(obj, details);
        if (StringUtils.isBlank((String)obj)) {
            throw ErrorContext.iae("Unexpected blank value for: " + details);
        }
    }

    public static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw ErrorContext.iae("Unexpected null");
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, String message) {
        if (obj == null) {
            throw ErrorContext.iae(message);
        }
        return obj;
    }

    public static void check(boolean x, String message) {
        if (!x) {
            throw ErrorContext.iae(message);
        }
    }

    public static IllegalArgumentException iae(String message) {
        return new IllegalArgumentException(ErrorContext.format() + message);
    }

    public static IllegalArgumentException iae(String message, Exception cause) {
        return new IllegalArgumentException(ErrorContext.format() + message, cause);
    }

    public static IllegalArgumentException iaef(String pattern, Object firstArgument, Object ... otherArguments) {
        return new IllegalArgumentException(ErrorContext.format() + String.format(pattern, ErrorContext.concat(firstArgument, otherArguments)));
    }

    public static PivotMissingColumnException pmce(String columnName, PivotMissingContext pmc) {
        return new PivotMissingColumnException(columnName, pmc);
    }

    public static IllegalConfigurationException ice(String message) {
        return new IllegalConfigurationException(ErrorContext.format() + message);
    }

    public static IllegalConfigurationException icef(String pattern, Object firstArguments, Object ... otherArguments) {
        return new IllegalConfigurationException(ErrorContext.format() + String.format(pattern, ErrorContext.concat(firstArguments, otherArguments)));
    }

    public static IllegalStateException ise(String message) {
        return new IllegalStateException(ErrorContext.format() + message);
    }

    public static IllegalStateException isef(String pattern, Object firstArguments, Object ... otherArguments) {
        return new IllegalStateException(ErrorContext.format() + String.format(pattern, ErrorContext.concat(firstArguments, otherArguments)));
    }

    public static IOException ioe(String message) {
        return new IOException(ErrorContext.format() + message);
    }

    public static IOException ioef(String pattern, Object firstArguments, Object ... otherArguments) {
        return new IOException(ErrorContext.format() + String.format(pattern, ErrorContext.concat(firstArguments, otherArguments)));
    }

    private static Object[] concat(Object firstArgument, Object[] otherArguments) {
        Object[] arguments = new Object[1 + otherArguments.length];
        arguments[0] = firstArgument;
        System.arraycopy(otherArguments, 0, arguments, 1, otherArguments.length);
        return arguments;
    }

    public static class ACNDC
    implements AutoCloseable {
        @Override
        public void close() {
            ErrorContext.popWithNDC();
        }
    }
}

