/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;

public class StringTransmogrifier {
    private final Set<String> assigned = new HashSet<String>();
    private final String delimiter;
    private final int offset;
    private final boolean reuseIndexSuffixIfExists;
    private Pattern nameContainsIndexPattern;
    private boolean alwaysAddSuffix;
    private final int maxLengthOfModifiedStrings;

    public StringTransmogrifier() {
        this("_", 0);
    }

    public StringTransmogrifier(String delimiter) {
        this(delimiter, 0);
    }

    public StringTransmogrifier(String delimiter, int offset) {
        this(delimiter, offset, 0, false, false);
    }

    public StringTransmogrifier(boolean reuseIndexSuffixIfExists) {
        this("_", 0, reuseIndexSuffixIfExists);
    }

    public StringTransmogrifier(String delimiter, int offset, boolean reuseIndexSuffixIfExists) {
        this(delimiter, offset, 0, reuseIndexSuffixIfExists, false);
    }

    public StringTransmogrifier(String delimiter, int offset, Integer maxLengthOfModifiedStrings) {
        this(delimiter, offset, maxLengthOfModifiedStrings, false, false);
    }

    public StringTransmogrifier(String delimiter, int offset, Integer maxLengthOfModifiedStrings, boolean reuseIndexSuffixIfExists, boolean alwaysAddSuffix) {
        this.offset = offset;
        this.delimiter = delimiter;
        this.maxLengthOfModifiedStrings = maxLengthOfModifiedStrings == null ? 0 : maxLengthOfModifiedStrings;
        this.reuseIndexSuffixIfExists = reuseIndexSuffixIfExists;
        this.alwaysAddSuffix = alwaysAddSuffix;
        if (reuseIndexSuffixIfExists) {
            this.nameContainsIndexPattern = Pattern.compile("^(.*)" + Pattern.quote(delimiter) + "([\\d]+)$");
        }
    }

    public void addAlreadyTransmogrified(String in) {
        if (this.assigned.contains(in)) {
            throw new IllegalArgumentException("Input string " + in + " is already in the transmogrifier");
        }
        this.assigned.add(in);
    }

    public void addAlreadyTransmogrifiedAcceptDupes(String in) {
        this.assigned.add(in);
    }

    public void addAllAlreadyTransmogrifiedAcceptDupes(Collection<String> in) {
        this.assigned.addAll(in);
    }

    public String transmogrify(@Nonnull String input) {
        String indexInName;
        Matcher matcher;
        String newBaseName = input;
        int i = this.offset;
        if (this.reuseIndexSuffixIfExists && (matcher = this.nameContainsIndexPattern.matcher(input)).find() && (indexInName = matcher.group(2)).length() < 10) {
            newBaseName = matcher.group(1);
            i = Integer.parseInt(indexInName);
        }
        Object cur = input;
        if (this.alwaysAddSuffix) {
            cur = newBaseName + this.delimiter + i;
        }
        while (this.assigned.contains(cur)) {
            if (this.maxLengthOfModifiedStrings < 1) {
                cur = newBaseName + this.delimiter + ++i;
                continue;
            }
            cur = this.shortenInputIfNecessary(input, ++i);
        }
        this.assigned.add((String)cur);
        return cur;
    }

    private String shortenInputIfNecessary(String input, int counter) {
        String newValue = input + this.delimiter + counter;
        if (newValue.length() <= this.maxLengthOfModifiedStrings) {
            return newValue;
        }
        String suffix = this.delimiter + counter;
        int inputLengthToKeep = this.maxLengthOfModifiedStrings - suffix.length();
        if (inputLengthToKeep < 1) {
            throw new IllegalArgumentException("Max length is too short, unable to generate unique string");
        }
        return input.substring(0, inputLengthToKeep) + suffix;
    }

    public static String shortenKeepUnicity(String x, int maxLength) {
        if (x == null || x.length() < maxLength) {
            return x;
        }
        int hashLength = 8;
        if (maxLength < 1 + hashLength) {
            throw new UnsupportedOperationException("Cannot trim to less that " + (1 + hashLength) + " chars");
        }
        String m = DigestUtils.md5Hex((String)x).substring(0, hashLength);
        return x.substring(0, maxLength - hashLength) + m;
    }
}

