import pandas as pd

from dataiku.base.utils import package_is_at_least


def is_datetime64tz_dtype(dtype):
    if package_is_at_least(pd, "2.1.0"):
        # Deprecation warning introduced in https://github.com/pandas-dev/pandas/pull/52607
        return isinstance(dtype, pd.DatetimeTZDtype)
    else:
        from pandas.api.types import is_datetime64tz_dtype
        return is_datetime64tz_dtype(dtype)
