(function () {
  "use strict";

  const requestCenter = {
    templateUrl: "/static/dataiku/inbox/components/request-center/request-center.component.html",
    controller: function ($scope, RequestCenterService, TopNav, Notification) {
      const ALL_STATUS = ["APPROVED", "PENDING", "REJECTED"];

      this.users = null;
      this.projectNames = null;

      this.facets = {"STATUS": ["PENDING"]};
      this.selectedPage = 0;
      this.pageSize = 50;
      this.pluginsList = [];
      TopNav.setLocation(TopNav.DSS_HOME, "inbox.requests");

      RequestCenterService.listUsersDisplayNames()
        .then((data) => {
          this.users = data;
        }, setErrorInScope.bind($scope));

        RequestCenterService.listProjectsNames()
        .then((data) => {
            this.projectNames = data;
        }, setErrorInScope.bind($scope));

        RequestCenterService.listApplicationsNames().
        then((data) => {
            this.appNames = data;
        }, setErrorInScope.bind($scope));


        // always display the status facets, even if the count is 0
        const addStatusFacet = (aggregations) => {
            const statusBucket = aggregations["STATUS"];
            for (const status of ALL_STATUS) {
                if (!statusBucket.find(facet => facet.key === status)) {
                    statusBucket.push({key: status, value: 0});
                }
            }
        };

        // compute the total number of result (not accounting for pagination) using the status aggregations
        const computeTotalRows = () => {
            const byStatus = this.aggregations['STATUS'] || [];
            const selectedStatusFacet = this.facets["STATUS"].length
                ? this.facets["STATUS"]
                : ALL_STATUS;
            return byStatus
                .filter(agg => selectedStatusFacet.includes(agg.key))
                .reduce((sum, {value}) => value + sum, 0);
        }

        const listRequests = () => {
            RequestCenterService.search(this.facets, this.pageSize * this.selectedPage, this.pageSize)
            .then((data) => {
                this.listItems = data.results;
                this.aggregations = data.aggregations;
                addStatusFacet(this.aggregations);
                this.totalRows = computeTotalRows();
            }, setErrorInScope.bind($scope));
        }
        listRequests();

      const updatePluginsList = () => {
        RequestCenterService.listPlugins().
        then((data) => {
            this.pluginsList = data;
        }, setErrorInScope.bind($scope));
      }
      updatePluginsList();

      this.updateFilter = function($event) {
        this.selectedPage = 0;
        this.facets = $event.selectedFacets;
        listRequests();
      }

      this.updateRequest = function(){
        listRequests();
      }

      this.selectPage = function($event){
        this.selectedPage = $event.pageIndex;
        this.updateRequest();
      }

      const updatePendingRequestsNotificationUnsubscribe = Notification.registerEvent("update-pending-requests", () => {
          if (this.selectedPage == 0) {
              this.updateRequest();
          }
      });
      $scope.$on('$destroy', updatePendingRequestsNotificationUnsubscribe);
    },
  };

  angular.module("dataiku.inbox").component("requestCenter", requestCenter);
})();
