(function(){
    'use strict';

    const requestProfileUpgrade = {
        bindings: {
            request: '<',
            requester: '<',
            closer: '<',
            onChange: '&'
        },
        templateUrl: 'static/dataiku/inbox/components/request-center/request/request-profile-upgrade/request-profile-upgrade.component.html',
        controller: function($rootScope) {
            this.callback = () => {
                const response = {selectedUserProfile: this.selectedUserProfile, type: 'ProfileUpgradeResponse'}; // keep type in sync with backend
                this.onChange({response});
            }
            this.$onInit = () => {
                this.profileOptions = $rootScope.appConfig.licensing.userProfiles.filter(profile => profile !== "NONE");
                this.selectedUserProfile = this.profileOptions[0];
                this.callback();
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestProfileUpgrade', requestProfileUpgrade);
})();
