(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/view.js
     */
    app.constant('TileLoadingState', {
        // Insight has registered itself and is waiting for the dashboard/insight-preview component to load it.
        WAITING: 0,

        // Dashboard/insight-preview component has called the promise in loadPromises map and is waiting for the promise to be resolved.
        LOADING: 1,

        // Loading promise has been resolved
        LOADED: 2,

        // Loading promise has been resolved and any additional asynchronous work has also completed.
        COMPLETE: 3,

        // Insight is waiting for the dashboard/insight-preview component to reload it.
        WAITING_FOR_RELOAD: 4
    });
})();
