(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.constant('EdaInsightHandler', {
        name: 'Eda',
        nameForTileParams: 'Eda',
        desc: 'Eda',
        i18nNameKey: 'INSIGHTS.EDA.NAME',
        i18nTileParamsNameKey: 'INSIGHTS.EDA.TILE_PARAMS_NAME',
        i18nDescKey: 'INSIGHTS.EDA.DESC',
        icon: 'icon-dku-statistics',
        color: '',

        getSourceId: function(insight) {
            return insight.params.dataSpec.inputDatasetSmartName;
        },
        getSourceType: function() {
            return 'DATASET';
        },
        hasOptions: false,
        hasEditTab: true,
        defaultTileSize: [],
        defaultTileDimensions: [30, 15]
    });

    app.directive('edaInsightTile', function(TileLoadingState) {
        return {
            templateUrl: '/templates/dashboards/insights/eda/eda_tile.html',
            scope: {
                insight: '=',
                tile: '=',
                hook: '='
            },
            link: function($scope) {
                $scope.loading = false;
                $scope.loaded = false;
                $scope.error = null;

                $scope.load = function(resolve) {
                    $scope.loading = false;
                    $scope.loaded = true;
                    $scope.error = null;
                    if ($scope.hook && $scope.hook.isErrorMap) {
                        $scope.hook.isErrorMap[$scope.tile.$tileId] = false;
                    }
                    if (typeof (resolve) === 'function') {
                        resolve();
                    }
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;

                if ($scope.tile.autoLoad) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
                }

                $scope.tile.$showEdaSamplingBadge = false;
                $scope.displaySamplingBadge = (show) => {
                    $scope.tile.$showEdaSamplingBadge = show;
                };

                $scope.tile.$samplingSummaryMessage =
                    'Data sampling can be misrepresentative.<br>' +
                    'You can change the sampling settings in the edit view.';
            }
        };
    });

    app.controller('EdaInsightViewCommon', function($scope, DataikuAPI) {
        $scope.saveInsight = function({ card, result, dataSpec, isSampleWholeDataset }) {
            const newInsight = _.cloneDeep($scope.insight);
            newInsight.params.card = card;
            newInsight.params.dataSpec = dataSpec;
            newInsight.params.isSampleWholeDataset = isSampleWholeDataset;

            DataikuAPI.dashboards.insights.save(newInsight, undefined, JSON.stringify(result))
                .error(setErrorInScope.bind($scope))
                .success(() => $scope.insight = newInsight);
        };
    });

    app.directive('edaInsightView', function($controller) {
        return {
            templateUrl: '/templates/dashboards/insights/eda/eda_view.html',
            scope: true,
            link: function($scope) {
                $controller('EdaInsightViewCommon', { $scope });
            }
        };
    });

    app.directive('edaInsightEdit', function($controller) {
        return {
            templateUrl: '/templates/dashboards/insights/eda/eda_edit.html',
            scope: {
                insight: '='
            },
            link: function($scope) {
                $controller('EdaInsightViewCommon', { $scope });
            }
        };
    });
})();
