(function(){
    'use strict';

    const app = angular.module('dataiku.ml.explainability', []);

    app.constant('epochShift', 2208988800); // 1900-01-01 (py models) to 1970-01-01 (mllib models)

    app.component('explanationParams', {
        bindings: {
            params: '=',
            onParamsChange: '&'
        },
        templateUrl: '/templates/ml/prediction-model/explanation-params-form.html',
        controller: function($scope) {
            const $ctrl = this;
            $ctrl.localParams = {};

            $ctrl.applyChanges = () => {
                angular.copy($ctrl.localParams, $ctrl.params);
                $ctrl.onParamsChange && $ctrl.onParamsChange();
            };

            $ctrl.resetParams = () => {
                angular.copy($ctrl.params, $ctrl.localParams);
            };

            $scope.$watch('$ctrl.params', $ctrl.resetParams);
        }
    });

    app.component('computationParams', {
        bindings: {
            params: '=',
            hideNbJobs: '<',
            sampleSizeLabel: '<',
            sampleSizeHelp: '<',
            lastRandomState: '<',
            lastSampleSize: '<'
        },
        templateUrl: '/templates/ml/prediction-model/computation-params-form.html',
        controller: function($scope) {
            const $ctrl = this;
            $ctrl.localParams = {};

            $ctrl.$onInit = () => {
                $ctrl.sampleSizeLabel = $ctrl.sampleSizeLabel || 'Sample size';
                $ctrl.sampleSizeHelp = $ctrl.sampleSizeHelp || 'Number of records of the dataset to use for the computation';
            };

            $ctrl.applyChanges = () => {
                angular.copy($ctrl.localParams, $ctrl.params);
            };

            $ctrl.resetParams = () => {
                angular.copy($ctrl.params, $ctrl.localParams);
            };

            $scope.$watch('$ctrl.params', $ctrl.resetParams);
        }
    });
})();
