(function(){
'use strict';

    const app = angular.module('dataiku.folder_edit', []);

    // Global definition for text used in menus
    let moveText = 'Move...';
    let duplicateText = 'Duplicate';
    let renameText = 'Rename...';
    let deleteText = 'Delete...';
    let createFileText = 'Create file...';
    let createFolderText = 'Create folder...';
    let uploadText = 'Upload file...';
    let downloadText = 'Download file...';
    let commitText = 'Commit and push...';
    let pullText = 'Reset from remote HEAD';
    let editText = 'Edit Git reference...';
    let unlinkText = 'Unlink remote repository...';
    let closeOtherTabText = 'Close other tabs';
    let customizeEditorSettingsText = 'Customize editor settings';
    let reloadLocalFileText = 'Reload local files';
    let manageReferenceText = 'Manage repositories...';
    let importFromGitText = 'Import from Git...';
    let updateAllText = 'Reset all from remote HEAD...';
    let commitAllText = 'Commit and push all...';
    let editInCodeStudioText = 'Edit in Code Studio...';

    // Global definition for icon used in menus
    let moveIcon = '<i class="icon-fixed-width dku-icon-arrow-right-16 text-icon"> </i>';
    let duplicateIcon = '<i class="icon-fixed-width dku-icon-copy-16 text-icon"> </i>';
    let renameIcon = '<i class="icon-fixed-width dku-icon-edit-note-16 text-icon"> </i>';
    let deleteIcon = '<i class="icon-fixed-width dku-icon-trash-16 text-icon"> </i>';
    let createFileIcon = '<i class="icon-fixed-width dku-icon-file-16 text-icon"> </i>';
    let createFolderIcon = '<i class="icon-fixed-width dku-icon-folder-open-16 text-icon"> </i>';
    let uploadIcon = '<i class="icon-fixed-width dku-icon-file-upload-16 text-icon"> </i>';
    let downloadIcon = '<i class="icon-fixed-width dku-icon-file-download-16 text-icon"> </i>';
    let commitIcon = '<i class="icon-fixed-width dku-icon-git-push-16 text-icon"> </i>';
    let pullIcon = '<i class="icon-fixed-width dku-icon-git-pull-16 text-icon"> </i>';
    let editIcon = '<i class="icon-fixed-width dku-icon-git-edit-16 text-icon"> </i>';
    let editFileIcon = '<i class="icon-fixed-width dku-icon-edit-16 text-icon"> </i>';
    let unlinkIcon = '<i class="icon-fixed-width dku-icon-unlink-16 text-icon"> </i>';
    let closeOtherTabIcon = '<i class="icon-fixed-width dku-icon-dismiss-16 text-icon"> </i>';
    let customizeEditorSettingsIcon = '<i class="icon-fixed-width dku-icon-gear-16 text-icon"> </i>';
    let reloadLocalFileIcon = '<i class="icon-fixed-width dku-icon-arrow-circular-16 text-icon"> </i>';
    let manageReferenceIcon = editIcon;
    let importFromGitIcon = '<i class="icon-fixed-width dku-icon-git-import-16 text-icon"> </i>';
    let updateAllIcon = pullIcon;
    let commitAllIcon = commitIcon;

//' +  + '
    /**
     * @ngdoc directive
     * @name zoneEditCallbacks
     * @description
     *   This directive is composed on the scope above FolderEditController.
     *   It is responsible for setting up the callbacks needed to get/set/list
     *   files in a zone of the admin section.
     */
    app.directive('zoneEditCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    var zone = attrs.zone;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.admin.folderEdit.listContents(zone);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.admin.folderEdit.getContent(zone, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return '/dip/api/admin/folder-edition/preview-image?type=' + zone + '&path=' + encodeURIComponent(content.path) + '&contentType=' + encodeURIComponent(content.mimeType);
                        },
                        set: function(content) {
                            return DataikuAPI.admin.folderEdit.setContent(zone, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.admin.folderEdit.validate(zone, contentMap);
                        // },
                        setAll: function(contentMap) {
                            return DataikuAPI.admin.folderEdit.setContentMultiple(zone, contentMap);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.admin.folderEdit.createContent(zone, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.admin.folderEdit.deleteContent(zone, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.admin.folderEdit.decompressContent(zone, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.admin.folderEdit.renameContent(zone, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.admin.folderEdit.checkUploadContent(zone, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.admin.folderEdit.uploadContent(zone, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.admin.folderEdit.moveContent(zone, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.admin.folderEdit.copyContent(zone, content.path);
                        },
                        downloadURL: function(content) {
                            return '/dip/api/admin/folder-edition/download-content?type=' + zone + '&path=' + encodeURIComponent(content.path);
                        }
                    };
                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.rootDescription = attrs.rootDescription || '[' + zone + ']';
                    $scope.description =  $state.includes('libedition.libpython') ? 'lib-python' : $state.includes('libedition.libr') ? 'lib-r' : 'local-static';
                    $scope.headerDescription = $state.includes('libedition.localstatic') ? "Web Resources Content" : "Library Content";
                    $scope.localStorageId = $state.includes('libedition.libpython') ? 'lib-python' : $state.includes('libedition.libr') ? 'lib-r' : 'local-static';
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name projectZoneEditCallbacks
     * @description
     *   same as zoneEditCallbacks but for the folders inside a project
     */
    app.directive('projectZoneEditCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, FutureProgressModal, DKUtils, CodeStudiosService) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    var zone = attrs.zone;
                    var projectKey = $stateParams.projectKey;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.projects.folderEdit.listContents(projectKey, zone);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.projects.folderEdit.getContent(projectKey, zone, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return DataikuAPI.projects.folderEdit.previewImageURL(projectKey, zone, content.path, content.mimeType);
                        },
                        set: function(content, gitLib) {
                            $scope.folderEditCallbacks.setDirty(gitLib);
                            return DataikuAPI.projects.folderEdit.setContent(projectKey, zone, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.projects.folderEdit.validate(projectKey, zone, contentMap);
                        // },
                        setAll: function(contentMap, gitLibs) {
                            DataikuAPI.projects.git.setAllDirty(projectKey, gitLibs);
                            return DataikuAPI.projects.folderEdit.setContentMultiple(projectKey, zone, contentMap);
                        },
                        setDirty: function(gitLib) {
                            if (gitLib && gitLib.length !== 0) {
                                DataikuAPI.projects.git.setDirty(projectKey, gitLib);
                            }
                        },
                        getDirty: function (gitLib) {
                            return DataikuAPI.projects.git.getDirty(projectKey, gitLib);
                        },
                        getAllDirty: function () {
                            return DataikuAPI.projects.git.getDirty(projectKey);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.projects.folderEdit.createContent(projectKey, zone, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.projects.folderEdit.deleteContent(projectKey, zone, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.projects.folderEdit.decompressContent(projectKey, zone, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.projects.folderEdit.renameContent(projectKey, zone, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.projects.folderEdit.checkUploadContent(projectKey, zone, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.projects.folderEdit.uploadContent(projectKey, zone, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.projects.folderEdit.moveContent(projectKey, zone, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.projects.folderEdit.copyContent(projectKey, zone, content.path);
                        },
                        downloadURL: function(content) {
                            return DataikuAPI.projects.folderEdit.downloadURL(projectKey, zone, content.path);
                        },
                        editInCodeStudio: function(content) {
                            return CodeStudiosService.editFileInCodeStudio($scope,'project_lib_versioned', content.path);
                        }
                    };

                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.description =  "lib";
                    $scope.headerDescription = $state.includes('projects.project.libedition.localstatic') ? "Web Resources Content" : "Library Content"
                    $scope.localStorageId = "lib" + "-" + projectKey;
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name resourcesProjectZoneEditCallbacks
     * @description
     *   same as zoneEditCallbacks but for the folders inside a project
     */
    app.directive('resourcesProjectZoneEditCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, FutureProgressModal, DKUtils, CodeStudiosService) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    var zone = attrs.zone;
                    var projectKey = $stateParams.projectKey;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.projects.resourcesFolderEdit.listContents(projectKey, zone);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.projects.resourcesFolderEdit.getContent(projectKey, zone, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.previewImageURL(projectKey, zone, content.path, content.mimeType);
                        },
                        set: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.setContent(projectKey, zone, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.projects.resourcesFolderEdit.validate(projectKey, zone, contentMap);
                        // },
                        setAll: function(contentMap) {
                            return DataikuAPI.projects.resourcesFolderEdit.setContentMultiple(projectKey, zone, contentMap);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.projects.resourcesFolderEdit.createContent(projectKey, zone, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.deleteContent(projectKey, zone, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.decompressContent(projectKey, zone, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.projects.resourcesFolderEdit.renameContent(projectKey, zone, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.projects.resourcesFolderEdit.checkUploadContent(projectKey, zone, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.projects.resourcesFolderEdit.uploadContent(projectKey, zone, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.projects.resourcesFolderEdit.moveContent(projectKey, zone, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.copyContent(projectKey, zone, content.path);
                        },
                        downloadURL: function(content) {
                            return DataikuAPI.projects.resourcesFolderEdit.downloadURL(projectKey, zone, content.path);
                        },
                        editInCodeStudio: function(content) {
                            return CodeStudiosService.editFileInCodeStudio($scope,'project_lib_resources', content.path);
                        }
                    };

                    $scope.isInProjectResources = true;
                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.description =  "lib";
                    $scope.headerDescription = $state.includes('projects.project.libedition.localstatic') ? "Web Resources Content" : "Library Content"
                    $scope.localStorageId = "lib" + "-" + projectKey;
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name codeStudioZoneEditCallbacks
     * @description
     *   same as zoneEditCallbacks but for the folders of a CodeStudio
     */
    app.directive('codeStudioZoneEditCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, FutureProgressModal, DKUtils, CodeStudiosService) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    var zone = attrs.zone;
                    var projectKey = $stateParams.projectKey;
                    var codeStudioObjectId = $stateParams.codeStudioObjectId;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.codeStudioObjects.folderEdit.listContents(projectKey, codeStudioObjectId, zone);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.codeStudioObjects.folderEdit.getContent(projectKey, codeStudioObjectId, zone, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return '/dip/api/code-studio-objects/folder-edition/preview-image?projectKey=' + projectKey + '&codeStudioObjectId=' + codeStudioObjectId + '&type=' + zone + '&path=' + encodeURIComponent(content.path) + '&contentType=' + encodeURIComponent(content.mimeType);
                        },
                        set: function(content) {
                            return DataikuAPI.codeStudioObjects.folderEdit.setContent(projectKey, codeStudioObjectId, zone, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.codeStudioObjects.folderEdit.validate(projectKey, codeStudioObjectId, zone, contentMap);
                        // },
                        setAll: function(contentMap) {
                            return DataikuAPI.codeStudioObjects.folderEdit.setContentMultiple(projectKey, codeStudioObjectId, zone, contentMap);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.codeStudioObjects.folderEdit.createContent(projectKey, codeStudioObjectId, zone, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.codeStudioObjects.folderEdit.deleteContent(projectKey, codeStudioObjectId, zone, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.codeStudioObjects.folderEdit.decompressContent(projectKey, codeStudioObjectId, zone, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.codeStudioObjects.folderEdit.renameContent(projectKey, codeStudioObjectId, zone, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.codeStudioObjects.folderEdit.checkUploadContent(projectKey, codeStudioObjectId, zone, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.codeStudioObjects.folderEdit.uploadContent(projectKey, codeStudioObjectId, zone, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.codeStudioObjects.folderEdit.moveContent(projectKey, codeStudioObjectId, zone, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.codeStudioObjects.folderEdit.copyContent(projectKey, codeStudioObjectId, zone, content.path);
                        },
                        downloadURL: function(content) {
                            return DataikuAPI.codeStudioObjects.folderEdit.downloadURL(projectKey, codeStudioObjectId, zone, content.path);
                        }
                    };

                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.description =  "files";
                    $scope.headerDescription = "Files"
                    $scope.localStorageId = zone + "-" + projectKey + "-" + codeStudioObjectId;
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name codeStudioTemplateResourcesCallbacks
     * @description
     *   same as zoneEditCallbacks but for the resources of a CodeStudio template
     */
    app.directive('codeStudioTemplateResourcesCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, FutureProgressModal, DKUtils, CodeStudiosService) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    const codeStudioTemplateId = $stateParams.codeStudioTemplateId;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.codeStudioTemplates.resources.listContents(codeStudioTemplateId);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.codeStudioTemplates.resources.getContent(codeStudioTemplateId, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return '/dip/api/code-studio-templates/resources/preview-image?codeStudioTemplateId=' + codeStudioTemplateId + '&path=' + encodeURIComponent(content.path) + '&contentType=' + encodeURIComponent(content.mimeType);
                        },
                        set: function(content) {
                            return DataikuAPI.codeStudioTemplates.resources.setContent( codeStudioTemplateId, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.codeStudioTemplates.resources.validate( codeStudioTemplateId, contentMap);
                        // },
                        setAll: function(contentMap) {
                            return DataikuAPI.codeStudioTemplates.resources.setContentMultiple( codeStudioTemplateId, contentMap);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.codeStudioTemplates.resources.createContent( codeStudioTemplateId, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.codeStudioTemplates.resources.deleteContent( codeStudioTemplateId, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.codeStudioTemplates.resources.decompressContent( codeStudioTemplateId, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.codeStudioTemplates.resources.renameContent( codeStudioTemplateId, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.codeStudioTemplates.resources.checkUploadContent( codeStudioTemplateId, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.codeStudioTemplates.resources.uploadContent( codeStudioTemplateId, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.codeStudioTemplates.resources.moveContent( codeStudioTemplateId, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.codeStudioTemplates.resources.copyContent( codeStudioTemplateId, content.path);
                        },
                        downloadURL: function(content) {
                            return DataikuAPI.codeStudioTemplates.resources.downloadURL( codeStudioTemplateId, content.path);
                        }
                    };

                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.description =  "files";
                    $scope.headerDescription = "Resource files"
                    $scope.localStorageId = "codestudio-templates-" + codeStudioTemplateId + "-resources";
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name userZoneEditCallbacks
     * @description
     *   same as zoneEditCallbacks but for the folders of a user
     */
    app.directive('userZoneEditCallbacks', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, FutureProgressModal, DKUtils) {
        return {
            scope: false,
            restrict: 'A',
            link: {
                pre: function($scope, $element, attrs) {
                    var zone = attrs.zone;
                    $scope.folderEditCallbacks = {
                        list: function() {
                            return DataikuAPI.profile.folderEdit.listContents(zone);
                        },
                        get: function(content, sendAnyway) {
                            return DataikuAPI.profile.folderEdit.getContent(zone, content.path, sendAnyway);
                        },
                        previewImageURL: function(content) {
                            return DataikuAPI.profile.folderEdit.previewImageURL(zone, content.path, content.mimeType);
                        },
                        set: function(content) {
                            return DataikuAPI.profile.folderEdit.setContent(zone, content.path, content.data);
                        },
                        // validate: function(contentMap) {
                        //     return DataikuAPI.profile.folderEdit.validate(zone, contentMap);
                        // },
                        setAll: function(contentMap) {
                            return DataikuAPI.profile.folderEdit.setContentMultiple(zone, contentMap);
                        },
                        create: function(path, isFolder) {
                            return DataikuAPI.profile.folderEdit.createContent(zone, path, isFolder);
                        },
                        delete: function(content) {
                            return DataikuAPI.profile.folderEdit.deleteContent(zone, content.path);
                        },
                        decompress: function(content) {
                            return DataikuAPI.profile.folderEdit.decompressContent(zone, content.path);
                        },
                        rename: function(content, newName) {
                            return DataikuAPI.profile.folderEdit.renameContent(zone, content.path, newName);
                        },
                        checkUpload: function(contentPath, paths) {
                            return DataikuAPI.profile.folderEdit.checkUploadContent(zone, contentPath, paths);
                        },
                        upload: function(contentPath, file, callback) {
                            return DataikuAPI.profile.folderEdit.uploadContent(zone, contentPath, file, callback);
                        },
                        move: function(content, to) {
                            return DataikuAPI.profile.folderEdit.moveContent(zone, content.path, (to ? to.path : ''));
                        },
                        copy: function(content) {
                            return DataikuAPI.profile.folderEdit.copyContent(zone, content.path);
                        },
                        downloadURL: function(content) {
                            return DataikuAPI.profile.folderEdit.downloadURL(zone, content.path);
                        }
                    };

                    $scope.folderEditSaveWarning = 'You have unsaved changes to a file, are you sure you want to leave?';
                    $scope.description =  "files";
                    $scope.headerDescription = "Files"
                    $scope.localStorageId = zone;
                }
            }
        };
    });

    /**
     * @ngdoc directive
     * @name projectZoneGitRefCallbacks
     * @description
     *   This directive is composed on the scope above FolderEditController.
     *   It is responsible for setting up the callbacks needed to get/set/list/rm git references.
     */
    app.directive('projectZoneGitRefCallbacks', function(DataikuAPI, $stateParams, WT1) {
        return {
            scope : false,
            restrict : 'A',
            link : {
                pre : function($scope) {
                    $scope.gitRefCallbacks = {
                        set: function (gitRef, gitRefPath, addPythonPath) {
                            WT1.event("project-libs-git-refs-save");
                            return DataikuAPI.git.setProjectGitRef($stateParams.projectKey, gitRef, gitRefPath, addPythonPath);
                        },
                        rm: function (gitRefPath, deleteDirectory) {
                            WT1.event("project-libs-git-refs-rm", {"delete-directory": deleteDirectory});
                            return DataikuAPI.git.rmProjectGitRef($stateParams.projectKey, gitRefPath, deleteDirectory);
                        },
                        pullOne: function (gitRefPath) {
                            WT1.event("project-libs-git-refs-pull-one");
                            return DataikuAPI.git.pullProjectGitRef($stateParams.projectKey, gitRefPath);
                        },
                        pullAll: function () {
                            WT1.event("project-libs-git-refs-pull-all");
                            return DataikuAPI.git.pullProjectGitRefs($stateParams.projectKey);
                        },
                        pushOne: function (commitMessage, gitRefPath) {
                            WT1.event("project-libs-git-ref-push-one");
                            return DataikuAPI.git.pushProjectGitRefs($stateParams.projectKey, commitMessage, gitRefPath);
                        },
                        pushAll: function (commitMessage) {
                            WT1.event("project-libs-git-ref-push-all");
                            return DataikuAPI.git.pushProjectGitRefs($stateParams.projectKey, commitMessage);
                        },
                        revertAllFiles: function(gitLib) {
                            WT1.event("project-libs-git-ref-revert-all");
                            return DataikuAPI.git.revertAllFiles($stateParams.projectKey, gitLib);
                        },
                        markAsResolved: function(fileName, gitLibPath) {
                            WT1.event("project-libs-git-ref-mark-resolved");
                            return DataikuAPI.git.markAsResolved($stateParams.projectKey, fileName, gitLibPath);
                        }
                    }
                }
            }
        };
    });

    app.controller('TopLevelFolderEditionController', function($scope, DataikuAPI, $state, $stateParams, CreateModalFromTemplate, TopNav) {
        TopNav.setLocation(TopNav.DSS_HOME, "administration");
        TopNav.setNoItem();

        $scope.pythonEmptyCta = {
            title: "No shared python code on this " + $scope.wl.productLongName + " instance.",
            text: "Create your own libraries or helpers and share them within all the " + $scope.wl.productShortName + " instance. The contents of 'lib-python' are accessible to python recipes and notebooks just like regular python libraries.",
            image: "static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",
            btnAction: "create",
            btnLabel: "Create your first shared python file"
        }

        $scope.rEmptyCta = {
            title: "No shared R code on this " + $scope.wl.productLongName + " instance.",
            text: "Create your own libraries and share them within all the " + $scope.wl.productShortName + " instance. The contents of 'lib-r' are accessible to R recipes and notebooks just like regular R libraries.",
            image: "static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",
            btnAction: "create",
            btnLabel: "Create your first shared R file"
        }
    });

    app.controller('TopLevelLocalStaticEditorController', function($scope, DataikuAPI, $state, $stateParams, CreateModalFromTemplate, TopNav, $rootScope) {
        TopNav.setLocation(TopNav.DSS_HOME, "administration");
        TopNav.setNoItem();

        $scope.emptyCta = {
            title: "No static web resources on this " + $scope.wl.productLongName + " instance.",
            text: "Create and upload your static web resources and use them for your webapps within all the " + $scope.wl.productShortName + " instance. Right click on local-static root folder and create or upload your files.",
            image: "static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",
            btnAction: "upload",
            btnLabel: "Upload your first resource"
        }
    });

    app.controller('ProjectFolderVersionedEditionController', function($scope, DataikuAPI, $state, $stateParams, CreateModalFromTemplate, TopNav, $rootScope) {
        TopNav.setLocation(TopNav.TOP_NOTEBOOKS, 'libraries', TopNav.TABS_NONE, null);
        TopNav.setNoItem();

        $scope.projectNoTabsCta = {
            title: "Share and reuse code with project Libraries",
            text: "Develop Libraries to reuse and share code in Python or R Recipes and Notebooks across your project.",
            image: "static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",
            knowledgeBankLink: "/code/shared/concept-project-libraries",
        };
    });

    app.controller('ProjectFolderVersionedHistoryController', function($scope, $stateParams, TopNav) {
        TopNav.setLocation(TopNav.TOP_NOTEBOOKS, 'libraries', TopNav.TABS_NONE, null);
        TopNav.setNoItem();
    });

    app.controller('ProjectFolderResourcesEditionController', function($scope, DataikuAPI, $state, $stateParams, CreateModalFromTemplate, TopNav, $rootScope) {
        TopNav.setLocation(TopNav.TOP_NOTEBOOKS, 'libraries', TopNav.TABS_NONE, null);
        TopNav.setNoItem();

        $scope.projectNoTabsCta = {
            title: "Project resources",
            text: "Create your own resources and share them within the project."
        };
    });

    app.directive('folderContentEditor', function(DataikuAPI, $stateParams, Dialogs, $state, CreateModalFromTemplate, $q,
                                                  $timeout, LocalStorage, $rootScope, openDkuPopin, Logger, CodeMirrorSettingService,
                                                  FutureProgressModal, DKUtils, CodeStudiosService) {
        return {
            scope: true,
            restrict: 'A',
            templateUrl: '/templates/plugins/development/fragments/folder-content-editor.html',
            link: function($scope, $element, attrs) {
                $scope.editorOptions = null;
                $scope.uiState = {
                    foldRoot: false
                };
                // Enable editor by default. If user does not have write access, error will be displayed on save/commit
                $scope.canEdit = true;
                $scope.canEditInCodeStudio = false;
                // In some cases, the project key is not available in the state params (e.g. in the plugin development page)
                if ($stateParams.projectKey) {
                    DataikuAPI.projects.getSummary($stateParams.projectKey).success(data => {
                        $scope.canEdit = data.object.canWriteProjectContent;
                    });
                    DataikuAPI.codeStudioTemplates.canEditInCodeStudio($stateParams.projectKey).success( data => {
                        $scope.canEditInCodeStudio = data.canEdit;
                    });
                }
                /* Attributes with inherited scope */
                $scope.emptyCta = $scope.$eval(attrs.emptyCta);
                $scope.noTabsCta = $scope.$eval(attrs.noTabsCta);
                $scope.canCommit = $scope.$eval(attrs.canCommit);
                $scope.commitFn = $scope[attrs.commitFn];
                const postSaveCallback = () => {
                    if (attrs.postSaveCallback) {
                        $scope[attrs.postSaveCallback]();
                    }
                };

                const initialPath = attrs.initialPath || $stateParams.initialPath;
                if (initialPath) {
                    $scope.openOnLoad = initialPath;
                }

                /*
                 * Listing plugin content
                 */

                $scope.listContents = function() {
                    return $scope.folderEditCallbacks.list().success(data => {
                        const recGetExpandedState = function(content, map) {
                            if (content.children != null) {
                                map[content.path] = content.expanded || false;
                                content.children.forEach(subContent => recGetExpandedState(subContent, map));
                            }
                        };

                        const recSetExpandedState = (content, map) => {
                            if (content.children != null) {
                                content.expanded = map[content.path] || false;
                            }
                        };
                        const recSetDepth = function(content, depth) {
                            content.depth = depth;
                        };

                        const recSetGit = (externalLibs, content, gitSubPath, gitRefPath) => {
                            if (gitSubPath || content.path in externalLibs.gitReferences) {
                                content.fromGit = true;
                                if (gitSubPath && gitRefPath) {
                                    const name = content.path.substring(gitRefPath.length + 1);
                                    content.gitLib = gitRefPath;
                                    const gitRef = externalLibs.gitReferences[gitRefPath];
                                    if (gitRef && gitRef.conflictingFiles != null && gitRef.conflictingFiles.includes(name)) {
                                        content.isInConflict = true;
                                    }
                                    if (gitRef && gitRef.resolvedFiles && gitRef.resolvedFiles.includes(name)) {
                                        content.isResolved = true;
                                    }
                                }
                            }
                            if (externalLibs.pythonPath.includes(content.path)) {
                                content.inPythonPath = true;
                            }
                            if (externalLibs.rsrcPath.includes(content.path)) {
                                content.inRSrcPath = true;
                            }
                            if (content.children != null) {
                                content.children.forEach(childContent => {
                                    recSetGit(externalLibs, childContent, content.fromGit, !gitSubPath ? content.path : gitRefPath);
                                    if (childContent.isInConflict) {
                                        content.isInConflict = true;
                                    }
                                    if (childContent.isResolved) {
                                        content.isResolved = true;
                                    }
                                });
                            }
                        };

                        const handleContent = (content, states, depth) => {
                            recSetExpandedState(content, states);
                            recSetDepth(content, depth);
                            if (content.children != null) {
                                content.children.forEach(childContent => handleContent(childContent, states, depth + 1));
                            }
                        }

                        const oldStates = {};
                        // save the expanded states
                        if ($scope.devContents != null ) {
                            $scope.devContents.forEach(content => recGetExpandedState(content, oldStates));
                        }
                        // set the new state of the contents tree
                        $scope.devContents = data;
                        if ($scope.gitRefCallbacks) {
                            DataikuAPI.git.getProjectExternalLibs($stateParams.projectKey).then(result => {
                                $scope.externalLibs = result.data;
                                $scope.gitReferences = result.data.gitReferences;

                                if ($scope.devContents != null ) {
                                    $scope.devContents.forEach(content => recSetGit($scope.externalLibs, content, false, content.path));
                                }
                            }, setErrorInScope.bind($scope));
                        }
                        if ($scope.devContents != null ) {
                            $scope.devContents.forEach(content => handleContent(content, oldStates, 1, false, content.path));
                        }
                    }).error(setErrorInScope.bind($scope));
                };

                $scope.listContents().then(() => {
                    openSavedTabs();
                    if ($scope.openOnLoad) {
                        openFileFromExternal($scope.openOnLoad);
                        $scope.openOnLoad = null;
                    }
                });

                $scope.reloadContents = () => {
                    return $scope.listContents().then(() => {
                        $scope.tabsList.forEach($scope.reloadTab);
                        $scope.updateActiveTab($scope.activeTabIndex);
                    });
                }

                $scope.reloadTab = (tab, index) => {
                    const filePaths = searchInDevContents(tab.path);
                    if (filePaths && filePaths.length > 0) {
                        $scope.tabsList[index] = filePaths[filePaths.length - 1];
                        $scope.tabsList[index].needReload = true;
                    }
                }

                $scope.sortFolder = function(content) {
                    content.sort(function(c1, c2) {
                        if (c1.children && !c2.children) {
                            return -1;
                        }
                        if (!c1.children && c2.children) {
                            return 1;
                        }
                        return c1.name > c2.name ? 1 : -1;
                    });
                    return content;
                };

                /*
                 * Opening and closing tabs
                 */

                $scope.originalContentMap = {};
                $scope.editedContentMap = {};
                $scope.activeTabIndex = -1;

                $scope.openFile = function(file) {
                    if (!$scope.canBeDecompressed(file)) {
                        var tabIndex = $scope.addTab(file);
                        $scope.updateActiveTab(tabIndex);
                        if (typeof($scope.unregisterArrowSliderInit) === "function") {
                            $scope.unregisterArrowSliderInit();
                        }
                    }
                }

                $scope.addTab = function(file) {
                    var tabIndex = $scope.tabsList.findIndex(f => f.path === file.path);
                    if (tabIndex === -1) {
                        $scope.tabsList.push(file);
                        tabIndex = $scope.tabsList.length - 1;
                    } else {
                        $scope.tabsList[tabIndex] = file;
                    }
                    return tabIndex;
                };

                $scope.updateActiveTab = function(tabIndex) {
                    if (tabIndex != -1 && tabIndex < $scope.tabsList.length && $scope.tabsList[tabIndex]) {
                        var fileToOpen = $scope.tabsList[tabIndex];
                        //saving scroll position
                        var currentContent = $scope.getCurrentContent();
                        if (currentContent) {
                            saveTabScrollPosition(currentContent.path, $('.CodeMirror-scroll').scrollTop());
                        }
                        //updating tab index
                        $scope.activeTabIndex = tabIndex;
                        saveActiveTab();
                        //scrolling through tabs if necessary
                        $timeout(function() {
                            if ($scope.needSlider()) {
                                slideToTab(fileToOpen.path);
                            }
                        });
                        //replacing editor's content
                        if ($scope.editedContentMap[fileToOpen.path] && !fileToOpen.needReload) {
                            setCurrentContent(fileToOpen);
                        } else {
                            fileToOpen.needReload = false;
                            // the backend doesn't consider images to be editable, but we want display them
                            const isImage = fileToOpen.mimeType && fileToOpen.mimeType.startsWith('image');
                            $scope.loadAndSetCurrentContent(fileToOpen, isImage);
                        }
                    }
                }

                $scope.loadAndSetCurrentContent = function(file, sendAnyway) {
                    $scope.folderEditCallbacks.get(file, sendAnyway).success(function(data){
                        $scope.originalContentMap[file.path] = angular.copy(data);
                        $scope.editedContentMap[file.path] = data;
                        setCurrentContent(file);
                    }).error(setErrorInScope.bind($scope));
                };

                $scope.editActiveTabInCodeStudio = function() {
                    $scope.folderEditCallbacks.editInCodeStudio($scope.getCurrentContent());
                }

                var setCurrentContent = function(file) {
                    var mimeType = selectSyntaxicColoration(file.name, file.mimeType);

                    $scope.editorOptions = CodeMirrorSettingService.get(mimeType, {
                        readOnly: !$scope.canEdit,
                        onLoad: function(codeMirror) {
                            $timeout(function() {
                                codeMirror.scrollTo(0, $scope.getTabScrollPosition(file.path));
                            });
                        }
                    });
                };

                var selectSyntaxicColoration = function(fileName, mimeType) {
                    if (mimeType === 'application/sql' ) {
                        return 'text/x-sql'; // codemirror prefers this one
                    }
                    if (mimeType === 'text/x-python-script') {
                        return 'text/x-python'; // codemirror prefers this one
                    }
                    if (fileName.endsWith('.java')) {
                        return 'text/x-java';
                    }
                    return mimeType
                };

                var refreshSyntaxicColoration = function(fileName, mimeType) {
                    $scope.editorOptions.mode = selectSyntaxicColoration(fileName, mimeType);
                };

                var closeContent = function(file) {
                    var tabIndex = $scope.tabsList.findIndex(f => f.path === file.path);
                    if (tabIndex > -1) {
                        $scope.tabsList.splice(tabIndex, 1);
                        if (tabIndex == $scope.activeTabIndex) {
                            $scope.activeTabIndex = -1;
                            if ($scope.tabsList.length > 0) {
                                var newActiveTabIndex = tabIndex > 0 ? tabIndex - 1 : 0;
                                $scope.updateActiveTab(newActiveTabIndex);
                            }
                        } else if (tabIndex < $scope.activeTabIndex) {
                            $scope.activeTabIndex--;
                        }
                    }
                };

                $scope.closeFile = function(file) {
                    if ($scope.isContentDirty(file)) {
                        CreateModalFromTemplate("/templates/plugins/development/fragments/fileclose-prompt.html", $scope, null, function(newScope) {
                            newScope.closeAndSave = function() {
                                var fileToSave = $scope.editedContentMap[file.path];
                                if (fileToSave) {
                                    $scope.saveContent(fileToSave);
                                }
                                closeContent(file);
                                newScope.dismiss();
                            }
                            newScope.close = function() {
                                closeContent(file);
                                newScope.dismiss();
                            }
                        });
                    } else {
                        closeContent(file);
                    }
                };

                $scope.closeOtherFiles = function(file) {
                    var dirtyFiles = [];
                    var fileToClose = [];
                    $scope.tabsList.forEach(function(f) {
                       if (f.path != file.path) {
                           fileToClose.push(f);
                           if ($scope.isContentDirty(f)) {
                               dirtyFiles.push(f);
                           }
                       }
                    });
                    if (dirtyFiles.length > 0) {
                        Dialogs.confirm($scope,'Discard changes','Are you sure you want to discard your changes?').then(function() {
                            $scope.tabsList = [file];
                            $scope.updateActiveTab(0);
                        }, angular.noop);
                    } else {
                        $scope.tabsList = [file];
                        $scope.updateActiveTab(0);
                    }
                };

                $scope.$watch('tabsList', function(nv, ov) {
                    if (nv && ov && nv.length < ov.length) {
                        var nvPath = nv.map(function(file) {
                            return file.path;
                        })
                        ov.forEach(function(file) {
                            if (nvPath.indexOf(file.path) == -1) {
                                delete $scope.originalContentMap[file.path];
                                delete $scope.editedContentMap[file.path];
                            }
                        });
                        cleanTabScrollPosition();
                    }
                    $scope.tabsMap = {};
                    if (nv) {
                        nv.forEach(function(file) {
                            $scope.tabsMap[file.path] = file;
                        });
                    }
                    saveTabsList();
                }, true);

                var searchInDevContents = function(filePath) {
                    if (filePath == null) return null;
                    var pathFolders = [];
                    var searchRecursively = function(folder) {
                        for (var i = 0; i < folder.length; i++) {
                            var child = folder[i];
                            if (child.children && filePath.startsWith(child.path + "/")) {
                                pathFolders.push(child);
                                return searchRecursively(child.children);
                            } else if (child.path == filePath) {
                                pathFolders.push(child);
                                return pathFolders;
                            }
                        }
                        return null;
                    };
                    return searchRecursively($scope.devContents);
                }

                var openFileFromExternal = function(filePath) {
                    var pathFolders = searchInDevContents(filePath);
                    if (pathFolders && pathFolders.length > 0) {
                        pathFolders.forEach(function(f) {
                            f.expanded = true;
                        });
                        let file = pathFolders[pathFolders.length - 1];
                        // if it's just a directory, pick the first file you find in it
                        if (!file.mimeType) {
                            function recFindFirstFile(x) {
                                if (x.mimeType) return x;
                                if (x.children) {
                                    // don't map+filter so that you get early stop
                                    for (var i = 0; i < x.children.length; i++) {
                                        let y = recFindFirstFile(x.children[i]);
                                        if (y.mimeType) return y;
                                    }
                                }
                                return x;
                            };
                            file = recFindFirstFile(file);
                        }
                        if (file.mimeType) {
                            $scope.openFile(file);
                            $timeout(function() {
                                $scope.focusedFile = file;
                            });
                        }
                    }
                };

                $scope.getCurrentContent = function() {
                    if ($scope.activeTabIndex > -1 && $scope.tabsList && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile ? $scope.editedContentMap[currentFile.path] : null;
                    }
                    return null;
                };

                $scope.getCurrentGitLib = function() {
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile && currentFile.fromGit ? currentFile.gitLib : null;
                    }
                    return null;
                };

                $scope.isContentFromGit = function() {
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile ? currentFile.fromGit : false;
                    }
                    return false;
                };
                $scope.isInConflict = function() {
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile ? currentFile.isInConflict : false;
                    }
                    return false;
                };
                $scope.isResolved = function() {
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile ? currentFile.isResolved : false;
                    }
                    return false;
                };
                $scope.isFileIsExternalLibrariesJSON = function() {
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile ? (currentFile.path==currentFile.name && currentFile.name == "external-libraries.json") : false;
                    }
                    return false;
                };

                $scope.isFileInPublicDirectory = function() {
                    if(!$scope.isInProjectResources) return false;
                    if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                        var currentFile = $scope.tabsList[$scope.activeTabIndex];
                        return currentFile && currentFile.path.startsWith('local-static/');
                    }
                    return false;
                };

                $scope.isContentDirty = function(file) {
                    var isFileOpen = file && file.path && $scope.originalContentMap[file.path] && $scope.editedContentMap[file.path];
                    return isFileOpen && $scope.originalContentMap[file.path].data != $scope.editedContentMap[file.path].data;
                };

                $scope.hasDirtyContent = function() {
                    if ($scope.tabsList) {
                        for (var i=0; i<$scope.tabsList.length; i++) {
                            var file = $scope.tabsList[i];
                            if ($scope.isContentDirty(file)) {
                                return true;
                            }
                        }
                    }
                    return false;
                };

                $scope.reloadFileUponConflict = function(filePath) {
                    var element = searchInDevContents(filePath);
                    element[element.length -1].isInConflict = true;
                    $scope.openFile(element[element.length -1]);
                };

                /*
                 * Tab and Folder Explorer Menu
                 */

                $scope.focusOnFile = function(filePath) {
                    var pathFolders = searchInDevContents(filePath);
                    if (pathFolders && pathFolders.length > 0) {
                        pathFolders.forEach(function(content) {
                            content.expanded = true;
                        });
                        $timeout(function() {
                            $scope.focusedFile = pathFolders[pathFolders.length - 1];
                        });
                    }
                };

                var slideToTab = function(path) {
                    $scope.$broadcast('slideToId', "#tabs-frame", "#tabs-slider", path);
                };

                $scope.openTabMenu = function(element, $event) {
                    var template = '<ul class="dropdown-menu">'
                    +    '<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">' + moveIcon + moveText + '</a></li>'
                    +    '<li ng-disabled="!canEdit" ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">' + duplicateIcon + duplicateText + '</a></li>'
                    +    '<li><a ng-disabled="!canEdit" ng-click="renameContent(element)">' + renameIcon + renameText + '</a></li>'
                    +    '<li><a ng-click="closeOtherFiles(element)">' + closeOtherTabIcon + closeOtherTabText + '</a></li>'
                    +    '<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)" style="border-top: 1px #eee solid;">' + deleteIcon + deleteText + '</a></li>'
                    +'</ul>'

                    openRightClickMenu(element, $event, template);
                };

                $scope.openFileMenu = function (element, $event) {
                    let template = '<ul class="dropdown-menu">';

                    template += '<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">' + moveIcon + moveText + '</a></li>'
                        + '<li ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">' + duplicateIcon + duplicateText + '</a></li>'
                        + ($scope.folderEditCallbacks.editInCodeStudio && $rootScope.projectSummary.canWriteProjectContent && $scope.canEditInCodeStudio ? '<li><a ng-disabled="!canEdit" ng-click="editInCodeStudio(element)">' + editFileIcon + editInCodeStudioText + '</a></li>' : '')
                        + '<li><a ng-disabled="!canEdit" ng-click="renameContent(element)">' + renameIcon + renameText +'</a></li>'
                        + '<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)">' + deleteIcon + deleteText + '</a></li>'
                        + ($scope.folderEditCallbacks.downloadURL ? '<li><a ng-click="downloadElement(element)">' + downloadIcon + downloadText + '</a></li>' : '')
                        + '</ul>';
                    openRightClickMenu(element, $event, template);
                }

                $scope.openFolderMenu = function(element, $event) {
                    const folderLocalActions = '<li><a ng-disabled="!canEdit" ng-click="addInElement(element.path, false, element)">' + createFileIcon + createFileText + '</a></li>'
                        +	'<li><a ng-disabled="!canEdit" ng-click="addInElement(element.path, true, element)">' + createFolderIcon + createFolderText + '</a></li>'
                        +	'<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">' + moveIcon + moveText + '</a></li>'
                        +	'<li ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">' + duplicateIcon + duplicateText + '</a></li>'
                        +	'<li ng-show="!element.fromGit"><a  ng-disabled="!canEdit" ng-click="renameContent(element)">' + renameIcon + renameText + '</a></li>'
                        +   '<li><a ng-disabled="!canEdit" ng-click="uploadElement(element.path)">' + uploadIcon + uploadText + '</a></li>'
                        +   ($scope.folderEditCallbacks.downloadURL ? '<li><a ng-click="downloadElement(element)">' + downloadIcon + downloadText + '</a></li>' : '')
                        +   '<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)">' + deleteIcon + deleteText + '</a></li>';

                    let template = '<ul class="dropdown-menu">';

                    if (element.fromGit) {
                        // This folder has been imported through Git references

                        if (element.path in $scope.gitReferences) {
                           template += '<li><a ng-click="gitRefActions.pushModal(element.path)" ng-disabled="isInConflict()">' + commitIcon + commitText + '</a></li>'
                           + '<li><a ng-click="gitRefActions.pullModal(element.path)">' + pullIcon + pullText + '</a></li>'
                               + '<li><a ng-click="gitRefActions.setModal(gitReferences[element.path], element.path)">' + editIcon + editText + '</a></li>'
                               + '<li><a ng-click="gitRefActions.untrackModal(element.path)">' + unlinkIcon + unlinkText + '</a></li>'
                               + '<li class="divider"></li>';
                        }
                    }

                    template += folderLocalActions + '</ul>';

                    openRightClickMenu(element, $event, template);
                };

                $scope.openRootMenu = function($event) {
                    var template = '<ul class="dropdown-menu">'
                        + '<li><a ui-sref="profile.my.settings({\'#\':\'code_editor\'})" target="_blank">' + customizeEditorSettingsIcon + customizeEditorSettingsText + '</a></li>'
                        +   '<li><a ng-click="listContents(\'\')">' + reloadLocalFileIcon + reloadLocalFileText + '</a></li>'
                        +'</ul>'

                    openRightClickMenu(null, $event, template);
                };

                $scope.openAddMenu = function($event) {
                    var template = '<ul class="dropdown-menu">'
                        +   '<li><a ng-disabled="!canEdit" ng-if="$state.$current.name == \'plugindev.editor\'" ng-click="newComponentPopin()">Create component</a></li>'
                        +   '<li><a ng-disabled="!canEdit" ng-click="addInElement(\'\', false)" id="qa_plugindev_folder-file-add-btn">' + createFileIcon + createFileText + '</a></li>'
                        +   '<li><a ng-disabled="!canEdit" ng-click="addInElement(\'\', true)">' + createFolderIcon + createFolderText + '</a></li>'
                        +   '<li><a ng-disabled="!canEdit" ng-click="uploadElement(\'\')">' + uploadIcon + uploadText + '</a></li>'
                        +   ($scope.folderEditCallbacks.downloadURL ? '<li><a ng-click="downloadElement({path:\'\'})">' + downloadIcon + downloadText + '</a></li>' : '')
                        +'</ul>'

                    openRightClickMenu(null, $event, template);
                };

                $scope.openGitMenu = function($event) {
                    var template = '<ul class="dropdown-menu">'
                        +	'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.setModal()">' + importFromGitIcon + importFromGitText + '</a></li>'
                        +	'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.listModal()">' + manageReferenceIcon + manageReferenceText + '</a></li>'
                        +	'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.pullModal()">' + updateAllIcon + updateAllText + '</a></li>'
                        +	'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.pushModal()">' + commitAllIcon + commitAllText + '</a></li>'
                        +'</ul>'

                    openRightClickMenu(null, $event, template);
                };

                var openRightClickMenu = function(element, $event, template) {
                    var callback = function(newScope) {
                        newScope.element = element;
                    };
                    openMenu($event, template, callback);
                };

                var openMenu = function($event, template, callback) {
                    function isElsewhere(elt, e) {
                        return $(e.target).parents('.plugindev-tab-menu').length == 0;
                    }
                    var dkuPopinOptions = {
                        template: template,
                        isElsewhere: isElsewhere,
                        callback: callback
                    };
                    openDkuPopin($scope, $event, dkuPopinOptions);
                };

                /*
                 * Tabs persistency
                 */

                var getFolderEditLocalStorage = function() {
                    var allFolderEditLocalStorage = LocalStorage.get("dss.folderedit");
                    if (!allFolderEditLocalStorage) {
                        allFolderEditLocalStorage = {};
                    }
                    var folderEditLocalStorage = allFolderEditLocalStorage[$scope.localStorageId];
                    if (!folderEditLocalStorage) {
                        folderEditLocalStorage = {"tabsList":[]};
                    }
                    if (!folderEditLocalStorage.tabsList) {
                        folderEditLocalStorage.tabsList = [];
                    }
                    return folderEditLocalStorage;
                }

                var setFolderEditLocalStorage = function(folderEditLocalStorage) {
                    var allFolderEditLocalStorage = LocalStorage.get("dss.folderedit");
                    if (!allFolderEditLocalStorage) {
                        allFolderEditLocalStorage = {};
                    }
                    allFolderEditLocalStorage[$scope.localStorageId] = folderEditLocalStorage;
                    LocalStorage.set("dss.folderedit", allFolderEditLocalStorage);
                }

                var saveTabsList = function() {
                    if ($scope.tabsList) {
                        var folderEditLocalStorage = getFolderEditLocalStorage();
                        folderEditLocalStorage.tabsList = $scope.tabsList.map(function(file) {
                            return file.path;
                        });
                        setFolderEditLocalStorage(folderEditLocalStorage);
                    }
                };

                var saveActiveTab = function() {
                    var folderEditLocalStorage = getFolderEditLocalStorage();
                    folderEditLocalStorage.activeTab = $scope.tabsList[$scope.activeTabIndex].path;
                    setFolderEditLocalStorage(folderEditLocalStorage);
                }

                var saveTabScrollPosition = function(path, scroll) {
                    var folderEditLocalStorage = getFolderEditLocalStorage();
                    if (!folderEditLocalStorage.scrollPositions) {
                        folderEditLocalStorage.scrollPositions = {};
                    }
                    folderEditLocalStorage.scrollPositions[path] = scroll;
                    setFolderEditLocalStorage(folderEditLocalStorage);
                }

                var cleanTabScrollPosition = function() {
                    var folderEditLocalStorage = getFolderEditLocalStorage();
                    var scrollPositions = folderEditLocalStorage.scrollPositions;
                    if (scrollPositions) {
                        var tabsPathList = $scope.tabsList.map(function(f) {
                            return f.path;
                        });
                        Object.keys(scrollPositions).forEach(function(path) {
                            if (tabsPathList.indexOf(path) == -1) {
                                delete scrollPositions[path];
                            }
                        });
                    }
                    setFolderEditLocalStorage(folderEditLocalStorage);
                }

                $scope.getTabScrollPosition = function(path) {
                    var folderEditLocalStorage = getFolderEditLocalStorage();
                    return folderEditLocalStorage.scrollPositions && folderEditLocalStorage.scrollPositions[path] ? folderEditLocalStorage.scrollPositions[path] : 0;
                }

                var openSavedTabs = function() {
                    var folderEditLocalStorage = getFolderEditLocalStorage();
                    var activeTab = null;
                    $scope.tabsList = [];
                    folderEditLocalStorage.tabsList.forEach(function (filePath) {
                        var objPath = searchInDevContents(filePath);
                        if (objPath) {
                            var file = objPath[objPath.length - 1];
                            $scope.addTab(file);
                            if (filePath == folderEditLocalStorage.activeTab) {
                                activeTab = file;
                            }
                        }
                    });
                    var fileToOpen = folderEditLocalStorage.activeTab && activeTab ? activeTab : $scope.tabsList[$scope.tabsList.length - 1];
                    if (fileToOpen) {
                        $scope.focusOnFile(fileToOpen.path);
                        $scope.openFile(fileToOpen);
                        $scope.unregisterArrowSliderInit = $scope.$on("DKU_ARROW_SLIDER:arrow_slider_initialized", function() {
                            slideToTab(fileToOpen.path);
                        });
                    }
                }

                /*
                 * CRUD
                 */

                const updateGitRefsAfterSave = function(cond) {
                    if ($scope.gitRefCallbacks) {
                        $scope.listContents();
                    }
                };

                $scope.saveCurrentContent = function() {
                    var currentContent = $scope.getCurrentContent();
                    $scope.saveContent(currentContent, $scope.getCurrentGitLib());
                };

                $scope.editInCodeStudio = function(element) {
                    $scope.folderEditCallbacks.editInCodeStudio(element);
                }

                function refreshFileSize(filePath) {
                    const leaf = (searchInDevContents(filePath) || []).pop();
                    if (leaf && $scope.originalContentMap[filePath] && angular.isString($scope.originalContentMap[filePath].data)) {
                        leaf.size = $scope.originalContentMap[filePath].data.length;
                    }
                }

                function doSaveContent(content, gitLib) {
                    $scope.folderEditCallbacks.set(content, gitLib).success(function(data){
                        $scope.originalContentMap[content.path] = angular.copy(content);
                        refreshFileSize(content.path);
                        postSaveCallback();
                        updateGitRefsAfterSave(content.path === 'external-libraries.json');
                        const dirtyFiles = {
                            [content.path]: content.data
                        };
                        reloadPluginIfNeeded(dirtyFiles);
                    }).error(setErrorInScope.bind($scope));
                }

                function validateAndSaveContent(content, gitLib) {
                    if (!$scope.folderEditCallbacks.validate) {
                        doSaveContent(content, gitLib)
                    } else {
                        const dirtyFiles = {
                            [content.path]: content.data
                        };
                        $scope.folderEditCallbacks.validate(dirtyFiles).success(function(data) {
                            if (!data.anyMessage) {
                                doSaveContent(content, gitLib)
                            } else {
                                CreateModalFromTemplate('/templates/plugins/development/plugin-dev-warning-modal.html', $scope, null, function(modalScope) {
                                    resetErrorInScope(modalScope);
                                    modalScope.messages = data;
                                    modalScope.saveAnyway = function() {
                                        modalScope.dismiss();
                                        doSaveContent(content, gitLib)
                                    }
                                })
                            }
                        }).error(setErrorInScope.bind($scope));
                    }
                }

                $scope.saveContent = function(content, gitLib) {
                    validateAndSaveContent(content, gitLib);
                };

                function doSaveAll(dirtyFiles, lib) {
                    $scope.folderEditCallbacks.setAll(dirtyFiles, lib).success(function(data){
                        Object.keys(dirtyFiles).forEach(function(filePath) {
                            $scope.originalContentMap[filePath].data = dirtyFiles[filePath];
                            refreshFileSize(filePath);
                        });
                        postSaveCallback();
                        updateGitRefsAfterSave('external-libraries.json' in dirtyFiles);
                        reloadPluginIfNeeded(dirtyFiles)
                    }).error(setErrorInScope.bind($scope));
                }

                $scope.saveAll = function() {
                    var dirtyFiles = {};
                    var modifiedLibs = new Set();
                    $scope.tabsList.forEach(function(file) {
                        if ($scope.isContentDirty(file)) {
                            dirtyFiles[file.path] = $scope.editedContentMap[file.path].data;
                            modifiedLibs = modifiedLibs.add(file.gitLib);
                        }
                    });
                    resetErrorInScope($scope);
                    if (!$scope.folderEditCallbacks.validate) {
                        doSaveAll(dirtyFiles, modifiedLibs);
                    } else {
                        $scope.folderEditCallbacks.validate(dirtyFiles).success(function(data) {
                            if (!data.anyMessage) {
                                doSaveAll(dirtyFiles, modifiedLibs);
                            } else {
                                CreateModalFromTemplate('/templates/plugins/development/plugin-dev-warning-modal.html', $scope, null, function(modalScope) {
                                    modalScope.messages = data;
                                    modalScope.saveAnyway = function() {
                                        modalScope.dismiss();
                                        doSaveAll(dirtyFiles, modifiedLibs);
                                    }
                                })
                            }
                        }).error(setErrorInScope.bind($scope));
                    }
                };

                function reloadPluginIfNeeded(dirtyFiles) {
                    let doReload = 'reloadPlugin' in $scope;
                    if (doReload && dirtyFiles) { // not specified in the case of folder rename for example (and then we do want to reload)
                        let hasAnyJson = false;
                        let hasAnyJs = false;
                        for (const f of Object.keys(dirtyFiles)) {
                            if (f.toLowerCase().endsWith('.json')) {
                                hasAnyJson = true;
                                break;
                            }
                            if (f.toLowerCase().endsWith('.js')) {
                                hasAnyJs = true;
                                break;
                            }
                        }
                        if (!hasAnyJson && !hasAnyJs) {
                            doReload = false;
                        }
                    }
                    return doReload ? $scope.reloadPlugin($stateParams.pluginId) : Promise.resolve();
                }

                $scope.deleteContent = function(content) {
                    var isNonEmptyFolder = content.children != null && content.children.length > 0;
                    var message = isNonEmptyFolder ? 'Are you sure you want to delete ' + content.name + ' and all its contents?' : 'Are you sure you want to delete ' + content.name + ' ?';
                    Dialogs.confirm($scope,'Delete ' + ( isNonEmptyFolder ? 'folder' : 'file'), message).then(function() {
                        $scope.folderEditCallbacks.delete(content).success(function(data){
                            if ( ((content.children && content.children.length>0) || content.mimeType) && $scope.folderEditCallbacks.setDirty) {
                                $scope.folderEditCallbacks.setDirty(content.gitLib);
                            }
                           var toClose = [];
                            $scope.tabsList.forEach(function(file) {
                                if (isIncludedOrEqual(file.path, content.path)) {
                                    toClose.push(file);
                                }
                            });
                            toClose.forEach(function(f) {
                                closeContent(f);
                            });
                            if ($scope.folderEditCallbacks.setDirty) {
                                DKUtils.reloadState(); // needed for git-enabled editors
                            } else {
                                $scope.listContents('');
                            }
                        }).error(setErrorInScope.bind($scope));
                    }, angular.noop);
                };

                $scope.renameContent = function(content) {
                    var popinName = content.children ? "Rename folder" : "Rename file";
                    Dialogs.prompt($scope, popinName, 'New name', content.name).then(function(newName) {
                        $scope.folderEditCallbacks.rename(content, newName).success(function(data){
                            if ( ((content.children && content.children.length>0) || content.mimeType) && $scope.folderEditCallbacks.setDirty) {
                                $scope.folderEditCallbacks.setDirty(content.gitLib);
                            }
                            //syntaxic coloration issues
                            if (content.mimeType != data.mimeType) {
                                //refreshing code mirror syntaxic coloration if we renamed current content
                                if ($scope.getCurrentContent() && $scope.getCurrentContent().path == content.path) {
                                    refreshSyntaxicColoration(content.name, data.mimeType);
                                }
                                //necessary if file renamed is among tabs (but not active one), otherwise syntaxic coloration won't be updated when we come back to this tab.
                                if ($scope.tabsMap[content.path]) {
                                    propagatingMimeTypeChange(content.path, data.mimeType);
                                }
                            }
                            // necessary, otherwise it fails when clicking on save after a move
                            propagatingPathChange(content.path, data.path);
                            reloadPluginIfNeeded().then(() => {
                                if ($scope.folderEditCallbacks.setDirty) {
                                    DKUtils.reloadState(); // needed for git-enabled editors
                                } else {
                                    $scope.listContents('');
                                }
                            });
                        }).error(setErrorInScope.bind($scope));
                    }, angular.noop);
                };

                $scope.moveContent = function(content) {
                    CreateModalFromTemplate("/templates/plugins/development/fragments/filemove-prompt.html", $scope, "MoveContentModalController", function(newScope) {
                        resetErrorInScope(newScope);
                        newScope.devContents = angular.copy($scope.devContents); // so that the stat is disconnected from the main display of the hierarchy
                        newScope.toMove = content;
                        newScope.doMove = function(to) {
                            $scope.folderEditCallbacks.move(content, to).success(function(data){
                                if ( ((content.children && content.children.length>0) || content.mimeType) && $scope.folderEditCallbacks.setDirty) {
                                    $scope.folderEditCallbacks.setDirty(content.gitLib);
                                }
                                // necessary, otherwise it fails when clicking on save after a move
                                propagatingPathChange(content.path, data.path);
                                reloadPluginIfNeeded().then(() => {
                                    if ($scope.folderEditCallbacks.setDirty) {
                                        DKUtils.reloadState(); // needed for git-enabled editors
                                    } else {
                                        $scope.listContents('');
                                    }
                                });
                            }).error(setErrorInScope.bind($scope));
                        };
                    });
                };

                $scope.canDuplicateContent = $scope.folderEditCallbacks.copy != null;

                $scope.duplicateContent = function(content) {
                    if ( ((content.children && content.children.length>0) || content.mimeType) && $scope.folderEditCallbacks.setDirty) {
                        $scope.folderEditCallbacks.setDirty(content.gitLib);
                    }
                    $scope.folderEditCallbacks.copy(content).success(function(data){
                        if ($scope.folderEditCallbacks.setDirty) {
                            DKUtils.reloadState(); // needed for git-enabled editors
                        } else {
                            $scope.listContents('');
                        }
                    }).error(setErrorInScope.bind($scope));
                }

                const propagatingPathChange = function(oldPath, newPath) {
                    // In tabslist
                    $scope.tabsList.forEach(function(file) {
                        if (isIncludedOrEqual(file.path, oldPath)) {
                            const oldFilePath = file.path;
                            const newFilePath = file.path.replace(oldPath, newPath);
                            const newName = newFilePath.split('/').at(-1); // file name may changed
                            file.path = newFilePath;
                            file.name = newName;
                            //updating originalContentMap
                            const originalContent = $scope.originalContentMap[oldFilePath];
                            if (originalContent) {
                                originalContent.path = newFilePath;
                                originalContent.name = newName;
                                delete $scope.originalContentMap[oldFilePath];
                                $scope.originalContentMap[newFilePath] = originalContent;
                            }
                            //updating editedContentMap
                            const editedContent = $scope.editedContentMap[oldFilePath];
                            if (editedContent) {
                                editedContent.path = newFilePath;
                                editedContent.name = newName;
                                delete $scope.editedContentMap[oldFilePath];
                                $scope.editedContentMap[newFilePath] = editedContent;
                            }
                        }
                    });
                    // In localStorage
                    const folderEditLocalStorage = getFolderEditLocalStorage();
                    for (let i=0; i<folderEditLocalStorage.tabsList.length; i++) {
                        const filePath = folderEditLocalStorage.tabsList[i];
                        if (isIncludedOrEqual(filePath, oldPath)) {
                            folderEditLocalStorage.tabsList[i] = filePath.replace(oldPath, newPath);
                        }
                    }
                    if (folderEditLocalStorage.activeTab && isIncludedOrEqual(folderEditLocalStorage.activeTab, oldPath)) {
                        folderEditLocalStorage.activeTab = folderEditLocalStorage.activeTab.replace(oldPath, newPath);
                    }
                    setFolderEditLocalStorage(folderEditLocalStorage);
                    // In devContents
                    const lastPathElementRegExp = new RegExp('/[^/]*$'); //no short form coz eslint doesn't like slash escape
                    const oldParent = (searchInDevContents(oldPath.replace(lastPathElementRegExp, '')) || []).pop();
                    if (oldParent && oldParent.children) {
                        //cut leaf from oldPath
                        const childidx = oldParent.children.findIndex(child => child.path === oldPath);
                        if (childidx !== -1) {
                            const leaf = oldParent.children.splice(childidx, 1)[0];
                            //paste leaf to newPath
                            const newParent = (searchInDevContents(newPath.replace(lastPathElementRegExp, '')) || []).pop();
                            if (newParent && newParent.children) {
                                function updatePath(leaf) {
                                    if (leaf) {
                                        leaf.path = leaf.path.replace(oldPath, newPath);
                                        leaf.name = leaf.path.split('/').at(-1);
                                        if (leaf.children) leaf.children.forEach(updatePath);
                                    }
                                }
                                updatePath(leaf);
                                newParent.children.push(leaf);
                            }
                        }
                    }
                };

                var propagatingMimeTypeChange = function(path, mimeType) {
                    for (var i = 0; i<$scope.tabsList.length; i++) {
                        var file = $scope.tabsList[i];
                        if (file.path == path) {
                            file.mimeType = mimeType;
                            break;
                        }
                    }
                }

                var decompressibleMimes = ['application/zip', 'application/x-bzip', 'application/x-bzip2', 'application/x-gzip', 'application/x-tar', 'application/gzip', 'application/bzip', 'application/bzip2', 'application/x-compressed-tar'];
                $scope.canBeDecompressed = function(content) {
                    return content && content.mimeType && decompressibleMimes.indexOf(content.mimeType) >= 0;
                };

                $scope.computeFileIconClass = function(file) {
                    if (file.fromGit) {
                        return 'dku-icon-git-file-16';
                    } else if ($scope.canBeDecompressed(file)) {
                        return 'dku-icon-file-zip-16';
                    } else if ($scope.isImage(file)) {
                        return 'dku-icon-image-16';
                    } else {
                        return 'dku-icon-file-text-16';
                    }
                };

                $scope.decompressContent = function(content) {
                    $scope.folderEditCallbacks.decompress(content).success(function(data){
                        $scope.listContents();
                    }).error(setErrorInScope.bind($scope));
                };

                $scope.addInElement = function(contentPath, isFolder, element) {
                    CreateModalFromTemplate("/templates/plugins/development/fragments/filename-prompt.html", $scope, null, function(newScope) {
                        resetErrorInScope(newScope)
                        newScope.isFolder = isFolder;
                        newScope.doCreation = function(fileName) {
                            $scope.folderEditCallbacks.create(contentPath + '/' + fileName, isFolder).success(function(data){
                                if (!isFolder && element && element.fromGit) {
                                    if (element.gitLib) {
                                        $scope.folderEditCallbacks.setDirty(element.gitLib);
                                    } else {
                                        $scope.folderEditCallbacks.setDirty(element.name)
                                    }
                                }
                                $scope.listContents().success(function() {
                                    if (!isFolder) {
                                        var newElPath = contentPath && contentPath.length > 0 ? contentPath + '/' + fileName : fileName;
                                        var newElement = searchInDevContents(newElPath);
                                        if (newElement) {
                                            $scope.openFile(newElement[newElement.length - 1]);
                                        }
                                    }
                                });
                            }).error(setErrorInScope.bind($scope));
                        };
                    });
                };

                var openFirstUpload = function(contentPath, firstUpload) {
                    $scope.listContents().success(function() {
                        var firstUploadPath = contentPath && contentPath.length > 0 ? contentPath + "/" + firstUpload.name : firstUpload.name;
                        var firstUploadPathObj = searchInDevContents(firstUploadPath);
                        if (firstUploadPathObj) {
                            $scope.openFile(firstUploadPathObj[firstUploadPathObj.length - 1]);
                        }
                    });
                };
                $scope.uploadElement = function(contentPath) {
                    CreateModalFromTemplate("/templates/plugins/development/fragments/upload-prompt.html", $scope, "UploadContentModalController", function(newScope) {
                        resetErrorInScope(newScope);
                        newScope.folderEditCallbacks = $scope.folderEditCallbacks;
                        newScope.openFirstUpload = openFirstUpload;
                        newScope.contentPath = contentPath;
                    });
                };

                $scope.downloadElement = function(content) {
                    let downloadUrl = $scope.folderEditCallbacks.downloadURL ? $scope.folderEditCallbacks.downloadURL(content) : undefined;
                    if (downloadUrl) {
                        downloadURL(downloadUrl);
                    } else {
                        Logger.warn("No download possible for " + content.path);
                    }
                };


                checkChangesBeforeLeaving($scope,  $scope.hasDirtyContent, $scope.folderEditSaveWarning);
                /*
                 * Git references actions
                 */

                $scope.gitRefActions = {
                    setModal: function (gitRef, gitRefPath) {
                        CreateModalFromTemplate("/templates/plugins/development/fragments/git-ref-prompt.html", $scope, "GitReferenceSetController", newScope => {
                            resetErrorInScope(newScope);
                            if (gitRef && gitRefPath) {
                                newScope.gitRef = gitRef;
                                newScope.gitRefPath = gitRefPath;
                                newScope.isEditingGitRef = true;
                            }
                            newScope.onSetCallback = () => { $scope.listContents(); };
                        });
                    },
                    listModal: function () {
                        $scope.listContents().then(() => {
                            CreateModalFromTemplate("/templates/plugins/development/fragments/git-ref-list.html", $scope, undefined, newScope => {
                                resetErrorInScope(newScope);
                                newScope.gitURL = url => {
                                    url = url.replace(/\.git(#.*)?$/, '')
                                    if (url.startsWith("git")) {
                                        url = url.replace(':', '/');
                                        url = url.replace('git@', "https://");
                                    }
                                    return url;
                                }
                            });
                        }, setErrorInScope.bind($scope));
                    },
                    isDirty: function (gitRefPath) {
                        return gitRefPath ? $scope.folderEditCallbacks.getDirty(gitRefPath) : $scope.folderEditCallbacks.getAllDirty();
                    },
                    doPull: function (gitRefPath) {
                        const pullGitRefAPI = gitRefPath ?
                            $scope.gitRefCallbacks.pullOne(gitRefPath) :
                            $scope.gitRefCallbacks.pullAll();
                        pullGitRefAPI.then(pullResult => {
                            FutureProgressModal.show($scope, pullResult.data, "Updating").then(futureResult => {
                                if (futureResult) {
                                    Dialogs.infoMessagesDisplayOnly($scope, "Update result", futureResult).then(() => {
                                        // If at least one of the pulls succeeded, we want to reload the state as files might have changed
                                        if (futureResult.messages.some(message => message['severity'] === 'SUCCESS')) {
                                            DKUtils.reloadState();
                                        }
                                    });
                                }
                            }, setErrorInScope.bind($scope));
                        }, setErrorInScope.bind($scope));
                    },
                    pullModal: function (gitRefPath) {
                        const state = $scope.gitRefActions.isDirty(gitRefPath);
                        state.then((dirtyState) => {
                            if (dirtyState.data) {
                                Dialogs.confirm($scope, pullText, 'Some files are unpushed, are you sure you want to '+pullText ,
                                    {btnConfirm: "Reset"})
                                    .then(()=> {$scope.gitRefActions.doPull (gitRefPath)}, angular.noop)
                            } else {
                                $scope.gitRefActions.doPull(gitRefPath);
                            }
                        });
                    },
                    rmModal: function (gitRefPath) {
                        Dialogs.confirm($scope, 'Remove Git reference', 'Are you sure you want to remove this Git reference and the associated folder?', {btnConfirm: "Remove"}).then(() => {
                            $scope.gitRefCallbacks.rm(gitRefPath, true).then(() => {
                                DKUtils.reloadState();
                            }, setErrorInScope.bind($scope))
                        }, angular.noop);
                    },
                    untrackModal: function (gitRefPath) {
                        Dialogs.confirm($scope, 'Untrack Git reference', 'Are you sure you want to untrack this Git reference and keep the associated folder?', {btnConfirm: "Untrack"}).then(() => {
                            $scope.gitRefCallbacks.rm(gitRefPath, false).then(() => {
                                DKUtils.reloadState();
                            }, setErrorInScope.bind($scope))
                        }, angular.noop);
                    },
                    pushModalWithCommitMessage: function (gitRefPath, commitMessage) {
                        const pushGitRefAPI = gitRefPath ?
                            $scope.gitRefCallbacks.pushOne(commitMessage, gitRefPath) :
                            $scope.gitRefCallbacks.pushAll(commitMessage);

                            pushGitRefAPI.then(pushResult => {
                            const title = pushResult.config.params.gitReferencePath ? "Pushing library " + pushResult.config.params.gitReferencePath : "Pushing all " + Object.keys($scope.gitReferences).length + " libraries";
                            FutureProgressModal.show($scope, pushResult.data, title).then(futureResult => {
                                if (futureResult) {
                                    const toDisplay = Object.assign({}, futureResult, { messages: futureResult.messages.filter(message => (message['code']  !== 'INFO_GIT_PUSH_CONFLICTING_FILE')) });
                                    Dialogs.infoMessagesDisplayOnly($scope, "Push result", toDisplay).then(() => {
                                        // If at least one of the pushs succeeded, we want to reload the state as files might have changed
                                        if (futureResult.messages.some(message => (message['severity'] === 'SUCCESS') || (message['code'] === 'INFO_GIT_PUSH_CONFLICTING_FILE'))) {
                                            if (gitRefPath) { //If only one library is push, we open all conflicting files
                                                const conflictingFiles = futureResult.messages.filter(message => message['code']  === 'INFO_GIT_PUSH_CONFLICTING_FILE');
                                                conflictingFiles.forEach(file => {
                                                    $scope.reloadFileUponConflict(gitRefPath + "/" + file['details']);
                                                });
                                            }
                                        }
                                    });
                                    $scope.reloadContents();
                                }
                            }, setErrorInScope.bind($scope));
                        }, setErrorInScope.bind($scope));
                    },
                    push:function (gitRefPath = null) {
                        let standardMessage = "Library update from DSS";
                        var options = {type: 'textarea', btnConfirm: "Commit"};
                        Dialogs.prompt($scope, "Enter your commit message", "Commit message", standardMessage, options).then(function (newMessage) {
                            $scope.gitRefActions.pushModalWithCommitMessage(gitRefPath, newMessage);
                        }, angular.noop)
                    },
                    pushModal: function(gitRefPath = null){
                        if ($scope.hasDirtyContent()) {
                            var options = { btnConfirm: "Save", positive: true};
                            Dialogs.confirm($scope, "Unsaved files", "You have unsaved files. Do you want to save them before?", options).then(function() {
                                $scope.saveAll();
                                $scope.gitRefActions.push(gitRefPath)
                            }, angular.noop);
                        } else {
                            $scope.gitRefActions.push(gitRefPath);
                        }
                    },
                    makeResolve: function(currentFile) {
                        var options = { btnConfirm: "Mark", positive: true};
                        Dialogs.confirm($scope, "Mark as resolved", "<p>Do you really want to mark this file as resolved?</p><p>You won't be able to mark as unresolved.</p>", options).then(function(){
                            $scope.gitRefCallbacks.markAsResolved(currentFile.path, currentFile.gitLib).then(result => {
                                currentFile.isResolved = true;
                                currentFile.isInConflict = false;
                                $scope.reloadContents();
                           }, error => Dialogs.displaySerializedError($scope, error));
                       }, angular.noop);
                    },
                    markAsResolved: function() {
                        if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                            var currentFile = $scope.tabsList[$scope.activeTabIndex];
                            if ($scope.isContentDirty(currentFile)) {
                                var options = { btnConfirm: "Save and mark", positive: true};
                                Dialogs.confirm($scope, 'Save file',
                                "Your file has been modified. Do you want to save it and mark as resolved?<br/>" +
                                "You won't be able to mark as unresolved.", options
                                ).then(function() {
                                    $scope.saveCurrentContent();
                                    $scope.gitRefCallbacks.markAsResolved(currentFile.path, currentFile.gitLib).then(() => {
                                        currentFile.isResolved = true;
                                        currentFile.isInConflict = false;
                                        $scope.reloadContents();
                                    }, error => Dialogs.displaySerializedError($scope, error));
                                }, angular.noop);
                            } else {
                                $scope.gitRefActions.makeResolve(currentFile);
                            }
                       } else {
                            Dialogs.error($scope, "Mark as resolved", "Unable to find this file");
                       }
                    },
                    restoreLibToPreviousVersion: function() {
                        if ($scope.activeTabIndex > -1 && $scope.activeTabIndex < $scope.tabsList.length) {
                            var currentFile = $scope.tabsList[$scope.activeTabIndex];
                            var options = { btnConfirm: "Restore"};
                            Dialogs.confirm($scope, "Restore the library to your previous version", "Do you really want to rollback to the previous version. This will replace the current (conflicting) files with the files you were editing before trying to push your library.", options).then(function(){
                                $scope.gitRefCallbacks.revertAllFiles(currentFile.gitLib).then(result => {
                                    if (result) {
                                        $scope.reloadContents();
                                    }
                                }, error => Dialogs.displaySerializedError($scope, error));
                            }, angular.noop);
                        } else {
                            Dialogs.error($scope, "Restore to previous version", "Unable to find this file");
                        }
                    },
                };


                /*
                 * UI Utils
                 */

                $scope.getMarginFromDepth = function(depth) {
                    return (depth + 1)*15 + 10;
                }

                $scope.getCarretLeftPosition = function(depth) {
                    return $scope.getMarginFromDepth(depth - 1);
                }

                $scope.containsFolder = function(element) {
                    if (!element.children) {
                        return false;
                    }
                    for (var i=0; i<element.children.length; i++) {
                        var e = element.children[i];
                        if (typeof(e.children) !== "undefined") {
                            return true;
                        }
                    }
                    return false;
                }

                $scope.isImage = function(element) {
                    return element.mimeType.startsWith('image');
                }

                $scope.emptyCtaBtnAction = function() {
                    if ($scope.emptyCta && $scope.emptyCta.btnAction) {
                        switch ($scope.emptyCta.btnAction) {
                            case 'create':
                                $scope.addInElement('', false);
                                break;
                            case 'upload':
                                $scope.uploadElement('');
                                break;
                            default:
                                return false;
                        }
                    }
                }


                /*
                 * Utils
                 */

                var isIncludedOrEqual = function(path, path2) {
                    return path.startsWith(path2 + "/") || path == path2;
                }
            }
        };
    });

    app.controller("NewFileModalController", function($scope, DataikuAPI, $state, $stateParams, WT1){
        $scope.fileName = null;
        $scope.create = function() {
            $scope.doCreation($scope.fileName);
            $scope.dismiss();
        };
    });

    app.controller("GitReferenceSetController", function($scope, $stateParams, DKUtils, DataikuAPI, ActivityIndicator, CreateModalFromTemplate, SpinnerService) {
        $scope.gitRef = $scope.gitRef || {
            remote: '',
            remotePath: '',
            checkout: ''
        };
        $scope.gitRefPath = $scope.gitRefPath || '';
        $scope.addPythonPath = true;
        $scope.isGitRefPathUnique = true;

        $scope.$watch("gitRefPath", function(gitRefPath) {
            if (!$scope.isEditingGitRef) {
                $scope.isGitRefPathUnique = !gitRefPath || !(gitRefPath in $scope.gitReferences);
            }
        });

        $scope.setGitRef = function() {
            $scope.gitRefCallbacks.set($scope.gitRef, $scope.gitRefPath, $scope.addPythonPath).then(result => {
                ActivityIndicator.success('Git reference successfully set.');
                if ($scope.onSetCallback) {
                    $scope.onSetCallback();
                }
                $scope.gitRefPath = result.data.refPath;
                $scope.gitRefActions.pullModal($scope.gitRefPath);
            }, setErrorInScope.bind($scope));
        };
    });

    app.controller("MoveContentModalController", function($scope) {
        $scope.uiState = {moveToTop : false, destination : null};

        $scope.changeDestination = function(to) {
            $scope.uiState.destination = to;
            var recClearMoveToHere = function(l) {
                l.forEach(function(e) {
                    if (e != to) {
                        e.moveToHere = false;
                        if (e.children) {
                            recClearMoveToHere(e.children);
                        }
                    }
                });
            };
            recClearMoveToHere($scope.devContents);
            if (to != null) {
                $scope.uiState.moveToTop = false;
                to.moveToHere = true;
            } else {
                $scope.uiState.moveToTop = true;
            }
        };

        $scope.hasNowhereToGo = function() {
            if ($scope.uiState.moveToTop) {
                return false;
            } else if ($scope.uiState.destination && $scope.uiState.destination.moveToHere) {
                return false;
            } else {
                return true;
            }
        }

        $scope.move = function() {
            if ($scope.uiState.moveToTop) {
                $scope.doMove(null);
            } else if ($scope.uiState.destination && $scope.uiState.destination.moveToHere) {
                $scope.doMove($scope.uiState.destination);
            }
            $scope.dismiss();
        };
    });

    app.controller("UploadContentModalController", function($scope, DataikuAPI, $state, $stateParams, WT1, Logger) {
        $scope.toUpload = [];

        $scope.selectedCount = function() {
            return $scope.toUpload.filter(function(f) {return f.$selected;}).length;
        };
        $scope.startedCount = function() {
            return $scope.toUpload.filter(function(f) {return f.started;}).length;
        };
        $scope.doneCount = function() {
            return $scope.toUpload.filter(function(f) {return f.done;}).length;
        };

        var getPathForFileToUpload = function(fileToUpload) {
            return fileToUpload.name;
        };
        var isAlreadyListed = function(filePath) {
            var found = false;
            $scope.toUpload.forEach(function(u) {
                found |= filePath == u.name;
            });
            return found;
        };
        $scope.uploadFiles = function(files) {
            var filePaths = [];
            var newFiles = [];
            for (var i = 0, len = files.length; i < len ; i++) { // no forEach() on the files :(
                var file = files[i];
                var filePath = getPathForFileToUpload(file);
                if (!isAlreadyListed(filePath)) {
                    filePaths.push(filePath);
                    newFiles.push(file);
                }
            }
            $scope.doCheckUpload(filePaths).success(function(data) {
                for (var i = 0, len = newFiles.length; i < len ; i++) { // no forEach() on the files :(
                    var file = newFiles[i];
                    var feasability = data.feasabilities[i];
                    $scope.toUpload.push({file:file, name:getPathForFileToUpload(file), feasability:feasability, $selected:feasability.canUpload});
                }
            }).error(setErrorInScope.bind($scope));
        };

        $scope.upload = function() {
            $scope.doUpload($scope.toUpload.filter(function(f) {return f.$selected;}));
        };

        $scope.goToFirstUploaded = function() {
            var succeeded = $scope.toUpload.filter(function(f) {return f.succeeded != null;})[0];
            if (succeeded != null) {
                $scope.openFirstUpload($scope.contentPath, succeeded);
            }
            $scope.dismiss();
        };
        var checkUploadCompletion = function() {
            if ($scope.startedCount() == 1 && $scope.startedCount() == $scope.doneCount()) {
                var succeeded = $scope.toUpload.filter(function(f) {return f.succeeded != null;})[0];
                if (succeeded != null) {
                    $scope.goToFirstUploaded();
                }
            }
        };
        $scope.doUpload = function(filesToUpload) {
            filesToUpload.forEach(function(fileToUpload) {
                fileToUpload.started = true;
                $scope.folderEditCallbacks.upload($scope.contentPath, fileToUpload.file, function (e) {
                    if (e.lengthComputable) {
                        $scope.$apply(function () {
                            fileToUpload.progress = Math.round(e.loaded * 100 / e.total);
                        });
                    }
              }).then(function (data) {
                  Logger.info("file " + fileToUpload.name + "uploaded", data);
                  fileToUpload.done = true;
                  fileToUpload.succeeded = JSON.parse(data);
                  checkUploadCompletion();
              }, function(payload){
                  Logger.info("file " + fileToUpload.name + "could not be uploaded", payload);
                  fileToUpload.done = true;
                  fileToUpload.failed = getErrorDetails(JSON.parse(payload.response), payload.status, function(h){return payload.getResponseHeader(h)}, payload.statusText);
                  fileToUpload.failed.html = getErrorHTMLFromDetails(fileToUpload.failed);
                  checkUploadCompletion();
              });
            });
        };
        $scope.doCheckUpload = function(filePaths) {
            return $scope.folderEditCallbacks.checkUpload($scope.contentPath, filePaths);
        };
    });
})();
