(function () {
    'use strict';
    var app = angular.module('dataiku.recipes');

    app.controller("GeoJoinRecipeCreationController", function ($scope, $controller, $stateParams, DataikuAPI, Fn, RecipeComputablesService) {
        $controller("JoinRecipeCreationController", {$scope: $scope});
        $scope.recipeType = "geojoin";
        $scope.recipe = {
            type: 'geojoin',
            projectKey: $stateParams.projectKey,
            inputs: {
                main: {
                    items: []
                }
            },
            outputs: {
                main: {
                    items: []
                }
            }
        };

        $scope.autosetName = function () {
            if ($scope.io.inputDataset) {
                var niceInputName = $scope.io.inputDataset.replace(/[A-Z]*\./, "");
                $scope.maybeSetNewDatasetName(niceInputName + "_joined");
            }
        };

        $scope.$watchCollection('recipe.inputs.main.items', function (nv) {
            if (nv && nv.length) {
                $scope.io.inputDataset = nv[0].ref;
            }
        })
    });

    app.controller("GeoJoinRecipeController",
        ['$scope', '$controller', '$q', '$stateParams', 'DataikuAPI', 'Dialogs', 'PartitionDeps', 'CreateModalFromTemplate', 'RecipesUtils', 'Logger', 'CodeMirrorSettingService', '$timeout',
            function ($scope, $controller, $q, $stateParams, DataikuAPI, Dialogs, PartitionDeps, CreateModalFromTemplate, RecipesUtils, Logger, CodeMirrorSettingService, $timeout) {
                $controller('JoinRecipeController', {$scope: $scope});
                $scope.uiState = {
                    currentStep: 'join',
                    computedColumns: []
                }
                $scope.isGeo = true;
                $scope.joinRecipeType = 'GEO';
                $scope.distanceTypeHint = {
                    'TOUCHES': 'Geometries should not overlap'
                }
                $scope.joinDistanceTypes = {
                    'DWITHIN': 'Is within distance of',
                    'BEYOND': 'Is beyond distance of',
                    'CONTAINS': 'Contains',
                    'WITHIN': 'Is contained within',
                    'INTERSECTS': 'Intersects',
                    'DISJOINT': 'Is disjoint to',
                    'TOUCHES': 'Touches',
                    'EQ': 'Is strictly equal to'
                }
                $scope.availableDistances = function () {
                    return Object.keys($scope.joinDistanceTypes)
                };
                $scope.isThresholdNeeded = function (distanceType) {
                    return distanceType === 'DWITHIN' || distanceType === 'BEYOND';
                }

                $scope.getJoinColumns = function (virtualInputIndex) {
                    if (!$scope.uiState.joinableColumns || !$scope.uiState.joinableColumns[virtualInputIndex]) {
                        $scope.uiState.joinableColumns = $scope.uiState.joinableColumns || {};
                        $scope.uiState.joinableColumns[virtualInputIndex] = $scope.getColumnsWithComputed(virtualInputIndex)
                            .filter(e => e.type === 'geopoint' || e.type === 'geometry');
                    }
                    return $scope.uiState.joinableColumns[virtualInputIndex];
                }

                $scope.guessDistanceType = function (condition) {
                    // Take the first non-EXACT distance available, if there's non default to EXACT or undefined if
                    // no distances are available
                    if (condition.type) {
                        return;
                    }
                    const availableDistances = $scope.availableDistances(condition);
                    const matchingAvailableDistance = availableDistances.find(e => {
                        return e && e !== 'EXACT';
                    });
                    if (matchingAvailableDistance) {
                        condition.type = matchingAvailableDistance;
                    } else if (availableDistances.length) {
                        condition.type = availableDistances[0];
                    }
                };

                $scope.addEmptyCondition = function (join, current, el) {
                    const table1JoinColumns = $scope.getJoinColumns(join.table1);
                    const table2JoinColumns = $scope.getJoinColumns(join.table2);
                    if (!table1JoinColumns.length || !table2JoinColumns.length){
                        return;
                    }

                    const newCondition = {
                        column1: {
                            table: join.table1,
                            name: table1JoinColumns[0].name
                        },
                        column2: {
                            table: join.table2,
                            name: table2JoinColumns[0].name
                        },
                        threshold: 100,
                        unit: "METER"
                    };

                    $scope.guessDistanceType(newCondition);

                    join.on = join.on || [];
                    join.on.push(newCondition);
                    if (current) {
                        current.condition = join.on[join.on.length - 1];
                    }
                    if (el) {
                        $timeout(() => {
                            el.scrollTop = el.scrollHeight;
                        });
                    }
                };

                $scope.getSuggestionsFunction = DataikuAPI.flow.recipes.geojoin.getSuggestions;

                function sendRecipeParamsToWT1() {
                    $scope.tryRecipeWT1Event('geo-join-params', () => {
                        function createFilterWT1Entry(filter) {
                            if (!filter){
                                return undefined;
                            }
                            return {
                                enabled: filter.enabled,
                                mode: filter.uiData && filter.uiData.mode,
                                distinct: filter.distinct,
                                geoContains: filter.uiData && filter.uiData.mode === 'CUSTOM' && filter.expression.includes('geoContains')
                            };
                        }

                        return {
                            "joins": JSON.stringify($scope.params.joins.map(join => {
                                return {
                                    "engine": $scope.recipeStatus && $scope.recipeStatus.selectedEngine && $scope.recipeStatus.selectedEngine.label,
                                    "type": join.type,
                                    "conditionsMode": join.conditionsMode,
                                    "on": join.on.map(on => {
                                            const column1 = $scope.getColumn($scope.getDatasetName(on.column1.table), on.column1.name);
                                            const column2 = $scope.getColumn($scope.getDatasetName(on.column2.table), on.column2.name);
                                            return {
                                                conditionsMode: on.conditionsMode,
                                                threshold: on.threshold,
                                                type: on.type,
                                                unit: on.unit,
                                                column1: column1 ? column1.type : null,
                                                column2: column2 ? column2.type : null,
                                            };
                                        }
                                    )
                                }
                            })),
                            "postFilter": JSON.stringify(createFilterWT1Entry($scope.params.postFilter)),
                            "preFilters": JSON.stringify($scope.params.virtualInputs.map(i => createFilterWT1Entry(i.preFilter)))
                        };
                    }, 'Failed to report Geo join params');
                }

                const originalSave = $scope.hooks.save;
                $scope.hooks.save = function () {
                    sendRecipeParamsToWT1();
                    return originalSave();
                };
            }]);

    app.controller("NewVirtualInputController", function ($scope, $stateParams, DatasetUtils) {
        $scope.newInput = {};

        $scope.isValid = function () {
            return !!$scope.newInput.dataset;
        };

        $scope.addInput = function () {
            $scope.addDataset($scope.newInput.dataset);
        };

        DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey, "geojoin").then(function (data) {
            $scope.availableInputDatasets = data[0];
        });
    });

})();
