
self.importScripts('/static/third/kdbush/kdbush.min.js');
self.onmessage = function(event) {
    const pair = event.data.pair;
    const pairDef = event.data.pairDef;
    const index = new KDBush(pair.afterFilterRecords);
    /*
     * Extracted from scatter-data-wrapper.model.ts
     * because we are in worker context.
     */
    const uaRawVal = (data, uaDimensionType, index) => {
        if (uaDimensionType === 'num' && data.num) {
            return data.num.data[index];
        } else if (uaDimensionType === 'ts' && data.ts) {
            return data.ts.data[index];
        } else if (uaDimensionType === 'str' && data.str) {
            const value = data.str.data[index];
            if (value !== undefined) {
                return data.str.sortedMapping[value].sortOrder;
            }
            return value;
        }
        return undefined;
    };

    for (let i = 0; i < pair.afterFilterRecords; i++) {
        const x = uaRawVal(pair['xAxis'], pairDef.x, i);
        const y = uaRawVal(pair['yAxis'], pairDef.y, i);

        if (x !== undefined && y !== undefined) {
            index.add(x, y);
        }
    }
    index.finish();
    self.postMessage(index.data, [index.data]);
};
