(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('aggregatedGeoZone', function($parse, ChartsStaticData, translate, Ng2MenuOrchestratorService) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/aggregated-geo-zone/aggregated-geo-zone.directive.html',
            scope: true,
            link: function($scope, element, attrs) {
                const defaultAggregationOptions = [
                    { value: ChartsStaticData.GEOM_AGGREGATIONS.DEFAULT, label: translate('CHARTS.DROPPED_DIMENSION.KEEP_DUPLICATES', 'Keep duplicates') },
                    { value: ChartsStaticData.GEOM_AGGREGATIONS.DISTINCT, label: translate('CHARTS.DROPPED_DIMENSION.MAKE_UNIQUE', 'Make unique') }
                ];
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.chartDefKey = attrs.chartDefKey;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.aggregationOptions = defaultAggregationOptions;
                $scope.$watch(attrs.uaColor, function(newUaColor) {
                    $scope.showAggregate = (newUaColor.length === 0);
                    if ($scope.showAggregate) {
                        $scope.aggregationOptions = defaultAggregationOptions;
                    } else {
                        $scope.aggregationOptions = [];
                    }
                }, true);

                $scope.getLabel = function(aggregationFunction) {
                    if (aggregationFunction === ChartsStaticData.GEOM_AGGREGATIONS.DISTINCT) {
                        return translate('CHARTS.DROPPED_DIMENSION.UNIQUE', '(UNIQUE)');
                    } else {
                        return '';
                    }
                };

                $scope.openMatMenu = function(menuIdx, event) {
                    Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey, menuIdx, event);
                };
            }
        };
    });
})();
