(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('monovaluedStdAggrMeasureZone', function($parse, ChartFeatures, ChartLabels, ChartCustomMeasures, ColorUtils, DefaultDSSVisualizationTheme, Ng2MenuOrchestratorService) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-measure-zone/monovalued-std-aggr-measure-zone.directive.html',
            scope: true,
            controller: 'StdAggregatedMeasureController',
            link: function($scope, _element, attrs) {
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.chartDefKey = attrs.chartDefKey;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.foregroundColors = [];
                $scope.themeColors = [];

                $scope.$watch(attrs.theme, (nv, ov) => {
                    $scope.theme = nv;
                    $scope.themeColors = ColorUtils.getThemeColorsWithBlackWhite($scope.theme);
                    if (nv && (!ov || !_.isEqual(nv.colors, ov.colors) || !$scope.foregroundColors.length)) {
                        const paletteColors = ColorUtils.generateThemePaletteColors(nv.colors, $scope.themeColors.length > 0);
                        if (paletteColors) {
                            $scope.foregroundColors = paletteColors.foregroundColors;
                        }
                    } else if (!nv) {
                        $scope.foregroundColors = ColorUtils.generateThemePaletteColors(DefaultDSSVisualizationTheme.colors, false).foregroundColors;
                    }
                    $scope.defaultFormatting = $scope.theme ? { fontColor: $scope.theme.generalFormatting.fontColor } : {};
                });

                $scope.openMatMenu = function(menuIdx, event) {
                    Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey, menuIdx, event);
                };
            }
        };
    });
})();
