(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('GroupedColumnsChart', GroupedColumnsChart);

    /**
     * (!) This service previously was in static/dataiku/js/simple_report/column-bars/column.js
     */
    function GroupedColumnsChart(ChartManager, ChartDataUtils, ChartDataWrapperFactory, GroupedColumnsDrawer, GroupedColumnsUtils, ReferenceLines, ColumnAvailability, ChartUsableColumns, ChartYAxisPosition, ChartAxesUtils, ChartCustomMeasures, SVGUtils, ChartDimension, CHART_VARIANTS) {
        return function($container, chartDef, chartHandler, axesDef, data) {
            const chartData = ChartDataWrapperFactory.chartGroupedColumnsDataWrapper(data, axesDef, chartDef);
            const dataSpec = chartHandler.getDataSpec();

            const customMeasures = ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey, dataSpec.datasetName, chartHandler.getCurrentChartsContext());
            const allMeasures = ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey, dataSpec.datasetName, chartHandler.getCurrentChartsContext()).filter(m => ['NUMERICAL', 'ALPHANUM', 'DATE'].includes(m.type));
            const xSpec = { type: 'DIMENSION', mode: 'COLUMNS', dimension: ChartDimension.getGenericDimension(chartDef), name: 'x', customExtent: chartDef.xAxisFormatting.customExtent };
            ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures, allMeasures, customMeasures);

            const yExtents = ChartDataUtils.getMeasureExtents(chartDef, chartData, 'x'),
                leftYAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT),
                rightYAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT),
                isLeftYPercentScale = yExtents[leftYAxisID].onlyPercent,
                isRightYPercentScale = yExtents[rightYAxisID].onlyPercent;

            const displayedReferenceLines = ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines, xSpec, undefined),
                referenceLinesValues = ReferenceLines.getReferenceLinesValues(displayedReferenceLines, chartData, allMeasures, chartDef.genericMeasures, customMeasures),
                referenceLinesExtents = ReferenceLines.getReferenceLinesExtents(displayedReferenceLines, referenceLinesValues, { [leftYAxisID]: { isPercentScale: isLeftYPercentScale }, [rightYAxisID]: { isPercentScale: isRightYPercentScale } });


            ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(chartData, 'x', xSpec.dimension), referenceLinesExtents.x, xSpec);
            const animationData = GroupedColumnsUtils.prepareData(chartDef, chartData);
            // specific to waterfal chart, we retrieve the y extent from the chartData
            const firstMeasure = chartDef.genericMeasures[0];
            if (chartDef.variant === CHART_VARIANTS.waterfall && firstMeasure) {
                yExtents[firstMeasure.displayAxis === 'axis1' ? leftYAxisID : rightYAxisID].extent = [animationData.minTotal, animationData.maxTotal];
            }

            const leftYExtent = ReferenceLines.getExtentWithReferenceLines(yExtents[leftYAxisID].extent, referenceLinesExtents[leftYAxisID]),
                rightYExtent = ReferenceLines.getExtentWithReferenceLines(yExtents[rightYAxisID].extent, referenceLinesExtents[rightYAxisID]);

            const drawFrame = function(frameIdx, chartBase) {
                ReferenceLines.removeReferenceLines($container[0]);

                chartData.fixAxis('animation', frameIdx);
                animationData.frames[frameIdx].facets.forEach(function(facetData, f) {
                    // init the collision detection
                    const labelCollisionDetectionHandler = SVGUtils.initLabelCollisionDetection(chartBase);
                    const g = d3.select(chartBase.$svgs.eq(f).find('g.chart').get(0));
                    GroupedColumnsDrawer(g, chartDef, chartHandler, chartData.fixAxis('facet', f), chartBase, facetData.groups, f, labelCollisionDetectionHandler);
                });
            };

            const leftYCustomExtent = ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting, leftYAxisID);
            const rightYCustomExtent = ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting, rightYAxisID);
            const ySpecs = {
                [leftYAxisID]: { id: leftYAxisID, type: 'MEASURE', extent: leftYExtent, isPercentScale: isLeftYPercentScale, customExtent: leftYCustomExtent, position: ChartYAxisPosition.LEFT },
                [rightYAxisID]: { id: rightYAxisID, type: 'MEASURE', extent: rightYExtent, isPercentScale: isRightYPercentScale, customExtent: rightYCustomExtent, position: ChartYAxisPosition.RIGHT }
            };

            const availableAxes = ReferenceLines.getAvailableAxesForReferenceLines(chartDef);

            const axisSpecs = { x: xSpec, ...ySpecs };

            ChartAxesUtils.setNumberOfBinsToDimensions(chartData, chartDef, axisSpecs);

            ReferenceLines.updateAvailableAxisOptions([
                { axis: 'LEFT_Y_AXIS', isDisplayed: availableAxes['LEFT_Y_AXIS'], isNumerical: true, isPercentScale: ySpecs[leftYAxisID].isPercentScale },
                { axis: 'RIGHT_Y_AXIS', isDisplayed: availableAxes['RIGHT_Y_AXIS'], isNumerical: true, isPercentScale: ySpecs[rightYAxisID].isPercentScale },
                { axis: 'X_AXIS', isDisplayed: true, isNumerical: ChartAxesUtils.isNumerical(xSpec) && !ChartDimension.hasOneTickPerBin(xSpec.dimension), isContinuousDate: ChartAxesUtils.isContinuousDate(xSpec) }
            ]);

            ChartManager.initChart(chartDef, chartHandler, chartData, $container, drawFrame,
                axisSpecs,
                { type: 'DIMENSION', name: 'color', dimension: chartDef.genericDimension1[0], ignoreColorDim: () => !!chartData.ignoreColorDimension });
        };
    }
})();
