(function() {
    "use strict";

    /**
     * <opals-help-center-empty-state/>
     *
     * @param { Object } appConfig
     */
    const opalsHelpCenterEmptyState = {
        templateUrl: "/static/dataiku/opals/opals-help-center-empty-state/opals-help-center-empty-state.component.html",
        controller: function opalsHelpCenterEmptyStateController(
            $rootScope,
            $element,
            OpalsService,
            TOPBAR_DRAWER_DOCKED_STATES,
            TOPBAR_DRAWER_IDS,
            TOPBAR_DRAWER_MINIMIZED_STATES,
            TopbarDrawersService
        ) {
            const ctrl = this;

            ctrl.$onInit = function() {
                OpalsService.getHelpCenterUrl().then(function(url) {
                  ctrl.helpCenterUrl = url;
                });
                ctrl.drawer = TopbarDrawersService.getDrawer(TOPBAR_DRAWER_IDS.OPALS_HELP);
                ctrl.dssVersion = $rootScope.appConfig ? $rootScope.appConfig.version.product_version : null;
            };

            ctrl.DRAWER_DOCKED_STATES = TOPBAR_DRAWER_DOCKED_STATES;
            ctrl.DRAWER_MINIMIZED_STATES = TOPBAR_DRAWER_MINIMIZED_STATES;

            $element.on("keydown", function(event) {
                if (event.key === "Escape") {
                    $rootScope.$apply(() => {
                        ctrl.drawer.hide();
                    });
                    event.preventDefault();
                }
            });
        }
    };

    angular.module("dataiku.opals").component("opalsHelpCenterEmptyState", opalsHelpCenterEmptyState);
})();
