(function(){
    "use strict";

    // Call with searchNotebookCreateDatasetModalDirective
    const searchNotebookCreateDatasetModal = {
        bindings : {
            modalControl: "<",
            schema: "<",
            elasticSearchQuery: "<",
            index: "<",
            connection: "<"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-create-dataset-modal/search-notebook-create-dataset-modal.component.html",
        controller: function($element, $scope, DataikuAPI, $state, $stateParams) {
            const $ctrl = this;
            let datasetNames = null;
            $ctrl.datasetName = null;

            $ctrl.$onInit = () => {
                DataikuAPI.datasets.listNames($stateParams.projectKey)
                .then(({data}) => {
                    datasetNames = data.map(d => d.toLowerCase());
                })
                .catch(setErrorInScope.bind($scope));
            };

            $ctrl.createDataset = function () {
                const dataset = {
                    name: $ctrl.datasetName,
                    schema: $ctrl.schema,
                    type: "ElasticSearch",
                    params: {
                        connection: $ctrl.connection,
                        index: $ctrl.index
                    }
                };
                if ($ctrl.elasticSearchQuery && $ctrl.elasticSearchQuery.trim().length > 0) {
                    dataset.params.customQueryDsl = JSON.stringify({
                        query: { query_string: { query: $ctrl.elasticSearchQuery } }
                    });
                }
                DataikuAPI.datasets.create($stateParams.projectKey, dataset).then(({data}) => {
                    $state.go('projects.project.datasets.dataset.explore', {datasetName : data.name, projectKey: $stateParams.projectKey});
                })
                .then($ctrl.modalControl.resolve)
                .catch(setErrorInScope.bind($scope));
            };

            $ctrl.isDatasetNameUnique = function (v) {
                if (!v || v.trim().length === 0 || !datasetNames) {
                    return true;
                }
                return !datasetNames.includes(v.trim().toLowerCase());
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookCreateDatasetModal", searchNotebookCreateDatasetModal);
})();