# Test entry point for the remote workers implementations
import os
import sys

from dataiku.base.socket_block_link import JavaLink
from dataiku.doctor.distributed.remote_worker_client import WorkerMonitor, RemoteWorkerClient
from dataiku.doctor.distributed.work_scheduler import AbstractContext


class Context(AbstractContext):

    def execute_work(self, v):
        return v + "-worker"


if __name__ == "__main__":
    link = JavaLink(int(sys.argv[1]), sys.argv[2])
    link.connect()

    # Read some value produced by the backend
    value = link.read_string()

    # Add "master" to prove the master code has been executed
    value += "-master"

    # Start a remote worker
    remote_worker_pool_id = os.getenv("REMOTE_WORKER_POOL_ID")
    remote_worker = RemoteWorkerClient(remote_worker_pool_id, WorkerMonitor())
    remote_worker.start(Context())

    # Let the remote worker transform the value
    value = remote_worker.execute_work(value)

    # Stop the worker
    remote_worker.stop()

    # Send back the value to the test server
    link.send_string(value)
