from dataiku.eda.types import Literal

import numpy as np
import pandas as pd

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.computations.timeseries.time_series_computation import format_iso8601
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import MaxTimeModel, MaxTimeResultModel


class MaxTime(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["max_time"]:
        return "max_time"

    @staticmethod
    def build(params: MaxTimeModel) -> 'MaxTime':
        return MaxTime(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> MaxTimeResultModel:
        dates = idf.date_col(self.column)
        max_date = np.max(dates)

        if max_date is pd.NaT:
            raise NoDataError()

        return {
            "type": MaxTime.get_type(),
            "timestamp": format_iso8601(max_date),
        }
